/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;

public class IPAddress {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    public static boolean isValid(String string) {
        return IPAddress.isValidIPv4(string) || IPAddress.isValidIPv6(string);
    }

    private static boolean isValidIPv4(String string) {
        int n2;
        if (string.length() == 0) {
            return false;
        }
        int n3 = 0;
        String string2 = string + ".";
        int n4 = 0;
        while (n4 < string2.length() && (n2 = string2.indexOf(46, n4)) > n4) {
            BigInteger bigInteger;
            if (n3 == 4) {
                return false;
            }
            try {
                bigInteger = new BigInteger(string2.substring(n4, n2));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (bigInteger.compareTo(ZERO) == -1 || bigInteger.compareTo(BigInteger.valueOf(255L)) == 1) {
                return false;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 4;
    }

    private static boolean isValidIPv6(String string) {
        int n2;
        if (string.length() == 0) {
            return false;
        }
        int n3 = 0;
        String string2 = string + ":";
        int n4 = 0;
        while (n4 < string2.length() && (n2 = string2.indexOf(58, n4)) > n4) {
            BigInteger bigInteger;
            if (n3 == 8) {
                return false;
            }
            try {
                bigInteger = new BigInteger(string2.substring(n4, n2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (bigInteger.compareTo(ZERO) == -1 || bigInteger.compareTo(BigInteger.valueOf(65535L)) == 1) {
                return false;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 8;
    }
}

