/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.sasn1.DerObject;

public class Asn1ObjectIdentifier
extends DerObject {
    private String _oid;

    Asn1ObjectIdentifier(int n2, byte[] byArray) throws IOException {
        super(n2, 6, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        boolean bl = true;
        int n3 = 0;
        BigInteger bigInteger = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while ((n3 = byteArrayInputStream.read()) >= 0) {
            if (l2 < 0x80000000000000L) {
                l2 = l2 * 128L + (long)(n3 & 0x7F);
                if ((n3 & 0x80) != 0) continue;
                if (bl) {
                    switch ((int)l2 / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            l2 -= 40L;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            l2 -= 80L;
                        }
                    }
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(l2);
                l2 = 0L;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.shiftLeft(7);
            bigInteger = bigInteger.or(BigInteger.valueOf(n3 & 0x7F));
            if ((n3 & 0x80) != 0) continue;
            stringBuffer.append('.');
            stringBuffer.append(bigInteger);
            bigInteger = null;
            l2 = 0L;
        }
        this._oid = stringBuffer.toString();
    }

    public Asn1ObjectIdentifier(String string) throws IllegalArgumentException {
        super(0, 6, Asn1ObjectIdentifier.toByteArray(string));
        this._oid = string;
    }

    public String toString() {
        return this._oid;
    }

    public int hashCode() {
        return this._oid.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1ObjectIdentifier)) {
            return false;
        }
        return this._oid.equals(((Asn1ObjectIdentifier)object)._oid);
    }

    private static void writeField(OutputStream outputStream, long l2) throws IOException {
        if (l2 >= 128L) {
            if (l2 >= 16384L) {
                if (l2 >= 0x200000L) {
                    if (l2 >= 0x10000000L) {
                        if (l2 >= 0x800000000L) {
                            if (l2 >= 0x40000000000L) {
                                if (l2 >= 0x2000000000000L) {
                                    if (l2 >= 0x100000000000000L) {
                                        outputStream.write((int)(l2 >> 56) | 0x80);
                                    }
                                    outputStream.write((int)(l2 >> 49) | 0x80);
                                }
                                outputStream.write((int)(l2 >> 42) | 0x80);
                            }
                            outputStream.write((int)(l2 >> 35) | 0x80);
                        }
                        outputStream.write((int)(l2 >> 28) | 0x80);
                    }
                    outputStream.write((int)(l2 >> 21) | 0x80);
                }
                outputStream.write((int)(l2 >> 14) | 0x80);
            }
            outputStream.write((int)(l2 >> 7) | 0x80);
        }
        outputStream.write((int)l2 & 0x7F);
    }

    private static void writeField(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        int n2 = (bigInteger.bitLength() + 6) / 7;
        if (n2 == 0) {
            outputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            outputStream.write(byArray);
        }
    }

    private static byte[] toByteArray(String string) throws IllegalArgumentException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Asn1ObjectIdentifier.writeField((OutputStream)byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
            while (oIDTokenizer.hasMoreTokens()) {
                String string2 = oIDTokenizer.nextToken();
                if (string2.length() < 18) {
                    Asn1ObjectIdentifier.writeField((OutputStream)byteArrayOutputStream, Long.parseLong(string2));
                    continue;
                }
                Asn1ObjectIdentifier.writeField((OutputStream)byteArrayOutputStream, new BigInteger(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("exception parsing field value: " + numberFormatException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("exception converting to bytes: " + iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static class OIDTokenizer {
        private String oid;
        private int index;

        public OIDTokenizer(String string) {
            this.oid = string;
            this.index = 0;
        }

        public boolean hasMoreTokens() {
            return this.index != -1;
        }

        public String nextToken() {
            if (this.index == -1) {
                return null;
            }
            int n2 = this.oid.indexOf(46, this.index);
            if (n2 == -1) {
                String string = this.oid.substring(this.index);
                this.index = -1;
                return string;
            }
            String string = this.oid.substring(this.index, n2);
            this.index = n2 + 1;
            return string;
        }
    }
}

