/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends FilterInputStream
implements SharedInputStream {
    private final SharedFileInputStream _parent;
    private final File _file;
    private final long _start;
    private final long _length;
    private long _position;
    private long _markedPosition;
    private List _subStreams = new LinkedList();

    public SharedFileInputStream(String string) throws IOException {
        this(new File(string));
    }

    public SharedFileInputStream(File file) throws IOException {
        this(file, 0L, file.length());
    }

    private SharedFileInputStream(File file, long l2, long l3) throws IOException {
        super(new BufferedInputStream(new FileInputStream(file)));
        this._parent = null;
        this._file = file;
        this._start = l2;
        this._length = l3;
        this.in.skip(l2);
    }

    private SharedFileInputStream(SharedFileInputStream sharedFileInputStream, long l2, long l3) throws IOException {
        super(new BufferedInputStream(new FileInputStream(sharedFileInputStream._file)));
        this._parent = sharedFileInputStream;
        this._file = sharedFileInputStream._file;
        this._start = l2;
        this._length = l3;
        this.in.skip(l2);
    }

    public long getPosition() {
        return this._position;
    }

    public InputStream newStream(long l2, long l3) {
        try {
            SharedFileInputStream sharedFileInputStream = l3 < 0L ? (this._length > 0L ? new SharedFileInputStream(this, this._start + l2, this._length - l2) : (this._length == 0L ? new SharedFileInputStream(this, this._start + l2, 0L) : new SharedFileInputStream(this, this._start + l2, -1L))) : new SharedFileInputStream(this, this._start + l2, l3 - l2);
            this._subStreams.add(sharedFileInputStream);
            return sharedFileInputStream;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to create shared stream: " + iOException);
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (n3 == 0) {
            return 0;
        }
        for (n5 = 0; n5 < n3 && (n4 = this.read()) >= 0; ++n5) {
            byArray[n2 + n5] = (byte)n4;
        }
        if (n5 == 0) {
            return -1;
        }
        return n5;
    }

    public int read() throws IOException {
        if (this._position == this._length) {
            return -1;
        }
        ++this._position;
        return this.in.read();
    }

    public boolean markSupported() {
        return true;
    }

    public long skip(long l2) throws IOException {
        long l3;
        for (l3 = 0L; l3 != l2 && this.read() >= 0; ++l3) {
        }
        return l3;
    }

    public void mark(int n2) {
        this._markedPosition = this._position;
        this.in.mark(n2);
    }

    public void reset() throws IOException {
        this._position = this._markedPosition;
        this.in.reset();
    }

    public SharedFileInputStream getRoot() {
        if (this._parent != null) {
            return this._parent.getRoot();
        }
        return this;
    }

    public void dispose() throws IOException {
        Iterator iterator = this._subStreams.iterator();
        while (iterator.hasNext()) {
            try {
                ((SharedFileInputStream)iterator.next()).dispose();
            }
            catch (IOException iOException) {}
        }
        this.in.close();
    }
}

