/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;

public class TlsUtils {
    static byte[] toByteArray(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = (byte)cArray[i2];
        }
        return byArray;
    }

    protected static void writeUint8(short s, OutputStream outputStream) throws IOException {
        outputStream.write(s);
    }

    protected static void writeUint8(short s, byte[] byArray, int n2) {
        byArray[n2] = (byte)s;
    }

    protected static void writeUint16(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
    }

    protected static void writeUint16(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 8);
        byArray[n3 + 1] = (byte)n2;
    }

    protected static void writeUint24(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >> 16);
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
    }

    protected static void writeUint24(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3 + 2] = (byte)n2;
    }

    protected static void writeUint32(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l2 >> 24));
        outputStream.write((int)(l2 >> 16));
        outputStream.write((int)(l2 >> 8));
        outputStream.write((int)l2);
    }

    protected static void writeUint32(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 24);
        byArray[n2 + 1] = (byte)(l2 >> 16);
        byArray[n2 + 2] = (byte)(l2 >> 8);
        byArray[n2 + 3] = (byte)l2;
    }

    protected static void writeUint64(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l2 >> 56));
        outputStream.write((int)(l2 >> 48));
        outputStream.write((int)(l2 >> 40));
        outputStream.write((int)(l2 >> 32));
        outputStream.write((int)(l2 >> 24));
        outputStream.write((int)(l2 >> 16));
        outputStream.write((int)(l2 >> 8));
        outputStream.write((int)l2);
    }

    protected static void writeUint64(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 56);
        byArray[n2 + 1] = (byte)(l2 >> 48);
        byArray[n2 + 2] = (byte)(l2 >> 40);
        byArray[n2 + 3] = (byte)(l2 >> 32);
        byArray[n2 + 4] = (byte)(l2 >> 24);
        byArray[n2 + 5] = (byte)(l2 >> 16);
        byArray[n2 + 6] = (byte)(l2 >> 8);
        byArray[n2 + 7] = (byte)l2;
    }

    protected static short readUint8(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (short)n2;
    }

    protected static int readUint16(InputStream inputStream) throws IOException {
        int n2;
        int n3 = inputStream.read();
        if ((n3 | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n3 << 8 | n2;
    }

    protected static int readUint24(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n4 << 16 | n3 << 8 | n2;
    }

    protected static long readUint32(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = inputStream.read();
        if ((n5 | (n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (long)n5 << 24 | (long)n4 << 16 | (long)n3 << 8 | (long)n2;
    }

    protected static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) != -1) continue;
            throw new EOFException();
        } while ((n2 += n3) != byArray.length);
    }

    protected static void checkVersion(byte[] byArray, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        if (byArray[0] != 3 || byArray[1] != 1) {
            tlsProtocolHandler.failWithError((short)2, (short)70);
        }
    }

    protected static void checkVersion(InputStream inputStream, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n2 != 3 || n3 != 1) {
            tlsProtocolHandler.failWithError((short)2, (short)70);
        }
    }

    protected static void writeVersion(OutputStream outputStream) throws IOException {
        outputStream.write(3);
        outputStream.write(1);
    }

    private static void hmac_hash(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        KeyParameter keyParameter = new KeyParameter(byArray);
        byte[] byArray4 = byArray2;
        int n2 = digest.getDigestSize();
        int n3 = (byArray3.length + n2 - 1) / n2;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i2 = 0; i2 < n3; ++i2) {
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n2 * i2, Math.min(n2, byArray3.length - n2 * i2));
        }
    }

    protected static void PRF(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray, 0, byArray5, 0, n2);
        System.arraycopy(byArray, byArray.length - n2, byArray6, 0, n2);
        byte[] byArray7 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray7, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray7, byArray2.length, byArray3.length);
        byte[] byArray8 = new byte[byArray4.length];
        TlsUtils.hmac_hash(new MD5Digest(), byArray5, byArray7, byArray8);
        TlsUtils.hmac_hash(new SHA1Digest(), byArray6, byArray7, byArray4);
        for (int i2 = 0; i2 < byArray4.length; ++i2) {
            int n3 = i2;
            byArray4[n3] = (byte)(byArray4[n3] ^ byArray8[i2]);
        }
    }
}

