/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsBlockCipherCipherSuite
extends TlsCipherSuite {
    private BlockCipher encryptCipher;
    private BlockCipher decryptCipher;
    private Digest writeDigest;
    private Digest readDigest;
    private int cipherKeySize;
    private short keyExchange;
    private TlsMac writeMac;
    private TlsMac readMac;

    protected TlsBlockCipherCipherSuite(BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n2, short s) {
        this.encryptCipher = blockCipher;
        this.decryptCipher = blockCipher2;
        this.writeDigest = digest;
        this.readDigest = digest2;
        this.cipherKeySize = n2;
        this.keyExchange = s;
    }

    protected void init(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2 = 2 * this.cipherKeySize + 2 * this.writeDigest.getDigestSize() + 2 * this.encryptCipher.getBlockSize();
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray5, byArray3.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        TlsUtils.PRF(byArray, TlsUtils.toByteArray("key expansion"), byArray5, byArray4);
        int n3 = 0;
        this.writeMac = new TlsMac(this.writeDigest, byArray4, n3, this.writeDigest.getDigestSize());
        this.readMac = new TlsMac(this.readDigest, byArray4, n3 += this.writeDigest.getDigestSize(), this.readDigest.getDigestSize());
        this.initCipher(true, this.encryptCipher, byArray4, this.cipherKeySize, n3 += this.readDigest.getDigestSize(), n3 + this.cipherKeySize * 2);
        this.initCipher(false, this.decryptCipher, byArray4, this.cipherKeySize, n3 += this.cipherKeySize, n3 + this.cipherKeySize + this.decryptCipher.getBlockSize());
    }

    private void initCipher(boolean bl, BlockCipher blockCipher, byte[] byArray, int n2, int n3, int n4) {
        KeyParameter keyParameter = new KeyParameter(byArray, n3, n2);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray, n4, blockCipher.getBlockSize());
        blockCipher.init(bl, parametersWithIV);
    }

    protected byte[] encodePlaintext(short s, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = this.encryptCipher.getBlockSize();
        int n6 = n5 - (n3 + this.writeMac.getSize() + 1) % n5;
        int n7 = n3 + this.writeMac.getSize() + n6 + 1;
        byte[] byArray2 = new byte[n7];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        byte[] byArray3 = this.writeMac.calculateMac(s, byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        int n8 = n3 + byArray3.length;
        for (n4 = 0; n4 <= n6; ++n4) {
            byArray2[n4 + n8] = (byte)n6;
        }
        for (n4 = 0; n4 < n7; n4 += n5) {
            this.encryptCipher.processBlock(byArray2, n4, byArray2, n4);
        }
        return byArray2;
    }

    protected byte[] decodeCiphertext(short s, byte[] byArray, int n2, int n3, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        int n4;
        int n5;
        int n6 = this.decryptCipher.getBlockSize();
        boolean bl = false;
        for (n5 = 0; n5 < n3; n5 += n6) {
            this.decryptCipher.processBlock(byArray, n5 + n2, byArray, n5 + n2);
        }
        n5 = byArray[n2 + n3 - 1];
        if (n2 + n3 - 1 - n5 < 0) {
            bl = true;
            n5 = 0;
        } else {
            for (n4 = 0; n4 <= n5; ++n4) {
                if (byArray[n2 + n3 - 1 - n4] == n5) continue;
                bl = true;
            }
        }
        n4 = n3 - this.readMac.getSize() - n5 - 1;
        byte[] byArray2 = this.readMac.calculateMac(s, byArray, n2, n4);
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[n2 + n4 + i2] == byArray2[i2]) continue;
            bl = true;
        }
        if (bl) {
            tlsProtocolHandler.failWithError((short)2, (short)20);
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n2, byArray3, 0, n4);
        return byArray3;
    }

    protected short getKeyExchangeAlgorithm() {
        return this.keyExchange;
    }
}

