/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;

class IndefiniteLengthInputStream
extends LimitedInputStream {
    private int _b1;
    private int _b2;
    private boolean _eofReached = false;
    private boolean _eofOn00 = true;

    IndefiniteLengthInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this._b1 = inputStream.read();
        this._b2 = inputStream.read();
        this._eofReached = this._b2 < 0;
    }

    void setEofOn00(boolean bl) {
        this._eofOn00 = bl;
    }

    boolean checkForEof() {
        if (this._eofOn00 && this._b1 == 0 && this._b2 == 0) {
            this._eofReached = true;
            this.setParentEofDetect(true);
        }
        return this._eofReached;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._eofOn00 || n3 < 3) {
            return super.read(byArray, n2, n3);
        }
        if (this._eofReached) {
            return -1;
        }
        int n4 = this._in.read(byArray, n2 + 2, n3 - 2);
        if (n4 < 0) {
            this._eofReached = true;
            return -1;
        }
        byArray[n2] = (byte)this._b1;
        byArray[n2 + 1] = (byte)this._b2;
        this._b1 = this._in.read();
        this._b2 = this._in.read();
        if (this._b2 < 0) {
            this._eofReached = true;
        }
        return n4 + 2;
    }

    public int read() throws IOException {
        if (this.checkForEof()) {
            return -1;
        }
        int n2 = this._in.read();
        if (n2 < 0) {
            this._eofReached = true;
            return -1;
        }
        int n3 = this._b1;
        this._b1 = this._b2;
        this._b2 = n2;
        return n3;
    }
}

