/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTags;

public class DEROutputStream
extends FilterOutputStream
implements DERTags {
    public DEROutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void writeLength(int n2) throws IOException {
        if (n2 > 127) {
            int n3 = 1;
            int n4 = n2;
            while ((n4 >>>= 8) != 0) {
                ++n3;
            }
            this.write((byte)(n3 | 0x80));
            for (int i2 = (n3 - 1) * 8; i2 >= 0; i2 -= 8) {
                this.write((byte)(n2 >> i2));
            }
        } else {
            this.write((byte)n2);
        }
    }

    void writeEncoded(int n2, byte[] byArray) throws IOException {
        this.write(n2);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.write(5);
        this.write(0);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof DERObject) {
            ((DERObject)object).encode(this);
        } else if (object instanceof DEREncodable) {
            ((DEREncodable)object).getDERObject().encode(this);
        } else {
            throw new IOException("object not DEREncodable");
        }
    }
}

