/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;

public class DERObjectIdentifier
extends ASN1Object {
    String identifier;

    public static DERObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERObjectIdentifier.getInstance(aSN1TaggedObject.getObject());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (l2 < 0x80000000000000L) {
                l2 = l2 * 128L + (long)(n2 & 0x7F);
                if ((n2 & 0x80) != 0) continue;
                if (bl) {
                    switch ((int)l2 / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            l2 -= 40L;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            l2 -= 80L;
                        }
                    }
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(l2);
                l2 = 0L;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.shiftLeft(7);
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) != 0) continue;
            stringBuffer.append('.');
            stringBuffer.append(bigInteger);
            bigInteger = null;
            l2 = 0L;
        }
        this.identifier = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        if (!DERObjectIdentifier.isValidIdentifier(string)) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream outputStream, long l2) throws IOException {
        if (l2 >= 128L) {
            if (l2 >= 16384L) {
                if (l2 >= 0x200000L) {
                    if (l2 >= 0x10000000L) {
                        if (l2 >= 0x800000000L) {
                            if (l2 >= 0x40000000000L) {
                                if (l2 >= 0x2000000000000L) {
                                    if (l2 >= 0x100000000000000L) {
                                        outputStream.write((int)(l2 >> 56) | 0x80);
                                    }
                                    outputStream.write((int)(l2 >> 49) | 0x80);
                                }
                                outputStream.write((int)(l2 >> 42) | 0x80);
                            }
                            outputStream.write((int)(l2 >> 35) | 0x80);
                        }
                        outputStream.write((int)(l2 >> 28) | 0x80);
                    }
                    outputStream.write((int)(l2 >> 21) | 0x80);
                }
                outputStream.write((int)(l2 >> 14) | 0x80);
            }
            outputStream.write((int)(l2 >> 7) | 0x80);
        }
        outputStream.write((int)l2 & 0x7F);
    }

    private void writeField(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        int n2 = (bigInteger.bitLength() + 6) / 7;
        if (n2 == 0) {
            outputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            outputStream.write(byArray);
        }
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        Object object;
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        this.writeField((OutputStream)byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            object = oIDTokenizer.nextToken();
            if (((String)object).length() < 18) {
                this.writeField((OutputStream)byteArrayOutputStream, Long.parseLong((String)object));
                continue;
            }
            this.writeField((OutputStream)byteArrayOutputStream, new BigInteger((String)object));
        }
        dEROutputStream2.close();
        object = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, (byte[])object);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)dERObject).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 < '0' || c2 > '2') {
            return false;
        }
        boolean bl = false;
        for (int i2 = string.length() - 1; i2 >= 2; --i2) {
            char c3 = string.charAt(i2);
            if ('0' <= c3 && c3 <= '9') {
                bl = true;
                continue;
            }
            if (c3 == '.') {
                if (!bl) {
                    return false;
                }
                bl = false;
                continue;
            }
            return false;
        }
        return bl;
    }
}

