/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.IntrospectionUtils;

public class MethodMap {
    private static final int INCOMPARABLE = 0;
    private static final int MORE_SPECIFIC = 1;
    private static final int EQUIVALENT = 2;
    private static final int LESS_SPECIFIC = 3;
    private static final int NOT_CONVERTIBLE = 0;
    private static final int EXPLICITLY_CONVERTIBLE = 1;
    private static final int IMPLCITLY_CONVERTIBLE = 2;
    private static final int STRICTLY_CONVERTIBLE = 3;
    ConversionHandler conversionHandler;
    Map methodByNameMap = new ConcurrentHashMap();

    public MethodMap() {
        this(null);
    }

    public MethodMap(ConversionHandler conversionHandler) {
        this.conversionHandler = conversionHandler;
    }

    public void add(Method method) {
        String string = method.getName();
        ArrayList<Method> arrayList = this.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Method>();
            this.methodByNameMap.put(string, arrayList);
        }
        arrayList.add(method);
    }

    public List get(String string) {
        return (List)this.methodByNameMap.get(string);
    }

    public Method find(String string, Object[] objectArray) throws AmbiguousException {
        List list = this.get(string);
        if (list == null) {
            return null;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            classArray[i2] = object == null ? null : object.getClass();
        }
        return this.getBestMatch(list, classArray);
    }

    private static boolean onlyNullOrObjects(Class[] classArray) {
        for (Class clazz : classArray) {
            if (clazz == null || clazz == Object.class) continue;
            return false;
        }
        return classArray.length > 0;
    }

    private Method getBestMatch(List<Method> list, Class[] classArray) {
        LinkedList<Match> linkedList = new LinkedList<Match>();
        Class[] classArray2 = new Class[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            classArray2[i2] = IntrospectionUtils.getUnboxedClass(classArray[i2]);
        }
        for (Method method : list) {
            int n2 = this.getApplicability(method, classArray2);
            if (n2 <= 0) continue;
            Match match = new Match(method, n2, classArray2);
            if (linkedList.size() == 0) {
                linkedList.add(match);
                continue;
            }
            boolean bl = true;
            ListIterator listIterator = linkedList.listIterator();
            while (bl && listIterator.hasNext()) {
                Match match2 = (Match)listIterator.next();
                if (match2.specificity == 3 && match.specificity < 2) {
                    bl = false;
                    continue;
                }
                if (match.specificity == 3 && match2.specificity < 2) {
                    listIterator.remove();
                    continue;
                }
                if (match2.applicability > match.applicability) {
                    bl = false;
                    continue;
                }
                if (match2.applicability < match.applicability) {
                    listIterator.remove();
                    continue;
                }
                if (MethodMap.onlyNullOrObjects(classArray)) {
                    if (match.varargs == match2.varargs) continue;
                    if (match.varargs) {
                        bl = false;
                        continue;
                    }
                    if (!match2.varargs) continue;
                    listIterator.remove();
                    continue;
                }
                switch (this.compare(match.methodTypes, match2.methodTypes)) {
                    case 3: {
                        bl = false;
                        break;
                    }
                    case 1: {
                        listIterator.remove();
                        break;
                    }
                }
            }
            if (!bl) continue;
            linkedList.add(match);
        }
        switch (linkedList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return ((Match)linkedList.get((int)0)).method;
            }
        }
        throw new AmbiguousException();
    }

    private int compare(Class[] classArray, Class[] classArray2) {
        boolean bl;
        int n2;
        Class<?> clazz;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (classArray.length > classArray2.length) {
            n3 = classArray2.length;
            if (n3 == 0) {
                return 1;
            }
            clazz = (classArray2 = Arrays.copyOf(classArray2, classArray.length))[n3 - 1].getComponentType();
            if (clazz == null) {
                bl2 = true;
                classArray2[classArray.length - 1] = null;
            } else {
                bl3 = true;
                for (n2 = n3 - 1; n2 < classArray.length; ++n2) {
                    classArray2[n2] = clazz;
                }
            }
            bl4 = true;
        } else if (classArray2.length > classArray.length) {
            n3 = classArray.length;
            if (n3 == 0) {
                return 3;
            }
            clazz = (classArray = Arrays.copyOf(classArray, classArray2.length))[n3 - 1].getComponentType();
            if (clazz == null) {
                bl3 = true;
                classArray[classArray2.length - 1] = null;
            } else {
                bl2 = true;
                for (n2 = n3 - 1; n2 < classArray2.length; ++n2) {
                    classArray[n2] = clazz;
                }
            }
            bl4 = true;
        }
        n3 = 3;
        int n4 = 3;
        block12: for (n2 = 0; n2 < classArray.length; ++n2) {
            boolean bl5 = bl = !bl4 && n2 == classArray.length - 1;
            if (classArray[n2] == classArray2[n2]) continue;
            if (classArray[n2] == null) {
                n4 = 0;
                if (!classArray2[n2].isPrimitive()) continue;
                n3 = 0;
                continue;
            }
            if (classArray2[n2] == null) {
                n3 = 0;
                if (!classArray[n2].isPrimitive()) continue;
                n4 = 0;
                continue;
            }
            switch (n3) {
                case 3: {
                    if (MethodMap.isStrictConvertible(classArray2[n2], classArray[n2], bl)) break;
                    n3 = 2;
                }
                case 2: {
                    if (this.isConvertible(classArray2[n2], classArray[n2], bl)) break;
                    n3 = 1;
                }
                case 1: {
                    if (this.isExplicitlyConvertible(classArray2[n2], classArray[n2], bl)) break;
                    n3 = 0;
                }
            }
            switch (n4) {
                case 3: {
                    if (MethodMap.isStrictConvertible(classArray[n2], classArray2[n2], bl)) continue block12;
                    n4 = 2;
                }
                case 2: {
                    if (this.isConvertible(classArray[n2], classArray2[n2], bl)) continue block12;
                    n4 = 1;
                }
                case 1: {
                    if (this.isExplicitlyConvertible(classArray[n2], classArray2[n2], bl)) continue block12;
                    n4 = 0;
                }
            }
        }
        if (n3 == 0 && n4 == 0) {
            return 0;
        }
        if (n3 > n4) {
            return 1;
        }
        if (n4 > n3) {
            return 3;
        }
        n2 = bl2 || !bl4 && classArray[classArray.length - 1].isArray() ? 1 : 0;
        boolean bl6 = bl = bl3 || !bl4 && classArray2[classArray2.length - 1].isArray();
        if (n2 != 0 && !bl) {
            return 3;
        }
        if (n2 == 0 && bl) {
            return 1;
        }
        return 2;
    }

    private int getApplicability(Method method, Class[] classArray) {
        Class<?>[] classArray2 = method.getParameterTypes();
        int n2 = 3;
        if (classArray2.length > classArray.length) {
            if (classArray2.length == classArray.length + 1 && classArray2[classArray2.length - 1].isArray()) {
                for (int i2 = 0; i2 < classArray.length; ++i2) {
                    if (MethodMap.isStrictConvertible(classArray2[i2], classArray[i2], false)) continue;
                    if (this.isConvertible(classArray2[i2], classArray[i2], false)) {
                        n2 = Math.min(n2, 2);
                        continue;
                    }
                    if (this.isExplicitlyConvertible(classArray2[i2], classArray[i2], false)) {
                        n2 = Math.min(n2, 1);
                        continue;
                    }
                    return 0;
                }
                return n2;
            }
            return 0;
        }
        if (classArray2.length == classArray.length) {
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                if (MethodMap.isStrictConvertible(classArray2[i3], classArray[i3], i3 == classArray.length - 1 && classArray2[i3].isArray())) continue;
                if (this.isConvertible(classArray2[i3], classArray[i3], i3 == classArray.length - 1 && classArray2[i3].isArray())) {
                    n2 = Math.min(n2, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(classArray2[i3], classArray[i3], i3 == classArray.length - 1 && classArray2[i3].isArray())) {
                    n2 = Math.min(n2, 1);
                    continue;
                }
                return 0;
            }
            return n2;
        }
        if (classArray2.length > 0) {
            Class<?> clazz = classArray2[classArray2.length - 1];
            if (!clazz.isArray()) {
                return 0;
            }
            for (int i4 = 0; i4 < classArray2.length - 1; ++i4) {
                if (MethodMap.isStrictConvertible(classArray2[i4], classArray[i4], false)) continue;
                if (this.isConvertible(classArray2[i4], classArray[i4], false)) {
                    n2 = Math.min(n2, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(classArray2[i4], classArray[i4], false)) {
                    n2 = Math.min(n2, 1);
                    continue;
                }
                return 0;
            }
            Class<?> clazz2 = clazz.getComponentType();
            for (int i5 = classArray2.length - 1; i5 < classArray.length; ++i5) {
                if (MethodMap.isStrictConvertible(clazz2, classArray[i5], false)) continue;
                if (this.isConvertible(clazz2, classArray[i5], false)) {
                    n2 = Math.min(n2, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(clazz2, classArray[i5], false)) {
                    n2 = Math.min(n2, 1);
                    continue;
                }
                return 0;
            }
            return n2;
        }
        return 0;
    }

    private boolean isConvertible(Class clazz, Class clazz2, boolean bl) {
        return IntrospectionUtils.isMethodInvocationConvertible(clazz, clazz2, bl);
    }

    private static boolean isStrictConvertible(Class clazz, Class clazz2, boolean bl) {
        return IntrospectionUtils.isStrictMethodInvocationConvertible(clazz, clazz2, bl);
    }

    private boolean isExplicitlyConvertible(Class clazz, Class clazz2, boolean bl) {
        return this.conversionHandler != null && this.conversionHandler.isExplicitlyConvertible(clazz, clazz2, bl);
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -2314636505414551663L;
    }

    private class Match {
        Method method;
        Class[] methodTypes;
        int specificity;
        int applicability;
        boolean varargs;

        Match(Method method, int n2, Class[] classArray) {
            this.method = method;
            this.applicability = n2;
            this.methodTypes = method.getParameterTypes();
            this.specificity = MethodMap.this.compare(this.methodTypes, classArray);
            this.varargs = this.methodTypes.length > 0 && this.methodTypes[this.methodTypes.length - 1].isArray();
        }
    }
}

