/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.util.Pair;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.Converter;
import org.apache.velocity.util.introspection.IntrospectionUtils;

public class ConversionHandlerImpl
implements ConversionHandler {
    static Map<Pair<? extends Class, ? extends Class>, Converter> standardConverterMap = new HashMap<Pair<? extends Class, ? extends Class>, Converter>();
    static Converter toString;
    static Converter cacheMiss;
    static final long minByte = -128L;
    static final long maxByte = 127L;
    static final long minShort = -32768L;
    static final long maxShort = 32767L;
    static final long minInt = Integer.MIN_VALUE;
    static final long maxInt = Integer.MAX_VALUE;
    static final double minLong = -9.223372036854776E18;
    static final double maxLong = 9.223372036854776E18;
    Map<Pair<? extends Class, ? extends Class>, Converter> converterCacheMap = new ConcurrentHashMap<Pair<? extends Class, ? extends Class>, Converter>();

    @Override
    public boolean isExplicitlyConvertible(Class clazz, Class clazz2, boolean bl) {
        if (clazz == clazz2 || IntrospectionUtils.isMethodInvocationConvertible(clazz, clazz2, bl) || this.getNeededConverter(clazz, clazz2) != null) {
            return true;
        }
        if (bl && clazz.isArray()) {
            if (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
            return this.isExplicitlyConvertible(clazz.getComponentType(), clazz2, false);
        }
        return false;
    }

    @Override
    public Converter getNeededConverter(final Class clazz, Class clazz2) {
        Pair<Class, Class> pair = new Pair<Class, Class>(clazz, clazz2);
        Converter converter = standardConverterMap.get(pair);
        if (converter == null && (converter = this.converterCacheMap.get(pair)) == null) {
            if (clazz == String.class) {
                converter = toString;
            } else if (clazz.isEnum() && clazz2 == String.class) {
                converter = new Converter(){

                    public Object convert(Object object) {
                        return Enum.valueOf(clazz, (String)object);
                    }
                };
            }
            this.converterCacheMap.put(pair, converter == null ? cacheMiss : converter);
        }
        return converter == cacheMiss ? null : converter;
    }

    @Override
    public void addConverter(Class clazz, Class clazz2, Converter converter) {
        Pair<Class, Class> pair = new Pair<Class, Class>(clazz, clazz2);
        this.converterCacheMap.put(pair, converter);
        if (clazz.isPrimitive()) {
            pair = new Pair<Class, Class>(IntrospectionUtils.getBoxedClass(clazz), clazz2);
            this.converterCacheMap.put(pair, converter);
        } else {
            Class clazz3 = IntrospectionUtils.getUnboxedClass(clazz);
            if (clazz3 != clazz) {
                pair = new Pair<Class, Class>(clazz3, clazz2);
                this.converterCacheMap.put(pair, converter);
            }
        }
    }

    static {
        cacheMiss = new Converter<Object>(){

            @Override
            public Object convert(Object object) {
                return object;
            }
        };
        Converter<Boolean> converter = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object object) {
                return object == null ? null : Boolean.valueOf(((Number)object).intValue() != 0);
            }
        };
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Byte>>(Boolean.class, Byte.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Short>>(Boolean.class, Short.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Integer>>(Boolean.class, Integer.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Long>>(Boolean.class, Long.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Float>>(Boolean.class, Float.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Double>>(Boolean.class, Double.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Number>>(Boolean.class, Number.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Byte>>(Boolean.class, Byte.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Short>>(Boolean.class, Short.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Integer>>(Boolean.class, Integer.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Long>>(Boolean.class, Long.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Float>>(Boolean.class, Float.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Double>>(Boolean.class, Double.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Byte>>(Boolean.TYPE, Byte.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Short>>(Boolean.TYPE, Short.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Integer>>(Boolean.TYPE, Integer.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Long>>(Boolean.TYPE, Long.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Float>>(Boolean.TYPE, Float.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Double>>(Boolean.TYPE, Double.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Number>>(Boolean.TYPE, Number.class), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Byte>>(Boolean.TYPE, Byte.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Short>>(Boolean.TYPE, Short.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Integer>>(Boolean.TYPE, Integer.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Long>>(Boolean.TYPE, Long.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Float>>(Boolean.TYPE, Float.TYPE), converter);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Double>>(Boolean.TYPE, Double.TYPE), converter);
        Converter<Boolean> converter2 = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object object) {
                return object == null ? null : Boolean.valueOf(((Character)object).charValue() != '\u0000');
            }
        };
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Character>>(Boolean.class, Character.class), converter2);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Character>>(Boolean.class, Character.TYPE), converter2);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Character>>(Boolean.TYPE, Character.class), converter2);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<Character>>(Boolean.TYPE, Character.TYPE), converter2);
        Converter<Boolean> converter3 = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object object) {
                return Boolean.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Boolean>, Class<String>>(Boolean.class, String.class), converter3);
        standardConverterMap.put(new Pair<Class<Boolean>, Class<String>>(Boolean.TYPE, String.class), converter3);
        Converter<Byte> converter4 = new Converter<Byte>(){

            @Override
            public Byte convert(Object object) {
                if (object == null) {
                    return null;
                }
                long l2 = ((Number)object).longValue();
                if (l2 < -128L || l2 > 127L) {
                    throw new NumberFormatException("value out of range for byte type: " + l2);
                }
                return ((Number)object).byteValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Byte>, Class<Short>>(Byte.class, Short.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Integer>>(Byte.class, Integer.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Long>>(Byte.class, Long.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Float>>(Byte.class, Float.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Double>>(Byte.class, Double.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Number>>(Byte.class, Number.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Short>>(Byte.class, Short.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Integer>>(Byte.class, Integer.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Long>>(Byte.class, Long.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Float>>(Byte.class, Float.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Double>>(Byte.class, Double.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Short>>(Byte.TYPE, Short.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Integer>>(Byte.TYPE, Integer.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Long>>(Byte.TYPE, Long.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Float>>(Byte.TYPE, Float.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Double>>(Byte.TYPE, Double.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Number>>(Byte.TYPE, Number.class), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Short>>(Byte.TYPE, Short.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Integer>>(Byte.TYPE, Integer.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Long>>(Byte.TYPE, Long.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Float>>(Byte.TYPE, Float.TYPE), converter4);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Double>>(Byte.TYPE, Double.TYPE), converter4);
        Converter<Byte> converter5 = new Converter<Byte>(){

            @Override
            public Byte convert(Object object) {
                return Byte.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Byte>, Class<String>>(Byte.class, String.class), converter5);
        standardConverterMap.put(new Pair<Class<Byte>, Class<String>>(Byte.TYPE, String.class), converter5);
        Converter<Short> converter6 = new Converter<Short>(){

            @Override
            public Short convert(Object object) {
                if (object == null) {
                    return null;
                }
                long l2 = ((Number)object).longValue();
                if (l2 < -32768L || l2 > 32767L) {
                    throw new NumberFormatException("value out of range for short type: " + l2);
                }
                return ((Number)object).shortValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Short>, Class<Integer>>(Short.class, Integer.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Long>>(Short.class, Long.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Float>>(Short.class, Float.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Double>>(Short.class, Double.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Number>>(Short.class, Number.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Integer>>(Short.class, Integer.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Long>>(Short.class, Long.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Float>>(Short.class, Float.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Double>>(Short.class, Double.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Integer>>(Short.TYPE, Integer.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Long>>(Short.TYPE, Long.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Float>>(Short.TYPE, Float.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Double>>(Short.TYPE, Double.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Number>>(Short.TYPE, Number.class), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Integer>>(Short.TYPE, Integer.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Long>>(Short.TYPE, Long.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Float>>(Short.TYPE, Float.TYPE), converter6);
        standardConverterMap.put(new Pair<Class<Short>, Class<Double>>(Short.TYPE, Double.TYPE), converter6);
        Converter<Short> converter7 = new Converter<Short>(){

            @Override
            public Short convert(Object object) {
                return Short.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Short>, Class<String>>(Short.class, String.class), converter7);
        standardConverterMap.put(new Pair<Class<Short>, Class<String>>(Short.TYPE, String.class), converter7);
        Converter<Integer> converter8 = new Converter<Integer>(){

            @Override
            public Integer convert(Object object) {
                if (object == null) {
                    return null;
                }
                long l2 = ((Number)object).longValue();
                if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                    throw new NumberFormatException("value out of range for integer type: " + l2);
                }
                return ((Number)object).intValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Integer>, Class<Long>>(Integer.class, Long.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Float>>(Integer.class, Float.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Double>>(Integer.class, Double.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Number>>(Integer.class, Number.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Long>>(Integer.class, Long.TYPE), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Float>>(Integer.class, Float.TYPE), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Double>>(Integer.class, Double.TYPE), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Long>>(Integer.TYPE, Long.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Float>>(Integer.TYPE, Float.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Double>>(Integer.TYPE, Double.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Number>>(Integer.TYPE, Number.class), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Long>>(Integer.TYPE, Long.TYPE), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Float>>(Integer.TYPE, Float.TYPE), converter8);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Double>>(Integer.TYPE, Double.TYPE), converter8);
        Converter<Integer> converter9 = new Converter<Integer>(){

            @Override
            public Integer convert(Object object) {
                if (object == null) {
                    return null;
                }
                return ((Number)object).intValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Integer>, Class<Short>>(Integer.class, Short.class), converter9);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Short>>(Integer.class, Short.TYPE), converter9);
        Converter<Integer> converter10 = new Converter<Integer>(){

            @Override
            public Integer convert(Object object) {
                return Integer.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Integer>, Class<String>>(Integer.class, String.class), converter10);
        standardConverterMap.put(new Pair<Class<Integer>, Class<String>>(Integer.TYPE, String.class), converter10);
        Converter<Long> converter11 = new Converter<Long>(){

            @Override
            public Long convert(Object object) {
                if (object == null) {
                    return null;
                }
                double d2 = ((Number)object).doubleValue();
                if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                    throw new NumberFormatException("value out of range for long type: " + d2);
                }
                return ((Number)object).longValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Long>, Class<Float>>(Long.class, Float.class), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Double>>(Long.class, Double.class), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Number>>(Long.class, Number.class), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Float>>(Long.class, Float.TYPE), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Double>>(Long.class, Double.TYPE), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Float>>(Long.TYPE, Float.class), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Double>>(Long.TYPE, Double.class), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Number>>(Long.TYPE, Number.class), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Float>>(Long.TYPE, Float.TYPE), converter11);
        standardConverterMap.put(new Pair<Class<Long>, Class<Double>>(Long.TYPE, Double.TYPE), converter11);
        Converter<Long> converter12 = new Converter<Long>(){

            @Override
            public Long convert(Object object) {
                if (object == null) {
                    return null;
                }
                return ((Number)object).longValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Long>, Class<Short>>(Long.class, Short.class), converter12);
        standardConverterMap.put(new Pair<Class<Long>, Class<Integer>>(Long.class, Integer.class), converter12);
        standardConverterMap.put(new Pair<Class<Long>, Class<Short>>(Long.class, Short.TYPE), converter12);
        standardConverterMap.put(new Pair<Class<Long>, Class<Integer>>(Long.class, Integer.TYPE), converter12);
        Converter<Long> converter13 = new Converter<Long>(){

            @Override
            public Long convert(Object object) {
                return Long.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Long>, Class<String>>(Long.class, String.class), converter13);
        standardConverterMap.put(new Pair<Class<Long>, Class<String>>(Long.TYPE, String.class), converter13);
        Converter<Float> converter14 = new Converter<Float>(){

            @Override
            public Float convert(Object object) {
                return object == null ? null : Float.valueOf(((Number)object).floatValue());
            }
        };
        standardConverterMap.put(new Pair<Class<Float>, Class<Double>>(Float.class, Double.class), converter14);
        standardConverterMap.put(new Pair<Class<Float>, Class<Number>>(Float.class, Number.class), converter14);
        standardConverterMap.put(new Pair<Class<Float>, Class<Double>>(Float.class, Double.TYPE), converter14);
        standardConverterMap.put(new Pair<Class<Float>, Class<Double>>(Float.TYPE, Double.class), converter14);
        standardConverterMap.put(new Pair<Class<Float>, Class<Number>>(Float.TYPE, Number.class), converter14);
        standardConverterMap.put(new Pair<Class<Float>, Class<Double>>(Float.TYPE, Double.TYPE), converter14);
        Converter<Float> converter15 = new Converter<Float>(){

            @Override
            public Float convert(Object object) {
                if (object == null) {
                    return null;
                }
                return Float.valueOf(((Number)object).floatValue());
            }
        };
        standardConverterMap.put(new Pair<Class<Float>, Class<Short>>(Float.class, Short.class), converter15);
        standardConverterMap.put(new Pair<Class<Float>, Class<Integer>>(Float.class, Integer.class), converter15);
        standardConverterMap.put(new Pair<Class<Float>, Class<Long>>(Float.class, Long.class), converter15);
        standardConverterMap.put(new Pair<Class<Float>, Class<Short>>(Float.class, Short.TYPE), converter15);
        standardConverterMap.put(new Pair<Class<Float>, Class<Integer>>(Float.class, Integer.TYPE), converter15);
        standardConverterMap.put(new Pair<Class<Float>, Class<Long>>(Float.class, Long.TYPE), converter15);
        Converter<Float> converter16 = new Converter<Float>(){

            @Override
            public Float convert(Object object) {
                return Float.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Float>, Class<String>>(Float.class, String.class), converter16);
        standardConverterMap.put(new Pair<Class<Float>, Class<String>>(Float.TYPE, String.class), converter16);
        Converter<Double> converter17 = new Converter<Double>(){

            @Override
            public Double convert(Object object) {
                if (object == null) {
                    return null;
                }
                return ((Number)object).doubleValue();
            }
        };
        standardConverterMap.put(new Pair<Class<Double>, Class<Short>>(Double.class, Short.class), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Integer>>(Double.class, Integer.class), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Long>>(Double.class, Long.class), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Float>>(Double.class, Float.class), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Number>>(Double.class, Number.class), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Short>>(Double.class, Short.TYPE), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Integer>>(Double.class, Integer.TYPE), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Long>>(Double.class, Long.TYPE), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Float>>(Double.class, Float.TYPE), converter17);
        standardConverterMap.put(new Pair<Class<Double>, Class<Number>>(Double.TYPE, Number.class), converter17);
        Converter<Double> converter18 = new Converter<Double>(){

            @Override
            public Double convert(Object object) {
                return Double.valueOf(String.valueOf(object));
            }
        };
        standardConverterMap.put(new Pair<Class<Double>, Class<String>>(Double.class, String.class), converter18);
        standardConverterMap.put(new Pair<Class<Double>, Class<String>>(Double.TYPE, String.class), converter18);
        Converter<Byte> converter19 = new Converter<Byte>(){

            @Override
            public Byte convert(Object object) {
                return object == null ? null : Byte.valueOf((Boolean)object != false ? (byte)1 : 0);
            }
        };
        standardConverterMap.put(new Pair<Class<Byte>, Class<Boolean>>(Byte.class, Boolean.class), converter19);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Boolean>>(Byte.class, Boolean.TYPE), converter19);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Boolean>>(Byte.TYPE, Boolean.class), converter19);
        standardConverterMap.put(new Pair<Class<Byte>, Class<Boolean>>(Byte.TYPE, Boolean.TYPE), converter19);
        Converter<Short> converter20 = new Converter<Short>(){

            @Override
            public Short convert(Object object) {
                return object == null ? null : Short.valueOf((Boolean)object != false ? (short)1 : 0);
            }
        };
        standardConverterMap.put(new Pair<Class<Short>, Class<Boolean>>(Short.class, Boolean.class), converter20);
        standardConverterMap.put(new Pair<Class<Short>, Class<Boolean>>(Short.class, Boolean.TYPE), converter20);
        standardConverterMap.put(new Pair<Class<Short>, Class<Boolean>>(Short.TYPE, Boolean.class), converter20);
        standardConverterMap.put(new Pair<Class<Short>, Class<Boolean>>(Short.TYPE, Boolean.TYPE), converter20);
        Converter<Integer> converter21 = new Converter<Integer>(){

            @Override
            public Integer convert(Object object) {
                return object == null ? null : ((Boolean)object != false ? Integer.valueOf(1) : Integer.valueOf(0));
            }
        };
        standardConverterMap.put(new Pair<Class<Integer>, Class<Boolean>>(Integer.class, Boolean.class), converter21);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Boolean>>(Integer.class, Boolean.TYPE), converter21);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Boolean>>(Integer.TYPE, Boolean.class), converter21);
        standardConverterMap.put(new Pair<Class<Integer>, Class<Boolean>>(Integer.TYPE, Boolean.TYPE), converter21);
        Converter<Long> converter22 = new Converter<Long>(){

            @Override
            public Long convert(Object object) {
                return object == null ? null : Long.valueOf((Boolean)object != false ? 1L : 0L);
            }
        };
        standardConverterMap.put(new Pair<Class<Long>, Class<Boolean>>(Long.class, Boolean.class), converter22);
        standardConverterMap.put(new Pair<Class<Long>, Class<Boolean>>(Long.class, Boolean.TYPE), converter22);
        standardConverterMap.put(new Pair<Class<Long>, Class<Boolean>>(Long.TYPE, Boolean.class), converter22);
        standardConverterMap.put(new Pair<Class<Long>, Class<Boolean>>(Long.TYPE, Boolean.TYPE), converter22);
        toString = new Converter<String>(){

            @Override
            public String convert(Object object) {
                return String.valueOf(object);
            }
        };
    }
}

