/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.MethodMap;
import org.slf4j.Logger;

public class ClassMap {
    private static final boolean debugReflection = true;
    private final Logger log;
    private final Class clazz;
    private final MethodCache methodCache;

    public ClassMap(Class clazz, Logger logger) {
        this(clazz, logger, null);
    }

    public ClassMap(Class clazz, Logger logger, ConversionHandler conversionHandler) {
        this.clazz = clazz;
        this.log = logger;
        logger.debug("=================================================================");
        logger.debug("== Class: {}", (Object)clazz);
        this.methodCache = this.createMethodCache(conversionHandler);
        logger.debug("=================================================================");
    }

    public Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String string, Object[] objectArray) throws MethodMap.AmbiguousException {
        return this.methodCache.get(string, objectArray);
    }

    private MethodCache createMethodCache(ConversionHandler conversionHandler) {
        MethodCache methodCache = new MethodCache(this.log, conversionHandler);
        for (Class clazz = this.getCachedClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] classArray;
            if (Modifier.isPublic(clazz.getModifiers())) {
                this.populateMethodCacheWith(methodCache, clazz);
            }
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                this.populateMethodCacheWithInterface(methodCache, clazz2);
            }
        }
        return methodCache;
    }

    private void populateMethodCacheWithInterface(MethodCache methodCache, Class clazz) {
        Class<?>[] classArray;
        if (Modifier.isPublic(clazz.getModifiers())) {
            this.populateMethodCacheWith(methodCache, clazz);
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            this.populateMethodCacheWithInterface(methodCache, clazz2);
        }
    }

    private void populateMethodCacheWith(MethodCache methodCache, Class clazz) {
        this.log.debug("Reflecting {}", (Object)clazz);
        try {
            Method[] methodArray;
            for (Method method : methodArray = clazz.getDeclaredMethods()) {
                int n2 = method.getModifiers();
                if (!Modifier.isPublic(n2)) continue;
                methodCache.put(method);
            }
        }
        catch (SecurityException securityException) {
            this.log.debug("While accessing methods of {}:", (Object)clazz, (Object)securityException);
        }
    }

    private static final class MethodCache {
        private static final Object CACHE_MISS = new Object();
        private static final String NULL_ARG = Object.class.getName();
        private static final Map convertPrimitives = new HashMap();
        private final Logger log;
        private final Map cache = new ConcurrentHashMap();
        private final MethodMap methodMap;

        private MethodCache(Logger logger, ConversionHandler conversionHandler) {
            this.log = logger;
            this.methodMap = new MethodMap(conversionHandler);
        }

        public Method get(String string, Object[] objectArray) throws MethodMap.AmbiguousException {
            String string2 = this.makeMethodKey(string, objectArray);
            Object object = this.cache.get(string2);
            if (object == CACHE_MISS) {
                return null;
            }
            if (object == null) {
                try {
                    object = this.methodMap.find(string, objectArray);
                }
                catch (MethodMap.AmbiguousException ambiguousException) {
                    this.cache.put(string2, CACHE_MISS);
                    throw ambiguousException;
                }
                this.cache.put(string2, object != null ? object : CACHE_MISS);
            }
            return (Method)object;
        }

        private void put(Method method) {
            String string = this.makeMethodKey(method);
            if (this.cache.get(string) == null) {
                this.cache.put(string, method);
                this.methodMap.add(method);
                this.log.debug("Adding {}", (Object)method);
            }
        }

        private String makeMethodKey(Method method) {
            Class<?>[] classArray = method.getParameterTypes();
            int n2 = classArray.length;
            if (n2 == 0) {
                return method.getName();
            }
            StringBuilder stringBuilder = new StringBuilder((n2 + 1) * 16).append(method.getName());
            for (Class<?> clazz : classArray) {
                if (clazz.isPrimitive()) {
                    stringBuilder.append((String)convertPrimitives.get(clazz));
                    continue;
                }
                stringBuilder.append(clazz.getName());
            }
            return stringBuilder.toString();
        }

        private String makeMethodKey(String string, Object[] objectArray) {
            int n2 = objectArray.length;
            if (n2 == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder((n2 + 1) * 16).append(string);
            for (Object object : objectArray) {
                if (object == null) {
                    stringBuilder.append(NULL_ARG);
                    continue;
                }
                stringBuilder.append(object.getClass().getName());
            }
            return stringBuilder.toString();
        }

        static {
            convertPrimitives.put(Boolean.TYPE, Boolean.class.getName());
            convertPrimitives.put(Byte.TYPE, Byte.class.getName());
            convertPrimitives.put(Character.TYPE, Character.class.getName());
            convertPrimitives.put(Double.TYPE, Double.class.getName());
            convertPrimitives.put(Float.TYPE, Float.class.getName());
            convertPrimitives.put(Integer.TYPE, Integer.class.getName());
            convertPrimitives.put(Long.TYPE, Long.class.getName());
            convertPrimitives.put(Short.TYPE, Short.class.getName());
        }
    }
}

