/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.io.UnicodeInputStream;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import org.apache.velocity.util.ExtProperties;
import org.slf4j.Logger;

public abstract class ResourceLoader {
    protected boolean isCachingOn = false;
    protected long modificationCheckInterval = 2L;
    protected String className = null;
    protected RuntimeServices rsvc = null;
    protected Logger log = null;

    public void commonInit(RuntimeServices runtimeServices, ExtProperties extProperties) {
        this.rsvc = runtimeServices;
        String string = extProperties.getString("_RESOURCE_LOADER_IDENTIFIER_");
        this.log = this.rsvc.getLog("loader." + (string == null ? this.getClass().getSimpleName() : string));
        try {
            this.isCachingOn = extProperties.getBoolean("cache", false);
        }
        catch (Exception exception) {
            this.isCachingOn = false;
            String string2 = "Exception parsing cache setting: " + extProperties.getString("cache");
            this.log.error(string2, exception);
            throw new VelocityException(string2, exception);
        }
        try {
            this.modificationCheckInterval = extProperties.getLong("modificationCheckInterval", 0L);
        }
        catch (Exception exception) {
            this.modificationCheckInterval = 0L;
            String string3 = "Exception parsing modificationCheckInterval setting: " + extProperties.getString("modificationCheckInterval");
            this.log.error(string3, exception);
            throw new VelocityException(string3, exception);
        }
        this.className = ResourceCacheImpl.class.getName();
        try {
            this.className = extProperties.getString("class", this.className);
        }
        catch (Exception exception) {
            String string4 = "Exception retrieving resource cache class name";
            this.log.error(string4, exception);
            throw new VelocityException(string4, exception);
        }
    }

    public abstract void init(ExtProperties var1);

    public abstract Reader getResourceReader(String var1, String var2) throws ResourceNotFoundException;

    public abstract boolean isSourceModified(Resource var1);

    public abstract long getLastModified(Resource var1);

    public String getClassName() {
        return this.className;
    }

    public void setCachingOn(boolean bl) {
        this.isCachingOn = bl;
    }

    public boolean isCachingOn() {
        return this.isCachingOn;
    }

    public void setModificationCheckInterval(long l2) {
        this.modificationCheckInterval = l2;
    }

    public long getModificationCheckInterval() {
        return this.modificationCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceExists(String string) {
        Reader reader = null;
        try {
            reader = this.getResourceReader(string, null);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.log.debug("Could not load resource '{}' from ResourceLoader {}", (Object)string, (Object)this.getClass().getName());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                String string2 = "While closing InputStream for resource '" + string + "' from ResourceLoader " + this.getClass().getName();
                this.log.error(string2, exception);
                throw new VelocityException(string2, exception);
            }
        }
        return reader != null;
    }

    protected Reader buildReader(InputStream inputStream, String string) throws IOException {
        UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream);
        String string2 = unicodeInputStream.getEncodingFromStream();
        if (string2 != null && string != null && !UnicodeInputStream.sameEncoding(string2, string)) {
            this.log.warn("Found BOM encoding '{}' differs from asked encoding: '{}' - using BOM encoding to read resource.", (Object)string2, (Object)string);
            string = string2;
        }
        if (string == null) {
            string = string2 == null ? this.rsvc.getString("input.encoding") : string2;
        }
        try {
            return new InputStreamReader((InputStream)unicodeInputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                unicodeInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw unsupportedEncodingException;
        }
    }
}

