/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.shaded.commons.io.FilenameUtils;
import org.apache.velocity.util.ExtProperties;

public class FileResourceLoader
extends ResourceLoader {
    private List<String> paths = new ArrayList<String>();
    private Map templatePaths = Collections.synchronizedMap(new HashMap());

    @Override
    public void init(ExtProperties extProperties) {
        this.log.trace("FileResourceLoader: initialization starting.");
        this.paths.addAll(extProperties.getVector("path"));
        ListIterator<String> listIterator = this.paths.listIterator();
        while (listIterator.hasNext()) {
            String string = StringUtils.trim(listIterator.next());
            listIterator.set(string);
            this.log.debug("FileResourceLoader: adding path '{}'", (Object)string);
        }
        this.log.trace("FileResourceLoader: initialization complete.");
    }

    @Override
    public Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(string)) {
            throw new ResourceNotFoundException("Need to specify a file name or file path!");
        }
        String string3 = FilenameUtils.normalize(string, true);
        if (string3 == null || string3.length() == 0) {
            String string4 = "File resource error: argument " + string3 + " contains .. and may be trying to access content outside of template root.  Rejected.";
            this.log.error("FileResourceLoader: {}", (Object)string4);
            throw new ResourceNotFoundException(string4);
        }
        int n2 = this.paths.size();
        for (String string5 : this.paths) {
            InputStream inputStream = null;
            Reader reader = null;
            try {
                inputStream = this.findTemplate(string5, string3);
                if (inputStream != null) {
                    reader = this.buildReader(inputStream, string2);
                }
            }
            catch (IOException iOException) {
                this.closeQuiet(inputStream);
                String string6 = "Exception while loading Template " + string3;
                this.log.error(string6, iOException);
                throw new VelocityException(string6, iOException);
            }
            if (reader == null) continue;
            this.templatePaths.put(string, string5);
            return reader;
        }
        throw new ResourceNotFoundException("FileResourceLoader: cannot find " + string3);
    }

    @Override
    public boolean resourceExists(String string) {
        if (string == null) {
            return false;
        }
        if ((string = FilenameUtils.normalize(string)) == null || string.length() == 0) {
            return false;
        }
        int n2 = this.paths.size();
        for (String string2 : this.paths) {
            try {
                File file = this.getFile(string2, string);
                if (!file.canRead()) continue;
                return true;
            }
            catch (Exception exception) {
                this.log.debug("Exception while checking for template {}", (Object)string);
            }
        }
        return false;
    }

    private InputStream findTemplate(String string, String string2) throws IOException {
        try {
            File file = this.getFile(string, string2);
            if (file.canRead()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file.getAbsolutePath());
                    return fileInputStream;
                }
                catch (IOException iOException) {
                    this.closeQuiet(fileInputStream);
                    throw iOException;
                }
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private void closeQuiet(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        boolean bl = true;
        String string = resource.getName();
        String string2 = (String)this.templatePaths.get(string);
        File file = null;
        for (int i2 = 0; file == null && i2 < this.paths.size(); ++i2) {
            String string3 = this.paths.get(i2);
            File file2 = this.getFile(string3, string);
            if (!file2.canRead()) continue;
            file = file2;
        }
        File file3 = this.getFile(string2, string);
        if (file != null && file3.exists() && file.equals(file3) && file3.canRead()) {
            bl = file3.lastModified() != resource.getLastModified();
        }
        return bl;
    }

    @Override
    public long getLastModified(Resource resource) {
        String string = (String)this.templatePaths.get(resource.getName());
        File file = this.getFile(string, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }

    private File getFile(String string, String string2) {
        File file = null;
        if ("".equals(string)) {
            file = new File(string2);
        } else {
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            file = new File(string, string2);
        }
        return file;
    }
}

