/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.StringReader;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringBuilderWriter;
import org.apache.velocity.util.StringUtils;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";

    public ASTStringLiteral(int n2) {
        super(n2);
    }

    public ASTStringLiteral(Parser parser, int n2) {
        super(parser, n2);
    }

    @Override
    public Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        super.init(internalContextAdapter, object);
        this.interpolate = this.rsvc.getBoolean("runtime.interpolate.string.literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf(36) != -1 || this.getFirstToken().image.indexOf(35) != -1);
        String string = this.getFirstToken().image;
        this.image = string.substring(1, string.length() - 1);
        if (string.startsWith("\"")) {
            this.image = ASTStringLiteral.unescape(this.image);
        }
        if (string.charAt(0) == '\"' || string.charAt(0) == '\'') {
            this.image = this.replaceQuotes(this.image, string.charAt(0));
        }
        if (this.interpolate) {
            StringReader stringReader = new StringReader(this.image);
            Template template = null;
            if (internalContextAdapter != null) {
                template = (Template)internalContextAdapter.getCurrentResource();
            }
            if (template == null) {
                template = new Template();
                template.setName("StringLiteral");
            }
            try {
                this.nodeTree = this.rsvc.parse(stringReader, template);
            }
            catch (ParseException parseException) {
                String string2 = "Failed to parse String literal at " + StringUtils.formatFileString(template.getName(), this.getLine(), this.getColumn());
                throw new TemplateInitException(string2, parseException, template.getName(), this.getColumn(), this.getLine());
            }
            this.adjTokenLineNums(this.nodeTree);
            this.nodeTree.init(internalContextAdapter, this.rsvc);
        }
        this.cleanupParserAndTokens();
        return object;
    }

    @Override
    public String literal() {
        return this.image;
    }

    public void adjTokenLineNums(Node node) {
        Token token = node.getFirstToken();
        while (token != null && token != node.getLastToken()) {
            if (token.beginLine == 1) {
                token.beginColumn += this.getColumn();
            }
            if (token.endLine == 1) {
                token.endColumn += this.getColumn();
            }
            token.beginLine += this.getLine() - 1;
            token.endLine += this.getLine() - 1;
            token = token.next;
        }
    }

    private String replaceQuotes(String string, char c2) {
        if (c2 == '\"' && !string.contains("\"") || c2 == '\'' && !string.contains("'")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            stringBuilder.append(c3);
            if (i2 + 1 >= n2) continue;
            char c4 = string.charAt(i2 + 1);
            if ((c2 != '\"' || c4 != '\"' || c3 != '\"') && (c2 != '\'' || c4 != '\'' || c3 != '\'')) continue;
            ++i2;
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        int n2 = string.indexOf("\\u");
        if (n2 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        do {
            stringBuilder.append(string.substring(n3, n2));
            char c2 = (char)Integer.parseInt(string.substring(n2 + 2, n2 + 6), 16);
            stringBuilder.append(c2);
        } while ((n2 = string.indexOf("\\u", n3 = n2 + 6)) >= 0);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    public boolean isConstant() {
        return !this.interpolate;
    }

    @Override
    public Object value(InternalContextAdapter internalContextAdapter) {
        if (this.interpolate) {
            try {
                StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
                this.nodeTree.render(internalContextAdapter, stringBuilderWriter);
                return ((Object)stringBuilderWriter).toString();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (IOException iOException) {
                String string = "Error in interpolating string literal";
                this.log.error(string, iOException);
                throw new VelocityException(string, iOException);
            }
        }
        return this.image;
    }

    @Override
    public boolean evaluate(InternalContextAdapter internalContextAdapter) {
        String string = (String)this.value(internalContextAdapter);
        return string != null && (!this.rsvc.getBoolean("directive.if.emptycheck", true) || !string.isEmpty());
    }
}

