/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.util.ArrayList;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

public class ASTIntegerRange
extends SimpleNode {
    public ASTIntegerRange(int n2) {
        super(n2);
    }

    public ASTIntegerRange(Parser parser, int n2) {
        super(parser, n2);
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    @Override
    public Object value(InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        Object object = this.jjtGetChild(0).value(internalContextAdapter);
        Object object2 = this.jjtGetChild(1).value(internalContextAdapter);
        if (object == null || object2 == null) {
            this.log.error((object == null ? "Left" : "Right") + " side of range operator [n..m] has null value. Operation not possible. " + StringUtils.formatFileString(this));
            return null;
        }
        if (!(object instanceof Number) || !(object2 instanceof Number)) {
            this.log.error((!(object instanceof Number) ? "Left" : "Right") + " side of range operator is not a valid type. Currently only integers (1,2,3...) and the Number type are supported. " + StringUtils.formatFileString(this));
            return null;
        }
        int n2 = ((Number)object).intValue();
        int n3 = ((Number)object2).intValue();
        int n4 = Math.abs(n2 - n3);
        int n5 = n2 >= n3 ? -1 : 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(++n4);
        int n6 = n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            arrayList.add(n6);
            n6 += n5;
        }
        return arrayList;
    }

    @Override
    public Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        Object object2 = super.init(internalContextAdapter, object);
        this.cleanupParserAndTokens();
        return object2;
    }
}

