/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MathException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ASTMathNode;
import org.apache.velocity.runtime.parser.node.MathUtils;

public class ASTDivNode
extends ASTMathNode {
    public ASTDivNode(int n2) {
        super(n2);
    }

    public ASTDivNode(Parser parser, int n2) {
        super(parser, n2);
    }

    @Override
    public String getLiteralOperator() {
        return "/";
    }

    @Override
    public Number perform(Number number, Number number2, InternalContextAdapter internalContextAdapter) {
        if (MathUtils.isZero(number2)) {
            String string = "Right side of division operation is zero. Must be non-zero. " + this.getLocation(internalContextAdapter);
            if (this.strictMode) {
                this.log.error(string);
                throw new MathException(string);
            }
            this.log.debug(string);
            return null;
        }
        return MathUtils.divide(number, number2);
    }
}

