/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;

public class Scope
extends AbstractMap {
    private static final String setReturnValue = "";
    private Map storage;
    private Object replaced;
    private Scope parent;
    private Info info;
    protected final Object owner;

    public Scope(Object object, Object object2) {
        this.owner = object;
        if (object2 != null) {
            try {
                this.parent = (Scope)object2;
            }
            catch (ClassCastException classCastException) {
                this.replaced = object2;
            }
        }
    }

    private Map getStorage() {
        if (this.storage == null) {
            this.storage = new HashMap();
        }
        return this.storage;
    }

    @Override
    public Set entrySet() {
        return this.getStorage().entrySet();
    }

    @Override
    public Object get(Object object) {
        Object v = super.get(object);
        if (v == null && this.parent != null && !this.containsKey(object)) {
            return this.parent.get(object);
        }
        return v;
    }

    @Override
    public Object put(Object object, Object object2) {
        return this.getStorage().put(object, object2);
    }

    public String set(Object object, Object object2) {
        this.put(object, object2);
        return setReturnValue;
    }

    protected void stop() {
        throw new StopCommand(this.owner);
    }

    protected int getDepth() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getDepth() + 1;
    }

    public Scope getTopmost() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTopmost();
    }

    public Scope getParent() {
        return this.parent;
    }

    public Object getReplaced() {
        if (this.replaced == null && this.parent != null) {
            return this.parent.getReplaced();
        }
        return this.replaced;
    }

    public Info getInfo() {
        if (this.info == null) {
            this.info = new Info(this, this.owner);
        }
        return this.info;
    }

    public static class Info {
        private Scope scope;
        private Directive directive;
        private Template template;

        public Info(Scope scope, Object object) {
            if (object instanceof Directive) {
                this.directive = (Directive)object;
            }
            if (object instanceof Template) {
                this.template = (Template)object;
            }
            this.scope = scope;
        }

        public String getName() {
            if (this.directive != null) {
                return this.directive.getName();
            }
            if (this.template != null) {
                return this.template.getName();
            }
            return null;
        }

        public String getType() {
            if (this.directive != null) {
                switch (this.directive.getType()) {
                    case 1: {
                        return "block";
                    }
                    case 2: {
                        return "line";
                    }
                }
            }
            if (this.template != null) {
                return this.template.getEncoding();
            }
            return null;
        }

        public int getDepth() {
            return this.scope.getDepth();
        }

        public String getTemplate() {
            if (this.directive != null) {
                return this.directive.getTemplateName();
            }
            if (this.template != null) {
                return this.template.getName();
            }
            return null;
        }

        public int getLine() {
            if (this.directive != null) {
                return this.directive.getLine();
            }
            return 0;
        }

        public int getColumn() {
            if (this.directive != null) {
                return this.directive.getColumn();
            }
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.directive != null) {
                stringBuilder.append('#');
            }
            stringBuilder.append(this.getName());
            stringBuilder.append("[type:").append(this.getType());
            int n2 = this.getDepth();
            if (n2 > 1) {
                stringBuilder.append(" depth:").append(n2);
            }
            if (this.template == null) {
                String string = this.getTemplate();
                stringBuilder.append(" template:");
                if (!string.contains(" ")) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append('\"').append(string).append('\"');
                }
                stringBuilder.append(" line:").append(this.getLine());
                stringBuilder.append(" column:").append(this.getColumn());
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

