/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.StringUtils;

public class RuntimeMacro
extends Directive {
    private String macroName;
    private String literal = null;
    private Node node = null;
    protected boolean strictRef = false;
    private String badArgsErrorMsg = null;

    @Override
    public String getName() {
        return this.macroName;
    }

    @Override
    public String getScopeName() {
        return "macro";
    }

    @Override
    public int getType() {
        return 2;
    }

    public void init(RuntimeServices runtimeServices, String string, InternalContextAdapter internalContextAdapter, Node node) {
        super.init(runtimeServices, internalContextAdapter, node);
        this.macroName = Validate.notNull(string);
        this.macroName = this.rsvc.useStringInterning() ? this.macroName.intern() : this.macroName;
        this.node = node;
        Token token = node.getLastToken();
        if (token.image.startsWith(")") || token.image.startsWith("#end")) {
            this.strictRef = this.rsvc.getBoolean("runtime.references.strict", false);
        }
        for (int i2 = 0; i2 < node.jjtGetNumChildren(); ++i2) {
            Node node2 = node.jjtGetChild(i2);
            if (node2.getType() != 11) continue;
            this.badArgsErrorMsg = "Invalid arg '" + node2.getFirstTokenImage() + "' in macro #" + this.macroName + " at " + StringUtils.formatFileString(node2);
            if (!this.strictRef) continue;
            throw new TemplateInitException(this.badArgsErrorMsg, internalContextAdapter.getCurrentTemplateName(), 0, 0);
        }
        this.getLiteral();
    }

    private String getLiteral() {
        RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
        ASTDirective aSTDirective = (ASTDirective)this.node;
        String string = aSTDirective.getMorePrefix();
        if (this.literal == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Token token = this.node.getFirstToken();
            int n2 = -1;
            while (token != null && token != this.node.getLastToken()) {
                if (n2 == -1) {
                    n2 = token.image.lastIndexOf(35);
                }
                if (n2 != -1) {
                    stringBuilder.append(token.image.substring(n2));
                    n2 = 0;
                } else if (string.length() == 0 && spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) >= 0) {
                    stringBuilder.append(token.image);
                }
                token = token.next;
            }
            if (token != null) {
                if (n2 == -1) {
                    n2 = token.image.lastIndexOf(35);
                }
                if (n2 != -1) {
                    stringBuilder.append(token.image.substring(n2));
                }
            }
            this.literal = stringBuilder.toString();
            String string2 = aSTDirective.getPostfix();
            if ((string.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) && this.literal.endsWith(string2)) {
                this.literal = this.literal.substring(0, this.literal.length() - string2.length());
            }
        }
        return this.literal;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        return this.render(internalContextAdapter, writer, node, null);
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node, Renderable renderable) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        int n2;
        List list;
        VelocimacroProxy velocimacroProxy = null;
        Template template = (Template)internalContextAdapter.getCurrentResource();
        Directive directive = this.rsvc.getVelocimacro(this.macroName, template, this.getTemplate());
        if (directive != null) {
            velocimacroProxy = (VelocimacroProxy)directive;
        }
        if (velocimacroProxy == null && (list = internalContextAdapter.getMacroLibraries()) != null) {
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                directive = this.rsvc.getVelocimacro(this.macroName, template, (Template)list.get(n2));
                if (directive == null) continue;
                velocimacroProxy = (VelocimacroProxy)directive;
                break;
            }
        }
        if (velocimacroProxy != null) {
            if (this.badArgsErrorMsg != null) {
                throw new TemplateInitException(this.badArgsErrorMsg, internalContextAdapter.getCurrentTemplateName(), node.getColumn(), node.getLine());
            }
            try {
                this.preRender(internalContextAdapter);
                boolean bl = velocimacroProxy.render(internalContextAdapter, writer, node, renderable);
                return bl;
            }
            catch (StopCommand stopCommand) {
                if (!stopCommand.isFor(this)) {
                    throw stopCommand;
                }
                n2 = 1;
                return n2 != 0;
            }
            catch (IOException | RuntimeException exception) {
                this.log.error("Exception in macro #{} called at {}", (Object)this.macroName, (Object)StringUtils.formatFileString(node));
                throw exception;
            }
            finally {
                this.postRender(internalContextAdapter);
            }
        }
        if (this.strictRef) {
            throw new VelocityException("Macro '#" + this.macroName + "' is not defined at " + StringUtils.formatFileString(node));
        }
        writer.write(this.getLiteral());
        return true;
    }
}

