/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;

public class Macro
extends Directive {
    private static boolean debugMode = false;

    @Override
    public String getName() {
        return "macro";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isScopeProvided() {
        return false;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException {
        return true;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        super.init(runtimeServices, internalContextAdapter, node);
        List<MacroArg> list = Macro.getArgArray(node, this.rsvc);
        int n2 = node.jjtGetNumChildren();
        this.rsvc.addVelocimacro(list.get((int)0).name, node.jjtGetChild(n2 - 1), list, node.getTemplate());
    }

    @Override
    public void checkArgs(ArrayList<Integer> arrayList, Token token, String string) throws ParseException {
        if (arrayList.size() < 1) {
            throw new MacroParseException("A macro definition requires at least a macro name", string, token);
        }
        if (arrayList.get(0) != 11) {
            throw new MacroParseException("Macro argument 1 must be a token without surrounding ' or \"", string, token);
        }
        boolean bl = false;
        for (int i2 = 1; i2 < arrayList.size(); ++i2) {
            if (arrayList.get(i2) == 12) {
                ++i2;
                bl = true;
                continue;
            }
            if (arrayList.get(i2) != 20) {
                throw new MacroParseException("Macro argument " + (i2 + 1) + " must be a reference", string, token);
            }
            if (!bl) continue;
            throw new MacroParseException("Macro non-default argument follows a default argument at ", string, token);
        }
    }

    private static List<MacroArg> getArgArray(Node node, RuntimeServices runtimeServices) {
        int n2 = node.jjtGetNumChildren();
        --n2;
        ArrayList<MacroArg> arrayList = new ArrayList<MacroArg>();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = node.jjtGetChild(i2);
            MacroArg macroArg = new MacroArg();
            if (node2.getType() == 12) {
                macroArg.name = node2.getFirstTokenImage();
                macroArg.defaultVal = node2 = node.jjtGetChild(++i2);
            } else {
                macroArg.name = node2.getFirstTokenImage();
            }
            if (i2 > 0 && macroArg.name.startsWith("$")) {
                macroArg.name = macroArg.name.substring(1, macroArg.name.length());
            }
            arrayList.add(macroArg);
        }
        if (debugMode) {
            StringBuilder stringBuilder = new StringBuilder("Macro.getArgArray(): nbrArgs=");
            stringBuilder.append(n2).append(": ");
            Macro.macroToString(stringBuilder, arrayList);
            runtimeServices.getLog("macro").debug(stringBuilder.toString());
        }
        return arrayList;
    }

    public static StringBuilder macroToString(StringBuilder stringBuilder, List<MacroArg> list) {
        StringBuilder stringBuilder2 = stringBuilder == null ? new StringBuilder() : stringBuilder;
        stringBuilder2.append('#').append(list.get((int)0).name).append("( ");
        for (MacroArg macroArg : list) {
            stringBuilder2.append("$").append(macroArg.name);
            if (macroArg.defaultVal != null) {
                stringBuilder2.append("=").append(macroArg.defaultVal);
            }
            stringBuilder2.append(' ');
        }
        stringBuilder2.append(" )");
        return stringBuilder2;
    }

    public static class MacroArg {
        public String name = null;
        public Node defaultVal = null;
    }
}

