/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.InputBase;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.util.StringUtils;

public class Include
extends InputBase {
    private String outputMsgStart = "";
    private String outputMsgEnd = "";

    @Override
    public String getName() {
        return "include";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean isScopeProvided() {
        return false;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        super.init(runtimeServices, internalContextAdapter, node);
        this.outputMsgStart = this.rsvc.getString("directive.include.output.errormsg.start");
        this.outputMsgStart = this.outputMsgStart + " ";
        this.outputMsgEnd = this.rsvc.getString("directive.include.output.errormsg.end");
        this.outputMsgEnd = " " + this.outputMsgEnd;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException {
        int n2 = node.jjtGetNumChildren();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = node.jjtGetChild(i2);
            if (node2.getType() == 9 || node2.getType() == 20) {
                if (this.renderOutput(node2, internalContextAdapter, writer)) continue;
                this.outputErrorToStream(writer, "error with arg " + i2 + " please see log.");
                continue;
            }
            String string = "invalid #include() argument '" + node2.toString() + "' at " + StringUtils.formatFileString(this);
            this.log.error(string);
            this.outputErrorToStream(writer, "error with arg " + i2 + " please see log.");
            throw new VelocityException(string);
        }
        return true;
    }

    private boolean renderOutput(Node node, InternalContextAdapter internalContextAdapter, Writer writer) throws IOException, MethodInvocationException, ResourceNotFoundException {
        if (node == null) {
            this.log.error("#include() null argument");
            return false;
        }
        Object object = node.value(internalContextAdapter);
        if (object == null) {
            this.log.error("#include() null argument");
            return false;
        }
        String string = object.toString();
        String string2 = EventHandlerUtil.includeEvent(this.rsvc, internalContextAdapter, string, internalContextAdapter.getCurrentTemplateName(), this.getName());
        boolean bl = false;
        if (string2 == null) {
            bl = true;
        }
        ContentResource contentResource = null;
        try {
            if (!bl) {
                contentResource = this.rsvc.getContent(string2, this.getInputEncoding(internalContextAdapter));
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.log.error("#include(): cannot find resource '{}', called at {}", (Object)string2, (Object)StringUtils.formatFileString(this));
            throw resourceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            this.log.error("#include(): arg = '{}', called at {}", (Object)string2, (Object)StringUtils.formatFileString(this));
            throw runtimeException;
        }
        catch (Exception exception) {
            String string3 = "#include(): arg = '" + string2 + "', called at " + StringUtils.formatFileString(this);
            this.log.error(string3, exception);
            throw new VelocityException(string3, exception);
        }
        if (bl) {
            return true;
        }
        if (contentResource == null) {
            return false;
        }
        writer.write((String)contentResource.getData());
        return true;
    }

    private void outputErrorToStream(Writer writer, String string) throws IOException {
        if (this.outputMsgStart != null && this.outputMsgEnd != null) {
            writer.write(this.outputMsgStart);
            writer.write(string);
            writer.write(this.outputMsgEnd);
        }
    }
}

