/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.ForeachScope;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Info;

public class Foreach
extends Directive {
    private int maxNbrLoops;
    private boolean skipInvalidIterator;
    private String elementKey;
    protected Info uberInfo;

    @Override
    public String getName() {
        return "foreach";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        SimpleNode simpleNode;
        super.init(runtimeServices, internalContextAdapter, node);
        this.maxNbrLoops = this.rsvc.getInt("directive.foreach.maxloops", Integer.MAX_VALUE);
        if (this.maxNbrLoops < 1) {
            this.maxNbrLoops = Integer.MAX_VALUE;
        }
        this.skipInvalidIterator = this.rsvc.getBoolean("directive.foreach.skip.invalid", true);
        if (this.rsvc.getBoolean("runtime.references.strict", false)) {
            this.skipInvalidIterator = this.rsvc.getBoolean("directive.foreach.skip.invalid", false);
        }
        this.elementKey = (simpleNode = (SimpleNode)node.jjtGetChild(0)) instanceof ASTReference ? ((ASTReference)simpleNode).getRootString() : simpleNode.getFirstTokenImage().substring(1);
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
    }

    protected void put(InternalContextAdapter internalContextAdapter, String string, Object object) {
        internalContextAdapter.put(string, object);
    }

    protected Iterator getIterator(Object object, Node node) {
        Iterator iterator = null;
        if (object != null) {
            try {
                iterator = this.rsvc.getUberspect().getIterator(object, this.uberInfo);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                String string = "Error getting iterator for #foreach parameter " + node.literal() + " at " + StringUtils.formatFileString(node);
                this.log.error(string, exception);
                throw new VelocityException(string, exception);
            }
            if (iterator == null && !this.skipInvalidIterator) {
                String string = "#foreach parameter " + node.literal() + " at " + StringUtils.formatFileString(node) + " is of type " + object.getClass().getName() + " and cannot be iterated by " + this.rsvc.getUberspect().getClass().getName();
                this.log.error(string);
                throw new VelocityException(string);
            }
        }
        return iterator;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException {
        Node node2 = node.jjtGetChild(2);
        Object object = node2.value(internalContextAdapter);
        Iterator iterator = this.getIterator(object, node2);
        if (iterator == null) {
            return false;
        }
        Node node3 = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        Object object2 = internalContextAdapter.get(this.elementKey);
        ForeachScope foreachScope = null;
        if (this.isScopeProvided()) {
            String string = this.getScopeName();
            foreachScope = new ForeachScope(this, internalContextAdapter.get(string));
            internalContextAdapter.put(string, foreachScope);
        }
        int n2 = 1;
        while (n2 <= this.maxNbrLoops && iterator.hasNext()) {
            ++n2;
            this.put(internalContextAdapter, this.elementKey, iterator.next());
            if (this.isScopeProvided()) {
                ++foreachScope.index;
                foreachScope.hasNext = iterator.hasNext();
            }
            try {
                this.renderBlock(internalContextAdapter, writer, node3);
            }
            catch (StopCommand stopCommand) {
                if (stopCommand.isFor(this)) break;
                this.clean(internalContextAdapter, object2);
                throw stopCommand;
            }
        }
        this.clean(internalContextAdapter, object2);
        if (iterator != null && iterator instanceof Closeable && iterator != object) {
            ((Closeable)((Object)iterator)).close();
        }
        return true;
    }

    protected void renderBlock(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException {
        node.render(internalContextAdapter, writer);
    }

    protected void clean(InternalContextAdapter internalContextAdapter, Object object) {
        if (object != null) {
            internalContextAdapter.put(this.elementKey, object);
        } else {
            internalContextAdapter.remove(this.elementKey);
        }
        this.postRender(internalContextAdapter);
    }

    @Override
    public void checkArgs(ArrayList<Integer> arrayList, Token token, String string) throws ParseException {
        if (arrayList.size() < 3) {
            throw new MacroParseException("Too few arguments to the #foreach directive", string, token);
        }
        if (arrayList.get(0) != 20) {
            throw new MacroParseException("Expected argument 1 of #foreach to be a reference", string, token);
        }
        if (arrayList.get(1) != 11) {
            throw new MacroParseException("Expected word 'in' at argument position 2 in #foreach", string, token);
        }
        if (arrayList.get(2) == 11) {
            throw new MacroParseException("Argument 3 of #foreach is of the wrong type", string, token);
        }
    }
}

