/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroManager;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.Node;
import org.slf4j.Logger;

public class VelocimacroFactory {
    private final RuntimeServices rsvc;
    private Logger log = null;
    private VelocimacroManager vmManager = null;
    private boolean replaceAllowed = false;
    private boolean addNewAllowed = true;
    private boolean templateLocal = false;
    private boolean autoReloadLibrary = false;
    private List<String> macroLibVec = null;
    private Map libModMap;

    public VelocimacroFactory(RuntimeServices runtimeServices) {
        this.rsvc = runtimeServices;
        this.libModMap = new HashMap();
        this.vmManager = new VelocimacroManager(runtimeServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVelocimacro() {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.log = this.rsvc.getLog("macro");
            this.log.trace("initialization starting.");
            this.setReplacementPermission(true);
            this.vmManager.setNamespaceUsage(false);
            Object object = this.rsvc.getProperty("velocimacro.library");
            if (object == null) {
                this.log.debug("\"{}\" is not set. Trying default library: {}", (Object)"velocimacro.library", (Object)"VM_global_library.vm");
                if (this.rsvc.getLoaderNameForResource("VM_global_library.vm") != null) {
                    object = "VM_global_library.vm";
                } else {
                    this.log.debug("Default library not found.");
                }
            }
            if (object != null) {
                this.macroLibVec = new ArrayList<String>();
                if (object instanceof Vector) {
                    this.macroLibVec.addAll((Vector)object);
                } else if (object instanceof String) {
                    this.macroLibVec.add((String)object);
                }
                for (String string : this.macroLibVec) {
                    Object object2;
                    if (!StringUtils.isNotEmpty(string)) continue;
                    this.vmManager.setRegisterFromLib(true);
                    this.log.debug("adding VMs from VM library: {}", (Object)string);
                    try {
                        Template template = this.rsvc.getTemplate(string);
                        object2 = new Twonk();
                        ((Twonk)object2).template = template;
                        ((Twonk)object2).modificationTime = template.getLastModified();
                        this.libModMap.put(string, object2);
                    }
                    catch (Exception exception) {
                        object2 = "Velocimacro: Error using VM library: " + string;
                        this.log.error((String)object2, exception);
                        throw new VelocityException((String)object2, exception);
                    }
                    this.log.trace("VM library registration complete.");
                    this.vmManager.setRegisterFromLib(false);
                }
            }
            this.setAddMacroPermission(true);
            if (!this.rsvc.getBoolean("velocimacro.permissions.allow.inline", true)) {
                this.setAddMacroPermission(false);
                this.log.debug("allowInline = false: VMs can NOT be defined inline in templates");
            } else {
                this.log.debug("allowInline = true: VMs can be defined inline in templates");
            }
            this.setReplacementPermission(false);
            if (this.rsvc.getBoolean("velocimacro.permissions.allow.inline.to.replace.global", false)) {
                this.setReplacementPermission(true);
                this.log.debug("allowInlineToOverride = true: VMs defined inline may replace previous VM definitions");
            } else {
                this.log.debug("allowInlineToOverride = false: VMs defined inline may NOT replace previous VM definitions");
            }
            this.vmManager.setNamespaceUsage(true);
            this.setTemplateLocalInline(this.rsvc.getBoolean("velocimacro.permissions.allow.inline.local.scope", false));
            if (this.getTemplateLocalInline()) {
                this.log.debug("allowInlineLocal = true: VMs defined inline will be local to their defining template only.");
            } else {
                this.log.debug("allowInlineLocal = false: VMs defined inline will be global in scope if allowed.");
            }
            this.vmManager.setTemplateLocalInlineVM(this.getTemplateLocalInline());
            this.setAutoload(this.rsvc.getBoolean("velocimacro.library.autoreload", false));
            if (this.getAutoload()) {
                this.log.debug("autoload on: VM system will automatically reload global library macros");
            } else {
                this.log.debug("autoload off: VM system will not automatically reload global library macros");
            }
            this.log.trace("Velocimacro: initialization complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVelocimacro(String string, Node node, List<Macro.MacroArg> list, Template template) {
        if (string == null || node == null || list == null || template == null) {
            String string2 = "VM '" + string + "' addition rejected: ";
            string2 = string == null ? string2 + "name" : (node == null ? string2 + "macroBody" : (list == null ? string2 + "macroArgs" : string2 + "sourceTemplate"));
            string2 = string2 + " argument was null";
            this.log.error(string2);
            throw new NullPointerException(string2);
        }
        if (!this.canAddVelocimacro(string, template)) {
            return false;
        }
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.vmManager.addVM(string, node, list, template, this.replaceAllowed);
        }
        this.log.debug("added VM {}: source={}", (Object)string, (Object)template);
        return true;
    }

    private synchronized boolean canAddVelocimacro(String string, Template template) {
        if (this.autoReloadLibrary && this.macroLibVec != null && this.macroLibVec.contains(template.getName())) {
            return true;
        }
        if (!this.addNewAllowed) {
            this.log.warn("VM addition rejected: {}: inline VelociMacros not allowed.", (Object)string);
            return false;
        }
        if (!this.templateLocal && !this.replaceAllowed && this.isVelocimacro(string, template)) {
            this.log.debug("VM addition rejected: {}: inline not allowed to replace existing VM", (Object)string);
            return false;
        }
        return true;
    }

    public boolean isVelocimacro(String string, Template template) {
        return this.vmManager.get(string, null, template) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directive getVelocimacro(String string, Template template, Template template2) {
        VelocimacroProxy velocimacroProxy = null;
        velocimacroProxy = this.vmManager.get(string, template, template2);
        if (velocimacroProxy != null && this.autoReloadLibrary) {
            VelocimacroFactory velocimacroFactory = this;
            synchronized (velocimacroFactory) {
                String string2 = this.vmManager.getLibraryName(string, template2);
                if (string2 != null) {
                    try {
                        Twonk twonk = (Twonk)this.libModMap.get(string2);
                        if (twonk != null) {
                            Template template3 = twonk.template;
                            long l2 = twonk.modificationTime;
                            long l3 = template3.getResourceLoader().getLastModified(template3);
                            if (l3 > l2) {
                                this.log.debug("auto-reloading VMs from VM library: {}", (Object)string2);
                                twonk.modificationTime = l3;
                                twonk.template = template3 = this.rsvc.getTemplate(string2);
                                twonk.modificationTime = template3.getLastModified();
                            }
                        }
                    }
                    catch (Exception exception) {
                        String string3 = "Velocimacro: Error using VM library: " + string2;
                        this.log.error(string3, exception);
                        throw new VelocityException(string3, exception);
                    }
                    velocimacroProxy = this.vmManager.get(string, template2, template);
                }
            }
        }
        return velocimacroProxy;
    }

    private void setTemplateLocalInline(boolean bl) {
        this.templateLocal = bl;
    }

    private boolean getTemplateLocalInline() {
        return this.templateLocal;
    }

    private boolean setAddMacroPermission(boolean bl) {
        boolean bl2 = this.addNewAllowed;
        this.addNewAllowed = bl;
        return bl2;
    }

    private boolean setReplacementPermission(boolean bl) {
        boolean bl2 = this.replaceAllowed;
        this.replaceAllowed = bl;
        this.vmManager.setInlineReplacesGlobal(bl);
        return bl2;
    }

    private void setAutoload(boolean bl) {
        this.autoReloadLibrary = bl;
    }

    private boolean getAutoload() {
        return this.autoReloadLibrary;
    }

    private static class Twonk {
        public Template template;
        public long modificationTime;

        private Twonk() {
        }
    }
}

