/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.IncludeEventHandler;
import org.apache.velocity.app.event.InvalidReferenceEventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.ParserPool;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExtProperties;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.ChainableUberspector;
import org.apache.velocity.util.introspection.LinkingUberspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInstance
implements RuntimeConstants,
RuntimeServices {
    private VelocimacroFactory vmFactory = null;
    private Logger log = LoggerFactory.getLogger("org.apache.velocity");
    private ParserPool parserPool;
    private boolean initializing = false;
    private volatile boolean initialized = false;
    private ExtProperties overridingProperties = null;
    private Map runtimeDirectives = new Hashtable();
    private Map runtimeDirectivesShared;
    private ExtProperties configuration = new ExtProperties();
    private ResourceManager resourceManager = null;
    private EventCartridge eventCartridge = null;
    private boolean stringInterning = false;
    private String evaluateScopeName = "evaluate";
    private boolean provideEvaluateScope = false;
    private Map applicationAttributes = null;
    private Uberspect uberSpect;
    private String defaultEncoding;
    private RuntimeConstants.SpaceGobbling spaceGobbling;

    public RuntimeInstance() {
        this.reset();
    }

    @Override
    public synchronized void init() {
        if (!this.initialized && !this.initializing) {
            try {
                this.log.debug("Initializing Velocity, Calling init()...");
                this.initializing = true;
                this.log.trace("*****************************");
                this.log.debug("Starting Apache Velocity v2.0");
                this.log.trace("RuntimeInstance initializing.");
                this.initializeProperties();
                this.initializeSelfProperties();
                this.initializeLog();
                this.initializeResourceManager();
                this.initializeDirectives();
                this.initializeEventHandlers();
                this.initializeParserPool();
                this.initializeIntrospection();
                this.initializeEvaluateScopeSettings();
                this.vmFactory.initVelocimacro();
                this.log.trace("RuntimeInstance successfully initialized.");
                this.initialized = true;
                this.initializing = false;
            }
            catch (RuntimeException runtimeException) {
                try {
                    this.reset();
                }
                catch (RuntimeException runtimeException2) {
                    // empty catch block
                }
                throw runtimeException;
            }
            finally {
                this.initializing = false;
            }
        }
    }

    public synchronized void reset() {
        this.configuration = new ExtProperties();
        this.defaultEncoding = null;
        this.evaluateScopeName = "evaluate";
        this.eventCartridge = null;
        this.initialized = false;
        this.initializing = false;
        this.overridingProperties = null;
        this.parserPool = null;
        this.provideEvaluateScope = false;
        this.resourceManager = null;
        this.runtimeDirectives = new Hashtable();
        this.runtimeDirectivesShared = null;
        this.uberSpect = null;
        this.stringInterning = false;
        this.vmFactory = new VelocimacroFactory(this);
        this.applicationAttributes = new HashMap();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private void requireInitialization() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (Exception exception) {
                this.log.error("Could not auto-initialize Velocity", exception);
                throw new RuntimeException("Velocity could not be initialized!", exception);
            }
        }
    }

    private void initializeSelfProperties() {
        this.stringInterning = this.getBoolean("runtime.string.interning", true);
        String string = this.getString("space.gobbling", "lines");
        try {
            this.spaceGobbling = RuntimeConstants.SpaceGobbling.valueOf(string.toUpperCase());
        }
        catch (NoSuchElementException noSuchElementException) {
            this.spaceGobbling = RuntimeConstants.SpaceGobbling.LINES;
        }
    }

    private void initializeIntrospection() {
        String[] stringArray;
        for (String string : stringArray = this.configuration.getStringArray("runtime.introspector.uberspect")) {
            Object classNotFoundException;
            Object object = null;
            try {
                object = ClassUtils.getNewInstance(string);
            }
            catch (ClassNotFoundException instantiationException) {
                String string2 = "The specified class for Uberspect (" + string + ") does not exist or is not accessible to the current classloader.";
                this.log.error(string2);
                throw new VelocityException(string2, instantiationException);
            }
            catch (InstantiationException illegalAccessException) {
                throw new VelocityException("Could not instantiate class '" + string + "'", illegalAccessException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new VelocityException("Cannot access class '" + string + "'", illegalAccessException);
            }
            if (!(object instanceof Uberspect)) {
                classNotFoundException = "The specified class for Uberspect (" + string + ") does not implement " + Uberspect.class.getName() + "; Velocity is not initialized correctly.";
                this.log.error((String)classNotFoundException);
                throw new VelocityException((String)classNotFoundException);
            }
            classNotFoundException = (Uberspect)object;
            if (classNotFoundException instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)classNotFoundException).setRuntimeServices(this);
            }
            if (this.uberSpect == null) {
                this.uberSpect = classNotFoundException;
                continue;
            }
            if (classNotFoundException instanceof ChainableUberspector) {
                ((ChainableUberspector)classNotFoundException).wrap(this.uberSpect);
                this.uberSpect = classNotFoundException;
                continue;
            }
            this.uberSpect = new LinkingUberspector(this.uberSpect, (Uberspect)classNotFoundException);
        }
        if (this.uberSpect == null) {
            String string = "It appears that no class was specified as the Uberspect.  Please ensure that all configuration information is correct.";
            this.log.error(string);
            throw new VelocityException(string);
        }
        this.uberSpect.init();
    }

    private void setDefaultProperties() {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream("org/apache/velocity/runtime/defaults/velocity.properties");
            if (inputStream == null) {
                throw new IOException("Resource not found: org/apache/velocity/runtime/defaults/velocity.properties");
            }
            this.configuration.load(inputStream);
            this.defaultEncoding = this.getString("input.encoding", "UTF-8");
            this.log.debug("Default Properties resource: {}", (Object)"org/apache/velocity/runtime/defaults/velocity.properties");
        }
        catch (IOException iOException) {
            String string = "Cannot get Velocity Runtime default properties!";
            this.log.error(string, iOException);
            throw new RuntimeException(string, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                String string = "Cannot close Velocity Runtime default properties!";
                this.log.error(string, iOException);
                throw new RuntimeException(string, iOException);
            }
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtProperties();
        }
        this.overridingProperties.setProperty(string, object);
    }

    public void setProperties(String string) {
        ExtProperties extProperties = null;
        try {
            extProperties = new ExtProperties(string);
        }
        catch (IOException iOException) {
            throw new VelocityException("Error reading properties from '" + string + "'", iOException);
        }
        Enumeration enumeration = extProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            this.setProperty(string2, extProperties.get(string2));
        }
    }

    public void setProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            this.setProperty(string, properties.get(string));
        }
    }

    @Override
    public void setConfiguration(ExtProperties extProperties) {
        if (this.overridingProperties == null) {
            this.overridingProperties = extProperties;
        } else if (this.overridingProperties != extProperties) {
            this.overridingProperties.combine(extProperties);
        }
    }

    @Override
    public void addProperty(String string, Object object) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtProperties();
        }
        this.overridingProperties.addProperty(string, object);
    }

    @Override
    public void clearProperty(String string) {
        if (this.overridingProperties != null) {
            this.overridingProperties.clearProperty(string);
        }
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        if (!this.initialized && this.overridingProperties != null) {
            object = this.overridingProperties.get(string);
        }
        if (object == null) {
            object = this.configuration.getProperty(string);
        }
        if (object instanceof String) {
            return StringUtils.trim((String)object);
        }
        return object;
    }

    private void initializeProperties() {
        if (!this.configuration.isInitialized()) {
            this.setDefaultProperties();
        }
        if (this.overridingProperties != null) {
            this.configuration.combine(this.overridingProperties);
        }
    }

    @Override
    public void init(Properties properties) {
        this.setConfiguration(ExtProperties.convertProperties(properties));
        this.init();
    }

    @Override
    public void init(String string) {
        try {
            this.setConfiguration(new ExtProperties(string));
        }
        catch (IOException iOException) {
            throw new VelocityException("Error reading properties from '" + string + "'", iOException);
        }
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeResourceManager() {
        Object object = this.getProperty("resource.manager.instance");
        String string = this.getString("resource.manager.class");
        if (object != null) {
            if (ResourceManager.class.isAssignableFrom(object.getClass())) {
                this.resourceManager = (ResourceManager)object;
                this.resourceManager.initialize(this);
                return;
            }
            String string2 = object.getClass().getName() + " object set as resource.manager.instance is not a valid org.apache.velocity.runtime.resource.ResourceManager.";
            this.log.error(string2);
            throw new VelocityException(string2);
        }
        if (string != null && string.length() > 0) {
            Object object2 = null;
            try {
                object2 = ClassUtils.getNewInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = "The specified class for ResourceManager (" + string + ") does not exist or is not accessible to the current classloader.";
                this.log.error(string3);
                throw new VelocityException(string3, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new VelocityException("Could not instantiate class '" + string + "'", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new VelocityException("Cannot access class '" + string + "'", illegalAccessException);
            }
            if (!(object2 instanceof ResourceManager)) {
                String string4 = "The specified class for ResourceManager (" + string + ") does not implement " + ResourceManager.class.getName() + "; Velocity is not initialized correctly.";
                this.log.error(string4);
                throw new VelocityException(string4);
            }
            this.resourceManager = (ResourceManager)object2;
            this.resourceManager.initialize(this);
            this.setProperty("resource.manager.instance", this.resourceManager);
            return;
        }
        String string5 = "It appears that no class or instance was specified as the ResourceManager.  Please ensure that all configuration information is correct.";
        this.log.error(string5);
        throw new VelocityException(string5);
    }

    /*
     * WARNING - void declaration
     */
    private void initializeEventHandlers() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        this.eventCartridge = new EventCartridge();
        this.eventCartridge.setRuntimeServices(this);
        String[] stringArray4 = this.configuration.getStringArray("eventhandler.referenceinsertion.class");
        if (stringArray4 != null) {
            stringArray3 = stringArray4;
            int n2 = stringArray3.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray3[i2];
                EventHandler object = this.initializeSpecificEventHandler(string, "eventhandler.referenceinsertion.class", ReferenceInsertionEventHandler.class);
                if (object == null) continue;
                this.eventCartridge.addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)object);
            }
        }
        if ((stringArray3 = this.configuration.getStringArray("eventhandler.methodexception.class")) != null) {
            for (String string : stringArray3) {
                EventHandler eventHandler = this.initializeSpecificEventHandler(string, "eventhandler.methodexception.class", MethodExceptionEventHandler.class);
                if (eventHandler == null) continue;
                this.eventCartridge.addMethodExceptionHandler((MethodExceptionEventHandler)eventHandler);
            }
        }
        if ((stringArray2 = this.configuration.getStringArray("eventhandler.include.class")) != null) {
            void var6_17;
            String[] stringArray5 = stringArray2;
            int n2 = stringArray5.length;
            boolean bl = false;
            while (var6_17 < n2) {
                String string = stringArray5[var6_17];
                EventHandler eventHandler = this.initializeSpecificEventHandler(string, "eventhandler.include.class", IncludeEventHandler.class);
                if (eventHandler != null) {
                    this.eventCartridge.addIncludeEventHandler((IncludeEventHandler)eventHandler);
                }
                ++var6_17;
            }
        }
        if ((stringArray = this.configuration.getStringArray("eventhandler.invalidreferences.class")) != null) {
            void var7_23;
            String[] stringArray6 = stringArray;
            int n3 = stringArray6.length;
            boolean bl = false;
            while (var7_23 < n3) {
                String string = stringArray6[var7_23];
                EventHandler eventHandler = this.initializeSpecificEventHandler(string, "eventhandler.invalidreferences.class", InvalidReferenceEventHandler.class);
                if (eventHandler != null) {
                    this.eventCartridge.addInvalidReferenceEventHandler((InvalidReferenceEventHandler)eventHandler);
                }
                ++var7_23;
            }
        }
    }

    private EventHandler initializeSpecificEventHandler(String string, String string2, Class clazz) {
        if (string != null && string.length() > 0) {
            Object object = null;
            try {
                object = ClassUtils.getNewInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = "The specified class for " + string2 + " (" + string + ") does not exist or is not accessible to the current classloader.";
                this.log.error(string3);
                throw new VelocityException(string3, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new VelocityException("Could not instantiate class '" + string + "'", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new VelocityException("Cannot access class '" + string + "'", illegalAccessException);
            }
            if (!clazz.isAssignableFrom(clazz)) {
                String string4 = "The specified class for " + string2 + " (" + string + ") does not implement " + clazz.getName() + "; Velocity is not initialized correctly.";
                this.log.error(string4);
                throw new VelocityException(string4);
            }
            EventHandler eventHandler = (EventHandler)object;
            if (eventHandler instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(this);
            }
            return eventHandler;
        }
        return null;
    }

    private void initializeLog() {
        block5: {
            try {
                Object object = this.getProperty("runtime.log.instance");
                if (object != null) {
                    if (Logger.class.isAssignableFrom(object.getClass())) {
                        this.log = (Logger)object;
                        break block5;
                    }
                    String string = object.getClass().getName() + " object set as runtime.log.instance is not a valid org.slf4j.Logger implementation.";
                    this.log.error(string);
                    throw new VelocityException(string);
                }
                object = this.getProperty("runtime.log.name");
                if (object == null) break block5;
                if (object instanceof String) {
                    this.log = LoggerFactory.getLogger((String)object);
                    break block5;
                }
                String string = object.getClass().getName() + " object set as runtime.log.name is not a valid string.";
                this.log.error(string);
                throw new VelocityException(string);
            }
            catch (Exception exception) {
                throw new VelocityException("Error initializing log: " + exception.getMessage(), exception);
            }
        }
    }

    private void initializeDirectives() {
        String[] stringArray;
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/org/apache/velocity/runtime/defaults/directive.properties");
            if (inputStream == null) {
                throw new VelocityException("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
            }
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            String string = "Error while loading directive properties!";
            this.log.error(string, iOException);
            throw new RuntimeException(string, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                String string = "Cannot close directive properties!";
                this.log.error(string, iOException);
                throw new RuntimeException(string, iOException);
            }
        }
        Enumeration<Object> enumeration = properties.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            this.loadDirective((String)stringArray);
            this.log.debug("Loaded System Directive: {}", (Object)stringArray);
        }
        for (String string : stringArray = this.configuration.getStringArray("userdirective")) {
            this.loadDirective(string);
            this.log.debug("Loaded User Directive: {}", (Object)string);
        }
    }

    public synchronized void addDirective(Directive directive) {
        this.runtimeDirectives.put(directive.getName(), directive);
        this.updateSharedDirectivesMap();
    }

    @Override
    public Directive getDirective(String string) {
        return (Directive)this.runtimeDirectivesShared.get(string);
    }

    public synchronized void removeDirective(String string) {
        this.runtimeDirectives.remove(string);
        this.updateSharedDirectivesMap();
    }

    private void updateSharedDirectivesMap() {
        this.runtimeDirectivesShared = new HashMap(this.runtimeDirectives);
    }

    public void loadDirective(String string) {
        try {
            Object object = ClassUtils.getNewInstance(string);
            if (!(object instanceof Directive)) {
                String string2 = string + " does not implement " + Directive.class.getName() + "; it cannot be loaded.";
                this.log.error(string2);
                throw new VelocityException(string2);
            }
            Directive directive = (Directive)object;
            this.addDirective(directive);
        }
        catch (Exception exception) {
            String string3 = "Failed to load Directive: " + string;
            this.log.error(string3, exception);
            throw new VelocityException(string3, exception);
        }
    }

    private void initializeParserPool() {
        Object object;
        String string = this.getString("parser.pool.class");
        if (string != null && string.length() > 0) {
            object = null;
            try {
                object = ClassUtils.getNewInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = "The specified class for ParserPool (" + string + ") does not exist (or is not accessible to the current classloader.";
                this.log.error(string2);
                throw new VelocityException(string2, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new VelocityException("Could not instantiate class '" + string + "'", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new VelocityException("Cannot access class '" + string + "'", illegalAccessException);
            }
            if (!(object instanceof ParserPool)) {
                String string3 = "The specified class for ParserPool (" + string + ") does not implement " + ParserPool.class + " Velocity not initialized correctly.";
                this.log.error(string3);
                throw new VelocityException(string3);
            }
        } else {
            String string4 = "It appears that no class was specified as the ParserPool.  Please ensure that all configuration information is correct.";
            this.log.error(string4);
            throw new VelocityException(string4);
        }
        this.parserPool = (ParserPool)object;
        this.parserPool.initialize(this);
    }

    @Override
    public Parser createNewParser() {
        this.requireInitialization();
        return new Parser(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleNode parse(Reader reader, Template template) throws ParseException {
        this.requireInitialization();
        Parser parser = this.parserPool.get();
        boolean bl = true;
        if (parser == null) {
            this.log.info("Runtime: ran out of parsers. Creating a new one.  Please increment the parser.pool.size property. The current value is too small.");
            parser = this.createNewParser();
            bl = false;
        }
        try {
            SimpleNode simpleNode = parser.parse(reader, template);
            return simpleNode;
        }
        finally {
            if (bl) {
                parser.currentTemplate = null;
                this.parserPool.put(parser);
            }
        }
    }

    private void initializeEvaluateScopeSettings() {
        String string = this.evaluateScopeName + '.' + "provide.scope.control";
        this.provideEvaluateScope = this.getBoolean(string, this.provideEvaluateScope);
    }

    @Override
    public boolean evaluate(Context context, Writer writer, String string, String string2) {
        return this.evaluate(context, writer, string, new StringReader(string2));
    }

    @Override
    public boolean evaluate(Context context, Writer writer, String string, Reader reader) {
        if (string == null) {
            throw new NullPointerException("logTag (i.e. template name) cannot be null, you must provide an identifier for the content being evaluated");
        }
        SimpleNode simpleNode = null;
        Template template = new Template();
        template.setName(string);
        try {
            simpleNode = this.parse(reader, template);
        }
        catch (ParseException parseException) {
            throw new ParseErrorException(parseException, null);
        }
        catch (TemplateInitException templateInitException) {
            throw new ParseErrorException(templateInitException, null);
        }
        if (simpleNode == null) {
            return false;
        }
        return this.render(context, writer, string, simpleNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(Context context, Writer writer, String string, SimpleNode simpleNode) {
        Object object;
        InternalContextAdapterImpl internalContextAdapterImpl = new InternalContextAdapterImpl(context);
        internalContextAdapterImpl.pushCurrentTemplateName(string);
        try {
            try {
                simpleNode.init(internalContextAdapterImpl, this);
            }
            catch (TemplateInitException templateInitException) {
                throw new ParseErrorException(templateInitException, null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                String string2 = "RuntimeInstance.render(): init exception for tag = " + string;
                this.log.error(string2, exception);
                throw new VelocityException(string2, exception);
            }
            try {
                if (this.provideEvaluateScope) {
                    object = internalContextAdapterImpl.get(this.evaluateScopeName);
                    context.put(this.evaluateScopeName, new Scope(this, object));
                }
                if ((object = this.getString("context.autoreference.key")) != null) {
                    context.put((String)object, context);
                }
                simpleNode.render(internalContextAdapterImpl, writer);
            }
            catch (StopCommand stopCommand) {
                if (!stopCommand.isFor(this)) {
                    throw stopCommand;
                }
                this.log.debug(stopCommand.getMessage());
            }
            catch (IOException iOException) {
                throw new VelocityException("IO Error in writer: " + iOException.getMessage(), iOException);
            }
        }
        finally {
            internalContextAdapterImpl.popCurrentTemplateName();
            if (this.provideEvaluateScope && (object = internalContextAdapterImpl.get(this.evaluateScopeName)) instanceof Scope) {
                Scope scope = (Scope)object;
                if (scope.getParent() != null) {
                    internalContextAdapterImpl.put(this.evaluateScopeName, scope.getParent());
                } else if (scope.getReplaced() != null) {
                    internalContextAdapterImpl.put(this.evaluateScopeName, scope.getReplaced());
                } else {
                    internalContextAdapterImpl.remove(this.evaluateScopeName);
                }
            }
        }
        return true;
    }

    @Override
    public boolean invokeVelocimacro(String string, String string2, String[] stringArray, Context context, Writer writer) {
        if (string == null || context == null || writer == null) {
            String string3 = "RuntimeInstance.invokeVelocimacro(): invalid call: vmName, context, and writer must not be null";
            this.log.error(string3);
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            string2 = string;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (!this.isVelocimacro(string, null)) {
            String string4 = "RuntimeInstance.invokeVelocimacro(): VM '" + string + "' is not registered.";
            this.log.error(string4);
            throw new VelocityException(string4);
        }
        StringBuilder stringBuilder = new StringBuilder("#");
        stringBuilder.append(string);
        stringBuilder.append("(");
        for (String string5 : stringArray) {
            stringBuilder.append(" $");
            stringBuilder.append(string5);
        }
        stringBuilder.append(" )");
        return this.evaluate(context, writer, string2, stringBuilder.toString());
    }

    private String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public Template getTemplate(String string) throws ResourceNotFoundException, ParseErrorException {
        return this.getTemplate(string, null);
    }

    @Override
    public Template getTemplate(String string, String string2) throws ResourceNotFoundException, ParseErrorException {
        this.requireInitialization();
        if (string2 == null) {
            string2 = this.getDefaultEncoding();
        }
        return (Template)this.resourceManager.getResource(string, 1, string2);
    }

    @Override
    public ContentResource getContent(String string) throws ResourceNotFoundException, ParseErrorException {
        return this.getContent(string, this.getDefaultEncoding());
    }

    @Override
    public ContentResource getContent(String string, String string2) throws ResourceNotFoundException, ParseErrorException {
        this.requireInitialization();
        return (ContentResource)this.resourceManager.getResource(string, 2, string2);
    }

    @Override
    public String getLoaderNameForResource(String string) {
        this.requireInitialization();
        return this.resourceManager.getLoaderNameForResource(string);
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public Logger getLog(String string) {
        Logger logger = (Logger)this.getProperty("runtime.log.instance");
        if (logger == null) {
            String string2 = this.getString("runtime.log.name", "org.apache.velocity") + "." + string;
            logger = LoggerFactory.getLogger(string2);
        }
        return logger;
    }

    @Override
    public String getString(String string, String string2) {
        return this.configuration.getString(string, string2);
    }

    @Override
    public Directive getVelocimacro(String string, Template template, Template template2) {
        return this.vmFactory.getVelocimacro(string, template, template2);
    }

    @Override
    public boolean addVelocimacro(String string, Node node, List<Macro.MacroArg> list, Template template) {
        return this.vmFactory.addVelocimacro(this.stringInterning ? string.intern() : string, node, list, template);
    }

    @Override
    public boolean isVelocimacro(String string, Template template) {
        return this.vmFactory.isVelocimacro(this.stringInterning ? string.intern() : string, template);
    }

    @Override
    public String getString(String string) {
        return StringUtils.trim(this.configuration.getString(string));
    }

    @Override
    public int getInt(String string) {
        return this.configuration.getInt(string);
    }

    @Override
    public int getInt(String string, int n2) {
        return this.configuration.getInt(string, n2);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        return this.configuration.getBoolean(string, bl);
    }

    @Override
    public ExtProperties getConfiguration() {
        return this.configuration;
    }

    @Override
    public EventCartridge getApplicationEventCartridge() {
        return this.eventCartridge;
    }

    @Override
    public Object getApplicationAttribute(Object object) {
        return this.applicationAttributes.get(object);
    }

    @Override
    public Object setApplicationAttribute(Object object, Object object2) {
        return this.applicationAttributes.put(object, object2);
    }

    @Override
    public Uberspect getUberspect() {
        return this.uberSpect;
    }

    @Override
    public boolean useStringInterning() {
        return this.stringInterning;
    }

    @Override
    public RuntimeConstants.SpaceGobbling getSpaceGobbling() {
        return this.spaceGobbling;
    }
}

