/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.io.Filter;

public final class VelocityWriter
extends Writer
implements Filter {
    public static final int NO_BUFFER = 0;
    public static final int DEFAULT_BUFFER = -1;
    public static final int UNBOUNDED_BUFFER = -2;
    private Writer writer = null;
    private int bufferSize;
    private boolean autoFlush;
    private char[] cb;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;

    public VelocityWriter(Writer writer) {
        this(writer, defaultCharBufferSize, true);
    }

    private VelocityWriter(int n2, boolean bl) {
        this.bufferSize = n2;
        this.autoFlush = bl;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public VelocityWriter(Writer writer, int n2, boolean bl) {
        this(n2, bl);
        if (n2 < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.writer = writer;
        this.cb = n2 == 0 ? null : new char[n2];
        this.nextChar = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        if (this.nextChar == 0) {
            return;
        }
        this.writer.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    public final void clear() {
        this.nextChar = 0;
    }

    private void bufferOverflow() throws IOException {
        throw new IOException("overflow");
    }

    @Override
    public final void flush() throws IOException {
        this.flushBuffer();
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.flush();
    }

    public final int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    @Override
    public final void write(int n2) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(n2);
        } else {
            if (this.nextChar >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)n2;
        }
    }

    private int min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    @Override
    public final void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(cArray, n2, n3);
            return;
        }
        if (n3 == 0) {
            return;
        }
        if (n3 >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                this.bufferOverflow();
            }
            this.writer.write(cArray, n2, n3);
            return;
        }
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            int n6 = this.min(this.bufferSize - this.nextChar, n5 - n4);
            System.arraycopy(cArray, n4, this.cb, this.nextChar, n6);
            n4 += n6;
            this.nextChar += n6;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public final void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public final void write(String string, int n2, int n3) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(string, n2, n3);
            return;
        }
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            int n6 = this.min(this.bufferSize - this.nextChar, n5 - n4);
            string.getChars(n4, n4 + n6, this.cb, this.nextChar);
            n4 += n6;
            this.nextChar += n6;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public final void write(String string) throws IOException {
        if (string != null) {
            this.write(string, 0, string.length());
        }
    }

    public final void recycle(Writer writer) {
        this.writer = writer;
        this.clear();
    }

    @Override
    public void writeReference(String string) throws IOException {
        this.write(string);
    }
}

