/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class Units {
    public static final int EMU_PER_PIXEL = 9525;
    public static final int EMU_PER_POINT = 12700;
    public static final int EMU_PER_CENTIMETER = 360000;
    public static final int MASTER_DPI = 576;
    public static final int PIXEL_DPI = 96;
    public static final int POINT_DPI = 72;

    public static int toEMU(double points) {
        return (int)Math.rint(12700.0 * points);
    }

    public static int pixelToEMU(int pixels) {
        return pixels * 9525;
    }

    public static double toPoints(long emu) {
        return (double)emu / 12700.0;
    }

    public static double fixedPointToDouble(int fixedPoint) {
        int i2 = fixedPoint >> 16;
        int f2 = fixedPoint & 0xFFFF;
        return (double)i2 + (double)f2 / 65536.0;
    }

    public static int doubleToFixedPoint(double floatPoint) {
        double fractionalPart = floatPoint % 1.0;
        double integralPart = floatPoint - fractionalPart;
        int i2 = (int)Math.floor(integralPart);
        int f2 = (int)Math.rint(fractionalPart * 65536.0);
        return i2 << 16 | f2 & 0xFFFF;
    }

    public static double masterToPoints(int masterDPI) {
        double points = masterDPI;
        points *= 72.0;
        return points /= 576.0;
    }

    public static int pointsToMaster(double points) {
        points *= 576.0;
        return (int)Math.rint(points /= 72.0);
    }

    public static int pointsToPixel(double points) {
        points *= 96.0;
        return (int)Math.rint(points /= 72.0);
    }

    public static double pixelToPoints(int pixel) {
        double points = pixel;
        points *= 72.0;
        return points /= 96.0;
    }
}

