/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.formula.ptg.ScalarConstantPtg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class BoolPtg
extends ScalarConstantPtg {
    public static final int SIZE = 2;
    public static final byte sid = 29;
    private static final BoolPtg FALSE = new BoolPtg(false);
    private static final BoolPtg TRUE = new BoolPtg(true);
    private final boolean _value;

    private BoolPtg(boolean b2) {
        this._value = b2;
    }

    public static BoolPtg valueOf(boolean b2) {
        return b2 ? TRUE : FALSE;
    }

    public static BoolPtg read(LittleEndianInput in) {
        return BoolPtg.valueOf(in.readByte() == 1);
    }

    public boolean getValue() {
        return this._value;
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(29 + this.getPtgClass());
        out.writeByte(this._value ? 1 : 0);
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public String toFormulaString() {
        return this._value ? "TRUE" : "FALSE";
    }
}

