/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class BitmapImageRenderer
implements ImageRenderer {
    private static final POILogger LOG = POILogFactory.getLogger(ImageRenderer.class);
    protected BufferedImage img;

    @Override
    public void loadImage(InputStream data, String contentType) throws IOException {
        this.img = BitmapImageRenderer.readImage(data, contentType);
    }

    @Override
    public void loadImage(byte[] data, String contentType) throws IOException {
        this.img = BitmapImageRenderer.readImage(new ByteArrayInputStream(data), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readImage(InputStream data, String contentType) throws IOException {
        IOException lastException = null;
        BufferedImage img = null;
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(data);
        try {
            iis = new MemoryCacheImageInputStream(data);
            iis.mark();
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            while (img == null && iter.hasNext()) {
                ImageReader reader = iter.next();
                ImageReadParam param = reader.getDefaultReadParam();
                for (int mode = 0; img == null && mode < 2; ++mode) {
                    iis.reset();
                    iis.mark();
                    if (mode == 1) {
                        Iterator<ImageTypeSpecifier> imageTypes = reader.getImageTypes(0);
                        while (imageTypes.hasNext()) {
                            ImageTypeSpecifier imageTypeSpecifier = imageTypes.next();
                            int bufferedImageType = imageTypeSpecifier.getBufferedImageType();
                            if (bufferedImageType != 10) continue;
                            param.setDestinationType(imageTypeSpecifier);
                            break;
                        }
                    }
                    try {
                        reader.setInput(iis, false, true);
                        img = reader.read(0, param);
                        continue;
                    }
                    catch (IOException e2) {
                        lastException = e2;
                        continue;
                    }
                    catch (RuntimeException e3) {
                        lastException = new IOException("ImageIO runtime exception - " + (mode == 0 ? "normal" : "fallback"), e3);
                    }
                }
                reader.dispose();
            }
        }
        finally {
            iis.close();
        }
        if (img == null) {
            if (lastException != null) {
                throw lastException;
            }
            LOG.log(5, new Object[]{"Content-type: " + contentType + " is not support. Image ignored."});
            return null;
        }
        if (img.getType() != 2) {
            BufferedImage argbImg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Graphics g2 = argbImg.getGraphics();
            g2.drawImage(img, 0, 0, null);
            g2.dispose();
            return argbImg;
        }
        return img;
    }

    @Override
    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    public BufferedImage getImage(Dimension dim) {
        double w_old = this.img.getWidth();
        double h_old = this.img.getHeight();
        BufferedImage scaled = new BufferedImage((int)w_old, (int)h_old, 2);
        double w_new = dim.getWidth();
        double h_new = dim.getHeight();
        AffineTransform at = new AffineTransform();
        at.scale(w_new / w_old, h_new / h_old);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        scaleOp.filter(this.img, scaled);
        return scaled;
    }

    @Override
    public Dimension getDimension() {
        return this.img == null ? new Dimension(0, 0) : new Dimension(this.img.getWidth(), this.img.getHeight());
    }

    @Override
    public void setAlpha(double alpha) {
        if (this.img == null) {
            return;
        }
        Dimension dim = this.getDimension();
        BufferedImage newImg = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 2);
        Graphics2D g2 = newImg.createGraphics();
        RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)alpha}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        g2.drawImage(this.img, op, 0, 0);
        g2.dispose();
        this.img = newImg;
    }

    @Override
    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor) {
        return this.drawImage(graphics, anchor, null);
    }

    @Override
    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor, Insets clip) {
        if (this.img == null) {
            return false;
        }
        boolean isClipped = true;
        if (clip == null) {
            isClipped = false;
            clip = new Insets(0, 0, 0, 0);
        }
        int iw = this.img.getWidth();
        int ih = this.img.getHeight();
        double cw = (double)(100000 - clip.left - clip.right) / 100000.0;
        double ch = (double)(100000 - clip.top - clip.bottom) / 100000.0;
        double sx = anchor.getWidth() / ((double)iw * cw);
        double sy = anchor.getHeight() / ((double)ih * ch);
        double tx = anchor.getX() - (double)iw * sx * (double)clip.left / 100000.0;
        double ty = anchor.getY() - (double)ih * sy * (double)clip.top / 100000.0;
        AffineTransform at = new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
        Shape clipOld = graphics.getClip();
        if (isClipped) {
            graphics.clip(anchor.getBounds2D());
        }
        graphics.drawRenderedImage(this.img, at);
        graphics.setClip(clipOld);
        return true;
    }
}

