/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.macros;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.RLEDecompressingInputStream;
import org.apache.poi.util.StringUtil;

public class VBAMacroReader
implements Closeable {
    protected static final String VBA_PROJECT_OOXML = "vbaProject.bin";
    protected static final String VBA_PROJECT_POIFS = "VBA";
    private NPOIFSFileSystem fs;
    private static final int EOF = -1;
    private static final int VERSION_INDEPENDENT_TERMINATOR = 16;
    private static final int VERSION_DEPENDENT_TERMINATOR = 43;
    private static final int PROJECTVERSION = 9;
    private static final int PROJECTCODEPAGE = 3;
    private static final int STREAMNAME = 26;
    private static final int MODULEOFFSET = 49;
    private static final int MODULETYPE_PROCEDURAL = 33;
    private static final int MODULETYPE_DOCUMENT_CLASS_OR_DESIGNER = 34;
    private static final int PROJECTLCID = 2;

    public VBAMacroReader(InputStream rstream) throws IOException {
        PushbackInputStream stream = new PushbackInputStream(rstream, 8);
        byte[] header8 = IOUtils.peekFirst8Bytes(stream);
        if (NPOIFSFileSystem.hasPOIFSHeader(header8)) {
            this.fs = new NPOIFSFileSystem(stream);
        } else {
            this.openOOXML(stream);
        }
    }

    public VBAMacroReader(File file) throws IOException {
        try {
            this.fs = new NPOIFSFileSystem(file);
        }
        catch (OfficeXmlFileException e2) {
            this.openOOXML(new FileInputStream(file));
        }
    }

    public VBAMacroReader(NPOIFSFileSystem fs) {
        this.fs = fs;
    }

    private void openOOXML(InputStream zipFile) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zis = new ZipInputStream(zipFile);
        while ((zipEntry = zis.getNextEntry()) != null) {
            if (!StringUtil.endsWithIgnoreCase(zipEntry.getName(), VBA_PROJECT_OOXML)) continue;
            try {
                this.fs = new NPOIFSFileSystem(zis);
                return;
            }
            catch (IOException e2) {
                zis.close();
                throw e2;
            }
        }
        zis.close();
        throw new IllegalArgumentException("No VBA project found");
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
        this.fs = null;
    }

    public Map<String, String> readMacros() throws IOException {
        ModuleMap modules = new ModuleMap();
        this.findMacros(this.fs.getRoot(), modules);
        HashMap<String, String> moduleSources = new HashMap<String, String>();
        for (Map.Entry entry : modules.entrySet()) {
            Module module = (Module)entry.getValue();
            if (module.buf == null || module.buf.length <= 0) continue;
            moduleSources.put((String)entry.getKey(), new String(module.buf, modules.charset));
        }
        return moduleSources;
    }

    protected void findMacros(DirectoryNode dir, ModuleMap modules) throws IOException {
        if (VBA_PROJECT_POIFS.equalsIgnoreCase(dir.getName())) {
            this.readMacros(dir, modules);
        } else {
            for (Entry child : dir) {
                if (!(child instanceof DirectoryNode)) continue;
                this.findMacros((DirectoryNode)child, modules);
            }
        }
    }

    private static String readString(InputStream stream, int length, Charset charset) throws IOException {
        byte[] buffer = new byte[length];
        int count = stream.read(buffer);
        return new String(buffer, 0, count, charset);
    }

    private static void readModule(RLEDecompressingInputStream in, String streamName, ModuleMap modules) throws IOException {
        int moduleOffset = in.readInt();
        Module module = (Module)modules.get(streamName);
        if (module == null) {
            module = new Module();
            module.offset = moduleOffset;
            modules.put(streamName, module);
        } else {
            RLEDecompressingInputStream stream = new RLEDecompressingInputStream(new ByteArrayInputStream(module.buf, moduleOffset, module.buf.length - moduleOffset));
            module.read(stream);
            ((InputStream)stream).close();
        }
    }

    private static void readModule(DocumentInputStream dis, String name, ModuleMap modules) throws IOException {
        Module module = (Module)modules.get(name);
        if (module == null) {
            module = new Module();
            modules.put(name, module);
            module.read(dis);
        } else {
            if (module.offset == null) {
                throw new IOException("Module offset for '" + name + "' was never read.");
            }
            long skippedBytes = dis.skip(module.offset.intValue());
            if (skippedBytes != (long)module.offset.intValue()) {
                throw new IOException("tried to skip " + module.offset + " bytes, but actually skipped " + skippedBytes + " bytes");
            }
            RLEDecompressingInputStream stream = new RLEDecompressingInputStream(dis);
            module.read(stream);
            ((InputStream)stream).close();
        }
    }

    private static void trySkip(InputStream in, long n2) throws IOException {
        long skippedBytes = in.skip(n2);
        if (skippedBytes != n2) {
            if (skippedBytes < 0L) {
                throw new IOException("Tried skipping " + n2 + " bytes, but no bytes were skipped. " + "The end of the stream has been reached or the stream is closed.");
            }
            throw new IOException("Tried skipping " + n2 + " bytes, but only " + skippedBytes + " bytes were skipped. " + "This should never happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMacros(DirectoryNode macroDir, ModuleMap modules) throws IOException {
        Iterator<Entry> i$ = macroDir.iterator();
        block14: while (true) {
            DocumentInputStream dis;
            block18: {
                if (!i$.hasNext()) {
                    return;
                }
                Entry entry = i$.next();
                if (!(entry instanceof DocumentNode)) continue;
                String name = entry.getName();
                DocumentNode document = (DocumentNode)entry;
                dis = new DocumentInputStream(document);
                if (!"dir".equalsIgnoreCase(name)) {
                    if (StringUtil.startsWithIgnoreCase(name, "__SRP") || StringUtil.startsWithIgnoreCase(name, "_VBA_PROJECT")) continue;
                    VBAMacroReader.readModule(dis, name, modules);
                    continue;
                }
                break block18;
                finally {
                    dis.close();
                    continue;
                }
            }
            RLEDecompressingInputStream in = new RLEDecompressingInputStream(dis);
            String streamName = null;
            int recordId = 0;
            try {
                block15: while (true) {
                    if (-1 == (recordId = in.readShort()) || 16 == recordId) continue block14;
                    int recordLength = in.readInt();
                    switch (recordId) {
                        case 9: {
                            VBAMacroReader.trySkip(in, 6L);
                            continue block15;
                        }
                        case 3: {
                            int codepage = in.readShort();
                            modules.charset = Charset.forName("Cp" + codepage);
                            continue block15;
                        }
                        case 26: {
                            streamName = VBAMacroReader.readString(in, recordLength, modules.charset);
                            continue block15;
                        }
                        case 49: {
                            VBAMacroReader.readModule(in, streamName, modules);
                            continue block15;
                        }
                    }
                    VBAMacroReader.trySkip(in, recordLength);
                }
            }
            catch (IOException e2) {
                throw new IOException("Error occurred while reading macros at section id " + recordId + " (" + HexDump.shortToHex(recordId) + ")", e2);
            }
            finally {
                in.close();
                continue;
            }
            break;
        }
    }

    protected static class ModuleMap
    extends HashMap<String, Module> {
        Charset charset = Charset.forName("Cp1252");

        protected ModuleMap() {
        }
    }

    protected static class Module {
        Integer offset;
        byte[] buf;

        protected Module() {
        }

        void read(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy(in, out);
            out.close();
            this.buf = out.toByteArray();
        }
    }
}

