/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.File;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class POIFSDocumentPath {
    private static final POILogger log = POILogFactory.getLogger(POIFSDocumentPath.class);
    private final String[] components;
    private int hashcode = 0;

    public POIFSDocumentPath(String[] components) throws IllegalArgumentException {
        if (components == null) {
            this.components = new String[0];
        } else {
            this.components = new String[components.length];
            for (int j2 = 0; j2 < components.length; ++j2) {
                if (components[j2] == null || components[j2].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[j2] = components[j2];
            }
        }
    }

    public POIFSDocumentPath() {
        this.components = new String[0];
    }

    public POIFSDocumentPath(POIFSDocumentPath path, String[] components) throws IllegalArgumentException {
        int j2;
        this.components = components == null ? new String[path.components.length] : new String[path.components.length + components.length];
        for (j2 = 0; j2 < path.components.length; ++j2) {
            this.components[j2] = path.components[j2];
        }
        if (components != null) {
            for (j2 = 0; j2 < components.length; ++j2) {
                if (components[j2] == null) {
                    throw new IllegalArgumentException("components cannot contain null");
                }
                if (components[j2].length() == 0) {
                    log.log(5, new Object[]{"Directory under " + path + " has an empty name, " + "not all OLE2 readers will handle this file correctly!"});
                }
                this.components[j2 + path.components.length] = components[j2];
            }
        }
    }

    public boolean equals(Object o2) {
        boolean rval = false;
        if (o2 != null && o2.getClass() == this.getClass()) {
            if (this == o2) {
                rval = true;
            } else {
                POIFSDocumentPath path = (POIFSDocumentPath)o2;
                if (path.components.length == this.components.length) {
                    rval = true;
                    for (int j2 = 0; j2 < this.components.length; ++j2) {
                        if (path.components[j2].equals(this.components[j2])) continue;
                        rval = false;
                        break;
                    }
                }
            }
        }
        return rval;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.computeHashCode();
        }
        return this.hashcode;
    }

    private int computeHashCode() {
        int code = 0;
        for (int j2 = 0; j2 < this.components.length; ++j2) {
            code += this.components[j2].hashCode();
        }
        return code;
    }

    public int length() {
        return this.components.length;
    }

    public String getComponent(int n2) throws ArrayIndexOutOfBoundsException {
        return this.components[n2];
    }

    public POIFSDocumentPath getParent() {
        int length = this.components.length - 1;
        if (length < 0) {
            return null;
        }
        String[] parentComponents = new String[length];
        System.arraycopy(this.components, 0, parentComponents, 0, length);
        POIFSDocumentPath parent = new POIFSDocumentPath(parentComponents);
        return parent;
    }

    public String getName() {
        if (this.components.length == 0) {
            return "";
        }
        return this.components[this.components.length - 1];
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        int l2 = this.length();
        b2.append(File.separatorChar);
        for (int i2 = 0; i2 < l2; ++i2) {
            b2.append(this.getComponent(i2));
            if (i2 >= l2 - 1) continue;
            b2.append(File.separatorChar);
        }
        return b2.toString();
    }
}

