/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.cryptoapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionHeader;
import org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import org.apache.poi.poifs.crypt.EncryptionVerifier;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionInfoBuilder;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.BoundedInputStream;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.StringUtil;

public class CryptoAPIDecryptor
extends Decryptor {
    private long _length = -1L;

    protected CryptoAPIDecryptor(CryptoAPIEncryptionInfoBuilder builder) {
        super(builder);
    }

    @Override
    public boolean verifyPassword(String password) {
        EncryptionVerifier ver = this.builder.getVerifier();
        SecretKey skey = CryptoAPIDecryptor.generateSecretKey(password, ver);
        try {
            Cipher cipher = CryptoAPIDecryptor.initCipherForBlock(null, 0, this.builder, skey, 2);
            byte[] encryptedVerifier = ver.getEncryptedVerifier();
            byte[] verifier = new byte[encryptedVerifier.length];
            cipher.update(encryptedVerifier, 0, encryptedVerifier.length, verifier);
            this.setVerifier(verifier);
            byte[] encryptedVerifierHash = ver.getEncryptedVerifierHash();
            byte[] verifierHash = cipher.doFinal(encryptedVerifierHash);
            HashAlgorithm hashAlgo = ver.getHashAlgorithm();
            MessageDigest hashAlg = CryptoFunctions.getMessageDigest(hashAlgo);
            byte[] calcVerifierHash = hashAlg.digest(verifier);
            if (Arrays.equals(calcVerifierHash, verifierHash)) {
                this.setSecretKey(skey);
                return true;
            }
        }
        catch (GeneralSecurityException e2) {
            throw new EncryptedDocumentException(e2);
        }
        return false;
    }

    public Cipher initCipherForBlock(Cipher cipher, int block) throws GeneralSecurityException {
        return CryptoAPIDecryptor.initCipherForBlock(cipher, block, this.builder, this.getSecretKey(), 2);
    }

    protected static Cipher initCipherForBlock(Cipher cipher, int block, EncryptionInfoBuilder builder, SecretKey skey, int encryptMode) throws GeneralSecurityException {
        EncryptionVerifier ver = builder.getVerifier();
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        byte[] blockKey = new byte[4];
        LittleEndian.putUInt(blockKey, 0, block);
        MessageDigest hashAlg = CryptoFunctions.getMessageDigest(hashAlgo);
        hashAlg.update(skey.getEncoded());
        byte[] encKey = hashAlg.digest(blockKey);
        EncryptionHeader header = builder.getHeader();
        int keyBits = header.getKeySize();
        encKey = CryptoFunctions.getBlock0(encKey, keyBits / 8);
        if (keyBits == 40) {
            encKey = CryptoFunctions.getBlock0(encKey, 16);
        }
        SecretKeySpec key = new SecretKeySpec(encKey, skey.getAlgorithm());
        if (cipher == null) {
            cipher = CryptoFunctions.getCipher(key, header.getCipherAlgorithm(), null, null, encryptMode);
        } else {
            cipher.init(encryptMode, key);
        }
        return cipher;
    }

    protected static SecretKey generateSecretKey(String password, EncryptionVerifier ver) {
        if (password.length() > 255) {
            password = password.substring(0, 255);
        }
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        MessageDigest hashAlg = CryptoFunctions.getMessageDigest(hashAlgo);
        hashAlg.update(ver.getSalt());
        byte[] hash = hashAlg.digest(StringUtil.getToUnicodeLE(password));
        SecretKeySpec skey = new SecretKeySpec(hash, ver.getCipherAlgorithm().jceId);
        return skey;
    }

    @Override
    public InputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        NPOIFSFileSystem fsOut = new NPOIFSFileSystem();
        DocumentNode es = (DocumentNode)dir.getEntry("EncryptedSummary");
        DocumentInputStream dis = dir.createDocumentInputStream(es);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(dis, bos);
        dis.close();
        SeekableByteArrayInputStream sbis = new SeekableByteArrayInputStream(bos.toByteArray());
        LittleEndianInputStream leis = new LittleEndianInputStream(sbis);
        int streamDescriptorArrayOffset = (int)leis.readUInt();
        leis.readUInt();
        sbis.skip(streamDescriptorArrayOffset - 8);
        sbis.setBlock(0);
        int encryptedStreamDescriptorCount = (int)leis.readUInt();
        StreamDescriptorEntry[] entries = new StreamDescriptorEntry[encryptedStreamDescriptorCount];
        for (int i2 = 0; i2 < encryptedStreamDescriptorCount; ++i2) {
            StreamDescriptorEntry entry;
            entries[i2] = entry = new StreamDescriptorEntry();
            entry.streamOffset = (int)leis.readUInt();
            entry.streamSize = (int)leis.readUInt();
            entry.block = leis.readUShort();
            int nameSize = leis.readUByte();
            entry.flags = leis.readUByte();
            entry.reserved2 = leis.readInt();
            entry.streamName = StringUtil.readUnicodeLE(leis, nameSize);
            leis.readShort();
            assert (entry.streamName.length() == nameSize);
        }
        for (StreamDescriptorEntry entry : entries) {
            sbis.seek(entry.streamOffset);
            sbis.setBlock(entry.block);
            BoundedInputStream is = new BoundedInputStream(sbis, entry.streamSize);
            fsOut.createDocument(is, entry.streamName);
            ((InputStream)is).close();
        }
        leis.close();
        sbis.close();
        sbis = null;
        bos.reset();
        fsOut.writeFilesystem(bos);
        fsOut.close();
        this._length = bos.size();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return bis;
    }

    @Override
    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("Decryptor.getDataStream() was not called");
        }
        return this._length;
    }

    static class StreamDescriptorEntry {
        static BitField flagStream = BitFieldFactory.getInstance(1);
        int streamOffset;
        int streamSize;
        int block;
        int flags;
        int reserved2;
        String streamName;

        StreamDescriptorEntry() {
        }
    }

    private class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        Cipher cipher;
        byte[] oneByte;

        public void seek(int newpos) {
            if (newpos > this.count) {
                throw new ArrayIndexOutOfBoundsException(newpos);
            }
            this.pos = newpos;
            this.mark = newpos;
        }

        public void setBlock(int block) throws GeneralSecurityException {
            this.cipher = CryptoAPIDecryptor.this.initCipherForBlock(this.cipher, block);
        }

        @Override
        public synchronized int read() {
            int ch = super.read();
            if (ch == -1) {
                return -1;
            }
            this.oneByte[0] = (byte)ch;
            try {
                this.cipher.update(this.oneByte, 0, 1, this.oneByte);
            }
            catch (ShortBufferException e2) {
                throw new EncryptedDocumentException(e2);
            }
            return this.oneByte[0];
        }

        @Override
        public synchronized int read(byte[] b2, int off, int len) {
            int readLen = super.read(b2, off, len);
            if (readLen == -1) {
                return -1;
            }
            try {
                this.cipher.update(b2, off, readLen, b2, off);
            }
            catch (ShortBufferException e2) {
                throw new EncryptedDocumentException(e2);
            }
            return readLen;
        }

        public SeekableByteArrayInputStream(byte[] buf) throws GeneralSecurityException {
            super(buf);
            this.oneByte = new byte[]{0};
            this.cipher = CryptoAPIDecryptor.this.initCipherForBlock(null, 0);
        }
    }
}

