/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.WordComparator;
import com.wintertree.util.UniCharacter;

public class TypographicalComparator
implements WordComparator {
    private boolean isAccented;
    static final int CASE_MISMATCH_PENALTY = 5;
    static final int ACCENT_MISMATCH_PENALTY = 10;
    static final int DOUBLE_CONSONANT_INS_DEL_PENALTY = 20;
    static final int DOUBLE_VOWEL_INS_DEL_PENALTY = 25;
    static final int VOWEL_TRANSPOSITION_PENALTY = 20;
    static final int CONSONANT_TRANSPOSITION_PENALTY = 25;
    static final int TRANSPOSITION_PENALTY = 25;
    static final int INS_DEL_PENALTY = 50;
    static final int SUBSTITUTE_PENALTY = 100;
    static final int EXACT_MATCH_SCORE = 100;
    static final int FIRST_BASE = 65;
    private static final short[][] charSimTbl = new short[][]{{100, 0, 5, 15, 40, 0, 0, 0, 20, 0, 0, 0, 0, 0, 40, 0, 40, 0, 20, 0, 20, 0, 20, 0, 0, 0}, {0, 100, 0, 15, 0, 5, 10, 15, 0, 0, 0, 5, 0, 20, 10, 20, 5, 0, 0, 10, 0, 20, 0, 0, 0, 0}, {5, 0, 100, 20, 20, 10, 0, 0, 0, 0, 20, 0, 0, 0, 10, 0, 20, 0, 10, 0, 0, 20, 0, 20, 0, 20}, {15, 15, 20, 100, 10, 20, 0, 0, 0, 0, 0, 5, 0, 0, 5, 5, 5, 5, 20, 20, 0, 0, 5, 10, 0, 0}, {40, 0, 20, 10, 100, 0, 0, 0, 20, 0, 0, 0, 0, 0, 40, 0, 0, 20, 10, 5, 20, 0, 20, 0, 5, 0}, {0, 5, 10, 20, 0, 100, 20, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 10, 10, 10, 0, 30, 0, 0, 0, 0}, {0, 10, 0, 0, 0, 20, 100, 20, 0, 20, 0, 0, 0, 0, 0, 0, 5, 5, 0, 10, 0, 10, 0, 0, 5, 0}, {0, 15, 0, 0, 0, 0, 20, 100, 0, 20, 20, 10, 0, 10, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 10, 0}, {20, 0, 0, 0, 20, 5, 0, 0, 100, 25, 10, 25, 0, 0, 40, 0, 0, 0, 0, 5, 40, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 20, 20, 25, 100, 20, 0, 10, 10, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0}, {0, 0, 20, 0, 0, 0, 0, 20, 10, 20, 100, 30, 10, 0, 5, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 5, 0, 5, 0, 0, 0, 10, 25, 0, 30, 100, 0, 0, 5, 0, 0, 5, 0, 20, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 0, 100, 60, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0}, {0, 20, 0, 0, 0, 0, 0, 10, 0, 10, 0, 0, 60, 100, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0}, {40, 10, 10, 5, 40, 0, 0, 0, 40, 0, 5, 0, 0, 0, 100, 30, 20, 0, 0, 0, 20, 0, 10, 0, 0, 0}, {0, 20, 0, 5, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 30, 100, 20, 0, 0, 20, 0, 0, 0, 0, 0, 0}, {40, 5, 20, 5, 0, 0, 5, 0, 0, 0, 20, 0, 0, 0, 20, 20, 100, 0, 0, 0, 0, 0, 20, 0, 0, 0}, {0, 0, 0, 5, 20, 10, 5, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 100, 0, 20, 0, 0, 0, 0, 0, 0}, {20, 0, 10, 20, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 0, 10, 20, 0, 25}, {0, 10, 20, 5, 10, 10, 0, 0, 5, 0, 0, 20, 0, 0, 0, 20, 0, 20, 0, 100, 0, 0, 0, 0, 20, 0}, {20, 0, 0, 0, 20, 0, 0, 5, 40, 10, 0, 0, 0, 20, 20, 0, 0, 0, 0, 0, 100, 20, 10, 0, 20, 0}, {0, 20, 20, 0, 0, 30, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 100, 20, 0, 10, 0}, {20, 0, 0, 5, 20, 0, 0, 0, 0, 0, 0, 0, 10, 0, 10, 0, 20, 0, 10, 0, 10, 20, 100, 0, 0, 0}, {0, 0, 20, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 100, 0, 20}, {0, 0, 0, 0, 5, 0, 5, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 10, 0, 0, 100, 0}, {0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 20, 0, 100}};

    public TypographicalComparator() {
        this.isAccented = false;
    }

    public TypographicalComparator(boolean bl) {
        this.isAccented = bl;
    }

    public int compare(String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < string.length() && n5 < string2.length()) {
            char c2;
            ++n3;
            char c3 = string.charAt(n4);
            if (c3 != (c2 = string2.charAt(n5))) {
                char c4;
                char c5;
                char c6 = '\u0000';
                char c7 = '\u0000';
                if (this.isAccented || !UniCharacter.isASCII(c3) || !UniCharacter.isASCII(c2)) {
                    c5 = UniCharacter.toBase(c3);
                    c4 = UniCharacter.toBase(c2);
                } else {
                    c5 = Character.toUpperCase(c3);
                    c4 = Character.toUpperCase(c2);
                }
                if (c5 == c4) {
                    if (UniCharacter.isLowerCase(c3) != UniCharacter.isLowerCase(c2)) {
                        n2 += 95;
                    }
                    if (Character.toLowerCase(c3) != Character.toLowerCase(c2)) {
                        n2 += 90;
                    }
                    ++n4;
                    ++n5;
                    continue;
                }
                if (this.isAccented) {
                    if (n4 + 1 < string.length()) {
                        c6 = UniCharacter.toBase(string.charAt(n4 + 1));
                    }
                    if (n5 + 1 < string2.length()) {
                        c7 = UniCharacter.toBase(string2.charAt(n5 + 1));
                    }
                } else {
                    char c8;
                    if (n4 + 1 < string.length()) {
                        c8 = string.charAt(n4 + 1);
                        c6 = UniCharacter.isASCII(c8) ? Character.toUpperCase(c8) : UniCharacter.toBase(c8);
                    }
                    if (n5 + 1 < string2.length()) {
                        c8 = string2.charAt(n5 + 1);
                        c7 = UniCharacter.isASCII(c8) ? Character.toUpperCase(string2.charAt(n5 + 1)) : UniCharacter.toBase(c8);
                    }
                }
                if (c6 != '\u0000' && c7 != '\u0000' && c4 == c6 && c7 == c5) {
                    n2 = UniCharacter.isVowel(c5) && UniCharacter.isVowel(c4) ? (n2 += 160) : (!UniCharacter.isVowel(c5) && !UniCharacter.isVowel(c4) ? (n2 += 150) : (n2 += 150));
                    n4 += 2;
                    n5 += 2;
                    ++n3;
                    continue;
                }
                if (c6 != '\u0000' && c4 == c6) {
                    n2 = n4 > 0 && n5 > 0 && c3 == string.charAt(n4 - 1) && c3 == string2.charAt(n5 - 1) ? (UniCharacter.isVowel(c3) ? (n2 += 75) : (n2 += 80)) : (n2 += 50);
                    ++n4;
                    continue;
                }
                if (c7 != '\u0000' && c5 == c7) {
                    n2 = n4 > 0 && n5 > 0 && c2 == string2.charAt(n5 - 1) && c2 == string.charAt(n4 - 1) ? (UniCharacter.isVowel(c2) ? (n2 += 75) : (n2 += 80)) : (n2 += 50);
                    ++n5;
                    continue;
                }
                if (c5 >= 'A' && c5 - 65 < charSimTbl.length && c4 >= 'A' && c4 - 65 < charSimTbl[0].length) {
                    n2 += charSimTbl[c5 - 65][c4 - 65];
                    ++n4;
                    ++n5;
                    continue;
                }
                n2 += 0;
                ++n4;
                ++n5;
                continue;
            }
            n2 += 100;
            ++n4;
            ++n5;
        }
        if (n2 <= 0) {
            return 0;
        }
        while (n4++ < string.length()) {
            n2 += 50;
            ++n3;
        }
        while (n5++ < string2.length()) {
            n2 += 50;
            ++n3;
        }
        if (n2 <= 0 || n3 <= 0) {
            return 0;
        }
        return n2 / n3;
    }
}

