/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.Suggestion;
import java.util.Enumeration;
import java.util.Vector;

public class SuggestionSet {
    private int maxWords;
    private Vector suggestions;

    public SuggestionSet(int n2) {
        this.maxWords = n2;
        if (this.maxWords <= 0) {
            this.maxWords = 1;
        }
        this.suggestions = new Vector();
    }

    public boolean add(String string, int n2, boolean bl) {
        int n3;
        Suggestion suggestion;
        if (n2 <= 0) {
            return false;
        }
        if (this.suggestions.size() == this.maxWords) {
            suggestion = (Suggestion)this.suggestions.elementAt(this.suggestions.size() - 1);
            if (n2 <= suggestion.score) {
                return false;
            }
        }
        suggestion = new Suggestion();
        suggestion.word = new String(string);
        suggestion.score = n2;
        suggestion.matchCase = bl;
        int n4 = this.suggestions.indexOf(suggestion);
        if (n4 >= 0) {
            return false;
        }
        for (n3 = 0; n3 < this.suggestions.size(); ++n3) {
            Suggestion suggestion2 = (Suggestion)this.suggestions.elementAt(n3);
            if (n2 > suggestion2.score) break;
        }
        if (this.suggestions.size() >= this.maxWords) {
            this.suggestions.setSize(this.suggestions.size() - 1);
        }
        this.suggestions.insertElementAt(suggestion, n3);
        return true;
    }

    public boolean add(String string, int n2) {
        return this.add(string, n2, true);
    }

    public void clear() {
        this.suggestions.removeAllElements();
    }

    public void deleteAt(int n2) {
        this.suggestions.removeElementAt(n2);
    }

    public boolean getMatchCaseAt(int n2) {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n2);
        return suggestion.matchCase;
    }

    public void replaceAt(int n2, String string) {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n2);
        suggestion.word = new String(string);
        this.suggestions.setElementAt(suggestion, n2);
    }

    public int size() {
        return this.suggestions.size();
    }

    public int scoreAt(int n2) throws ArrayIndexOutOfBoundsException {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n2);
        return suggestion.score;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.suggestions.size(); ++i2) {
            Suggestion suggestion = (Suggestion)this.suggestions.elementAt(i2);
            stringBuffer.append(suggestion.word);
            if (i2 >= this.suggestions.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String wordAt(int n2) throws ArrayIndexOutOfBoundsException {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n2);
        return suggestion.word;
    }

    public Enumeration words() {
        Vector<String> vector = new Vector<String>(this.suggestions.size());
        for (int i2 = 0; i2 < this.suggestions.size(); ++i2) {
            Suggestion suggestion = (Suggestion)this.suggestions.elementAt(i2);
            vector.addElement(suggestion.word);
        }
        return vector.elements();
    }
}

