/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.WordParser;
import com.wintertree.util.UniCharacter;
import java.util.NoSuchElementException;

public class StringWordParser
implements WordParser {
    protected int cursor = 0;
    protected boolean is1stWord = true;
    protected boolean isHyphenDelimiter;
    protected int nReplacements;
    protected int nWords;
    protected StringBuffer theString;
    protected int subWordLength;
    protected StringBuffer cachedWord;

    public StringWordParser(String string, boolean bl) {
        this.isHyphenDelimiter = bl;
        this.nReplacements = 0;
        this.nWords = 0;
        this.theString = string != null ? new StringBuffer(string) : null;
        this.subWordLength = -1;
        this.cachedWord = new StringBuffer();
    }

    public StringWordParser(boolean bl) {
        this(null, bl);
    }

    public void deleteText(int n2) throws NoSuchElementException {
        if (n2 > this.theString.length() - this.cursor) {
            throw new NoSuchElementException();
        }
        String string = this.theString.toString().substring(this.cursor + n2);
        this.theString.setLength(this.cursor);
        this.theString.append(string);
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
    }

    public int deleteWord() throws NoSuchElementException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.deleteWord(stringBuffer);
    }

    public int deleteWord(StringBuffer stringBuffer) throws NoSuchElementException {
        int n2;
        for (n2 = this.cursor; n2 > 0 && UniCharacter.isWhitespace(this.theString.charAt(n2 - 1)); --n2) {
        }
        String string = this.getWord();
        int n3 = this.cursor - n2 + string.length();
        stringBuffer.setLength(0);
        stringBuffer.append(this.theString.toString().substring(n2, n2 + n3));
        this.cursor = n2;
        this.deleteText(n3);
        while (this.cursor < this.theString.length() && UniCharacter.isWhitespace(this.theString.charAt(this.cursor))) {
            ++this.cursor;
        }
        return n2;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getNumReplacements() {
        return this.nReplacements;
    }

    public int getNumWords() {
        return this.nWords;
    }

    public String getWord() throws NoSuchElementException {
        char c2;
        int n2;
        char c3;
        if (this.cachedWord.length() > 0) {
            return this.cachedWord.toString();
        }
        int n3 = this.findWordStart();
        if (n3 != this.cursor) {
            this.cursor = n3;
            this.subWordLength = -1;
            this.cachedWord.setLength(0);
        }
        if (this.subWordLength > 0 && this.cursor + this.subWordLength < this.theString.length()) {
            this.cachedWord.setLength(0);
            this.cachedWord.append(this.theString.toString().substring(this.cursor, this.cursor + this.subWordLength));
            return this.cachedWord.toString();
        }
        int n4 = this.theString.length();
        if (this.cursor >= n4) {
            throw new NoSuchElementException();
        }
        this.cachedWord.setLength(0);
        int n5 = 0;
        for (n3 = this.cursor; n3 < n4; ++n3) {
            c3 = this.theString.charAt(n3);
            if (c3 == '.' && StringWordParser.isSurroundedByWordChars(this.theString, n3)) {
                ++n5;
            }
            if (!this.includeCharInWord(this.theString, n3, n5 > 0)) break;
            this.cachedWord.append(c3);
        }
        c3 = '\u0001';
        if (n5 > 0) {
            n2 = 0;
            for (c2 = '\u0000'; c2 < this.cachedWord.length(); ++c2) {
                if (UniCharacter.isLetterOrDigit(this.cachedWord.charAt(c2))) {
                    if (++n2 <= 2) continue;
                    c3 = '\u0000';
                    break;
                }
                n2 = 0;
            }
            if (c3 != '\u0000' && n3 < n4 && this.theString.charAt(n3) == '.') {
                this.cachedWord.append(this.theString.charAt(n3));
                ++n5;
                ++n3;
            }
        }
        if (this.cachedWord.length() == 0) {
            return this.cachedWord.toString();
        }
        n2 = 0;
        do {
            c2 = this.cachedWord.charAt(this.cachedWord.length() - 1);
            n2 = 0;
            if (UniCharacter.isApostrophe(c2) && this.cachedWord.length() > 1 && Character.toLowerCase(this.cachedWord.charAt(this.cachedWord.length() - 2)) != 's') {
                this.cachedWord.setLength(this.cachedWord.length() - 1);
                n2 = 1;
            }
            if (c2 != '.' || c3 != '\u0000' && n5 != 1) continue;
            this.cachedWord.setLength(this.cachedWord.length() - 1);
            n2 = 1;
        } while (n2 != 0);
        return this.cachedWord.toString();
    }

    public boolean hasMoreElements() {
        boolean bl = true;
        try {
            String string = this.getWord();
            if (string.length() == 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void highlightWord() {
    }

    public void insertText(int n2, String string) {
        this.theString.insert(n2, string);
    }

    public boolean isDoubledWord(boolean bl) {
        String string = this.getWord();
        String string2 = this.getPrevWord();
        if (string2 == null) {
            return false;
        }
        boolean bl2 = bl ? string2.equals(string) : string2.equalsIgnoreCase(string);
        if (bl2) {
            char c2 = string2.charAt(string2.length() - 1);
            for (int i2 = this.cursor - 1; i2 >= 0 && bl2 && this.theString.charAt(i2) != c2; --i2) {
                if (UniCharacter.isWhitespace(this.theString.charAt(i2))) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    public boolean isFirstWord() {
        return this.is1stWord;
    }

    public Object nextElement() {
        return this.nextWord();
    }

    public String nextWord() throws NoSuchElementException {
        int n2 = this.findWordStart();
        if (n2 != this.cursor) {
            this.cachedWord.setLength(0);
            this.cursor = n2;
        }
        if (this.cursor >= this.theString.length()) {
            throw new NoSuchElementException();
        }
        String string = this.getWord();
        this.cursor += string.length();
        this.cursor = this.findWordStart();
        this.is1stWord = false;
        ++this.nWords;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
        return string;
    }

    public void replaceWord(String string) throws NoSuchElementException {
        String string2 = this.getWord();
        String string3 = this.theString.toString().substring(this.cursor + string2.length());
        this.theString.setLength(this.cursor);
        this.theString.append(string);
        this.theString.append(string3);
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
        ++this.nReplacements;
    }

    public void setCursor(int n2) throws StringIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.theString.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        this.cursor = n2;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
    }

    public void setText(String string) {
        if (this.theString == null) {
            this.theString = new StringBuffer();
        }
        this.theString.setLength(0);
        this.theString.append(string);
        this.cursor = 0;
        this.is1stWord = true;
        this.nReplacements = 0;
        this.nWords = 0;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
    }

    public void setWordLength(int n2) {
        this.subWordLength = n2;
        this.cachedWord.setLength(0);
    }

    public String toString() {
        return this.theString.toString();
    }

    protected int findWordStart() {
        int n2;
        int n3 = this.theString.length();
        for (n2 = this.cursor; n2 < n3 && !StringWordParser.is1stWordChar(this.theString.charAt(n2)); ++n2) {
        }
        return n2;
    }

    protected String getPrevWord() {
        int n2;
        for (n2 = this.cursor - 1; n2 >= 0 && UniCharacter.isApostrophe(this.theString.charAt(n2)); --n2) {
        }
        while (n2 >= 0 && !StringWordParser.isWordChar(this.theString.charAt(n2))) {
            --n2;
        }
        if (n2 < 0) {
            return null;
        }
        while (n2 > 0 && StringWordParser.isWordChar(this.theString.charAt(n2 - 1))) {
            --n2;
        }
        int n3 = this.cursor;
        int n4 = this.subWordLength;
        String string = this.cachedWord.toString();
        this.cursor = n2;
        this.subWordLength = -1;
        this.cachedWord.setLength(0);
        String string2 = this.getWord();
        if (this.cursor == n3) {
            string2 = null;
        }
        this.cursor = n3;
        this.subWordLength = n4;
        this.cachedWord.setLength(0);
        this.cachedWord.append(string);
        return string2;
    }

    protected boolean includeCharInWord(StringBuffer stringBuffer, int n2, boolean bl) {
        char c2 = stringBuffer.charAt(n2);
        int n3 = stringBuffer.length();
        if (c2 == '.') {
            if (StringWordParser.isSurroundedByWordChars(stringBuffer, n2)) {
                return true;
            }
        } else if (c2 == '-' && !this.isHyphenDelimiter) {
            if (StringWordParser.isSurroundedByWordChars(stringBuffer, n2)) {
                return true;
            }
        } else if ('@' == c2) {
            char c3;
            boolean bl2 = false;
            for (int i2 = n2 + 1; i2 < n3 && !UniCharacter.isWhitespace(c3 = stringBuffer.charAt(i2)); ++i2) {
                if ('.' != c3 || !StringWordParser.isSurroundedByWordChars(stringBuffer, i2)) continue;
                bl2 = true;
                break;
            }
            if (bl2 && StringWordParser.isSurroundedByWordChars(stringBuffer, n2)) {
                return true;
            }
        } else if (':' == c2) {
            if (n2 > 0 && UniCharacter.isLetterOrDigit(stringBuffer.charAt(n2 - 1)) && n2 + 1 < n3 && stringBuffer.charAt(n2 + 1) == '/') {
                return true;
            }
        } else if ('/' == c2) {
            if (bl) {
                return true;
            }
            if (n2 > 0 && (stringBuffer.charAt(n2 - 1) == ':' || stringBuffer.charAt(n2 - 1) == '/') && (n2 + 1 < n3 && stringBuffer.charAt(n2 + 1) == '/' || UniCharacter.isLetterOrDigit(stringBuffer.charAt(n2 + 1)))) {
                return true;
            }
        } else if ('&' == c2 || '%' == c2 || '+' == c2 || '=' == c2 || '?' == c2) {
            if (bl) {
                return true;
            }
        } else if ('_' == c2) {
            char c4;
            if (bl) {
                return true;
            }
            boolean bl3 = false;
            for (int i3 = n2 + 1; i3 < n3 && !UniCharacter.isWhitespace(c4 = stringBuffer.charAt(i3)); ++i3) {
                if ('.' != c4 || !StringWordParser.isSurroundedByWordChars(stringBuffer, i3)) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                return true;
            }
        } else if (StringWordParser.isWordChar(c2)) {
            return true;
        }
        return false;
    }

    protected boolean includeCharInWord(char c2, String string, int n2, boolean bl) {
        return this.includeCharInWord(new StringBuffer(string), n2, bl);
    }

    protected static boolean is1stWordChar(char c2) {
        return UniCharacter.isLetterOrDigit(c2);
    }

    private static boolean isSurroundedByWordChars(StringBuffer stringBuffer, int n2) {
        return n2 > 0 && StringWordParser.isWordChar(stringBuffer.charAt(n2 - 1)) && n2 + 1 < stringBuffer.length() && StringWordParser.isWordChar(stringBuffer.charAt(n2 + 1));
    }

    protected static boolean isWordChar(char c2) {
        return UniCharacter.isLetterOrDigit(c2) || UniCharacter.isApostrophe(c2);
    }
}

