/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordComparator;
import com.wintertree.ssce.WordParser;
import com.wintertree.util.UniCharacter;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SpellingSession
implements Serializable,
Cloneable {
    public static final int MAX_SUGGEST_DEPTH = 100;
    public static final int MAX_WORD_LEN = 63;
    public static final int CASE_SENSITIVE_OPT = 1;
    public static final int IGNORE_ALL_CAPS_WORD_OPT = 2;
    public static final int IGNORE_CAPPED_WORD_OPT = 4;
    public static final int IGNORE_MIXED_CASE_OPT = 8;
    public static final int IGNORE_MIXED_DIGITS_OPT = 16;
    public static final int IGNORE_NON_ALPHA_WORD_OPT = 32;
    public static final int REPORT_DOUBLED_WORD_OPT = 64;
    public static final int REPORT_MIXED_CASE_OPT = 128;
    public static final int REPORT_MIXED_DIGITS_OPT = 256;
    public static final int REPORT_SPELLING_OPT = 512;
    public static final int REPORT_UNCAPPED_OPT = 1024;
    public static final int SPLIT_CONTRACTED_WORDS_OPT = 2048;
    public static final int SPLIT_HYPHENATED_WORDS_OPT = 4096;
    public static final int SPLIT_WORDS_OPT = 8192;
    public static final int STRIP_POSSESSIVES_OPT = 16384;
    public static final int SUGGEST_SPLIT_WORDS_OPT = 32768;
    public static final int IGNORE_DOMAIN_NAMES_OPT = 65536;
    public static final int ALLOW_ACCENTED_CAPS_OPT = 131072;
    public static final int AUTO_CHANGE_WORD_RSLT = 1;
    public static final int CONDITIONALLY_CHANGE_WORD_RSLT = 2;
    public static final int DOUBLED_WORD_RSLT = 4;
    public static final int END_OF_TEXT_RSLT = 8;
    private static final int EXCLUDE_WORD_RSLT = 4096;
    public static final int MISSPELLED_WORD_RSLT = 16;
    public static final int MIXED_CASE_WORD_RSLT = 32;
    public static final int MIXED_DIGITS_WORD_RSLT = 64;
    public static final int OK_RSLT = 0;
    public static final int UNCAPPED_WORD_RSLT = 128;
    private static final int EXCLUDED_WORD_RSLT = 256;
    private Lexicon[] lexicons = null;
    private int options = 153121;
    private static Hashtable opts = null;
    private String misspelledWord = null;
    private int misspelledWordOffset = 0;

    public int check(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        return this.check(string, stringBuffer);
    }

    public int check(String string, StringBuffer stringBuffer) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        String string2 = string;
        if ((this.options & 0x4000) != 0) {
            string2 = SpellingSession.stripPossessives(string);
        }
        if ((n5 = string2.length()) == 0) {
            return n6;
        }
        stringBuffer.setLength(0);
        stringBuffer.append(string);
        this.misspelledWord = string;
        this.misspelledWordOffset = 0;
        if ((this.options & 0x200) == 0 && this.ignoreWord(string2)) {
            return n6;
        }
        if ((this.options & 0x200) != 0) {
            n4 = this.checkWord2(string2, stringBuffer);
            if ((n4 & 0x10) != 0) {
                CharSequence charSequence;
                if ((this.options & 0x2000) != 0) {
                    n3 = 0;
                    for (n2 = 2; n2 <= n5 - 2 && n3 == 0; ++n2) {
                        charSequence = string2.substring(0, n2);
                        String string3 = this.misspelledWord;
                        int n7 = this.misspelledWordOffset;
                        this.options &= 0xFFFFDFFF;
                        boolean bl = this.check((String)charSequence) == 0;
                        this.options |= 0x2000;
                        if (bl) {
                            if (this.check(string2.substring(n2)) == 0) {
                                n3 = 1;
                            } else {
                                StringBuffer stringBuffer2 = new StringBuffer();
                                stringBuffer2.append(Character.toUpperCase(string2.charAt(n2)));
                                if (string2.length() > n2 + 1) {
                                    stringBuffer2.append(string2.substring(n2 + 1));
                                }
                                if (this.check(stringBuffer2.toString()) == 0) {
                                    n3 = 1;
                                }
                            }
                        }
                        this.misspelledWord = string3;
                        this.misspelledWordOffset = n7;
                    }
                    if (n3 != 0) {
                        n4 &= 0xFFFFFFEF;
                    }
                }
                if ((n4 & 0x10) != 0 && (this.options & 0x1800) != 0 && this.containsSubWords(string2)) {
                    n3 = 1;
                    charSequence = new StringBuffer();
                    for (n2 = 0; n2 < n5 && n3 != 0; n2 += this.getSubWord(string2.substring(n2), (StringBuffer)charSequence)) {
                        this.misspelledWordOffset = n2;
                        int n8 = this.checkWord2(((StringBuffer)charSequence).toString(), stringBuffer);
                        if ((n8 & 0x1010) == 0) continue;
                        this.misspelledWord = ((StringBuffer)charSequence).toString();
                        n3 = 0;
                    }
                    if (n3 != 0) {
                        n4 &= 0xFFFFFFEF;
                    }
                }
            }
            if ((n4 & 0x1000) != 0) {
                n4 &= 0xFFFFEFFF;
                n4 |= 0x10;
            }
            n6 |= n4;
        }
        if ((this.options & 0x80) != 0 && this.isMixedCase(string2)) {
            n6 |= 0x20;
            for (n4 = 0; n4 < stringBuffer.length(); ++n4) {
                stringBuffer.setCharAt(n4, Character.toUpperCase(stringBuffer.charAt(n4)));
            }
            if (UniCharacter.isUpperCase(string.charAt(0)) && stringBuffer.length() > 0) {
                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            }
        }
        if ((this.options & 0x100) != 0) {
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                char c2 = string2.charAt(n2);
                if (!(UniCharacter.isApostrophe(c2) || UniCharacter.isLetter(c2) || UniCharacter.isHyphen(c2))) {
                    n4 = 1;
                    continue;
                }
                if (!UniCharacter.isLetter(c2)) continue;
                n3 = 1;
            }
            if (n3 != 0 && n4 != 0) {
                n6 |= 0x40;
            }
        }
        if ((n6 & 0x40) != 0) {
            n4 = 0;
            if (stringBuffer.length() > 0) {
                n4 = UniCharacter.isLetter(stringBuffer.charAt(0)) ? 1 : 0;
            }
            for (n3 = 0; n3 < stringBuffer.length(); ++n3) {
                n2 = stringBuffer.charAt(n3);
                if (n4 != 0 && UniCharacter.isDigit((char)n2) || n4 == 0 && UniCharacter.isLetter((char)n2)) {
                    stringBuffer.insert(n3, ' ');
                    ++n3;
                }
                n4 = UniCharacter.isLetter((char)n2) ? 1 : 0;
            }
        }
        if ((this.options & 0x400) != 0 && (this.options & 1) != 0 && (n6 & 0x10) != 0 && UniCharacter.isLowerCase(string.charAt(0))) {
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(Character.toUpperCase(string2.charAt(0)));
            stringBuffer3.append(string.substring(1));
            n4 = this.checkWord3(stringBuffer3.toString(), string2, stringBuffer);
            if (n4 != 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(stringBuffer3.toString());
                n6 |= 0x80;
            } else {
                String string4 = string.toUpperCase();
                n4 = this.checkWord3(string4, string2, stringBuffer);
                if (n4 != 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string4);
                    n6 |= 0x80;
                }
            }
        }
        if ((this.options & 0x20000) == 0 && (n6 & 0x10) == 0) {
            for (n4 = 0; n4 < n5; ++n4) {
                char c3 = string2.charAt(n4);
                if (!UniCharacter.isUpperCase(c3) || c3 == UniCharacter.toBase(c3)) continue;
                n6 |= 0x10;
                this.matchCase(stringBuffer, false, true, stringBuffer.toString());
                break;
            }
        }
        if (stringBuffer.length() > 0) {
            SpellingSession.restorePossessives(stringBuffer, string);
        }
        return n6;
    }

    public int check(WordParser wordParser, StringBuffer stringBuffer) {
        int n2 = 0;
        while (wordParser.hasMoreElements()) {
            String string = wordParser.getWord();
            n2 = this.check(string, stringBuffer);
            if ((this.options & 0x40) != 0 && !this.ignoreWord(string) && wordParser.isDoubledWord((this.options & 1) != 0)) {
                n2 |= 4;
                this.misspelledWordOffset = 0;
                this.misspelledWord = string;
            }
            if (n2 != 0) {
                if ((n2 & 0x10) != 0) {
                    wordParser.setCursor(wordParser.getCursor() + this.misspelledWordOffset);
                    wordParser.setWordLength(this.misspelledWord.length());
                }
                return n2;
            }
            wordParser.nextWord();
        }
        return 8;
    }

    public Object clone() {
        SpellingSession spellingSession = null;
        try {
            spellingSession = (SpellingSession)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        spellingSession.setLexicons(this.getLexicons());
        spellingSession.options = this.options;
        spellingSession.misspelledWord = this.misspelledWord != null ? new String(this.misspelledWord) : null;
        spellingSession.misspelledWordOffset = this.misspelledWordOffset;
        return spellingSession;
    }

    public Lexicon[] getLexicons() {
        return this.lexicons;
    }

    public boolean getOption(int n2) {
        return (this.options & n2) != 0;
    }

    public static int getOption(Integer n2) {
        if (opts != null) {
            Integer n3 = (Integer)opts.get(n2);
            if (n3 == null) {
                return 0;
            }
            return n3;
        }
        return 0;
    }

    public String getMisspelledWord() {
        return this.misspelledWord;
    }

    public int getMisspelledWordOffset() {
        return this.misspelledWordOffset;
    }

    public void setLexicons(Lexicon[] lexiconArray) {
        try {
            int n2;
            if (lexiconArray == null) {
                throw new UnsupportedException();
            }
            try {
                n2 = -1479411111;
                int n3 = 139;
                int n4 = 140;
                int n5 = 647;
                int n6 = 1999;
                int n7 = 151;
                int n8 = 499;
                int n9 = SpellingSession.getOption(new Integer(32));
                if ((n9 & 0xF3) == 162) {
                    int n10 = (n9 & 0x1F00) >> 8;
                    int n11 = (n9 & 0x1FFE000) >> 13;
                    int n12 = (n9 & 0xC) >> 2;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000 + n12 * 10, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n11 * 86400000L);
                    long l2 = System.currentTimeMillis();
                    long l3 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n13 = n9 & 0x7FFFE000;
                    int n14 = 0;
                    for (int i2 = 0; i2 < 32; ++i2) {
                        n14 += n13 & 1;
                        n13 >>= 1;
                    }
                    if (n14 != n10) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l2 > l3 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                for (int i4 = 0; i4 < stringArray[i3].length(); ++i4) {
                                    System.out.print((char)(stringArray[i3].charAt(i4) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l2 / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l2 > l3 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i5 = 0; i5 < stringArray.length; ++i5) {
                            for (int i6 = 0; i6 < stringArray[i5].length(); ++i6) {
                                System.out.print((char)(stringArray[i5].charAt(i6) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l2 / 1000L)));
                    }
                } else {
                    int n15;
                    long l4 = n9 ^ n2;
                    long l5 = 0L;
                    for (n15 = 0; n15 < 32; ++n15) {
                        long l6 = l4 >> n15 & 1L;
                        l5 |= l6 << 31 - n15;
                    }
                    n15 = (int)(l5 / 10000L);
                    if (n15 != n3 && n15 != n4) {
                        throw new Exception();
                    }
                    int n16 = (int)(l5 % 10000L);
                    if (n15 == n3 && n16 < n5 || n16 > n6) {
                        throw new Exception();
                    }
                    if (n15 == n4 && (n16 < n7 || n16 > n8)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l7 = System.currentTimeMillis();
                while (System.currentTimeMillis() < l7 + 1000L) {
                }
                throw new UnsupportedException();
            }
            this.lexicons = new Lexicon[lexiconArray.length];
            for (n2 = 0; n2 < lexiconArray.length; ++n2) {
                this.lexicons[n2] = lexiconArray[n2];
            }
        }
        catch (UnsupportedException unsupportedException) {
            this.lexicons = new Lexicon[0];
        }
    }

    public boolean setOption(int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.options & n2) != 0;
        this.options = bl ? (this.options |= n2) : (this.options &= ~n2);
        return bl2;
    }

    public static void setOption(Integer n2, Integer n3) {
        if (opts == null) {
            opts = new Hashtable();
        }
        opts.put(n2, n3);
    }

    public void suggest(String string, int n2, WordComparator wordComparator, SuggestionSet suggestionSet) {
        int n3;
        int n4;
        int n5;
        int n6;
        CharSequence charSequence;
        int n7;
        String string2 = string;
        if ((this.options & 0x4000) != 0) {
            string2 = SpellingSession.stripPossessives(string);
        }
        if (string2.length() == 0) {
            return;
        }
        for (n7 = this.lexicons.length - 1; n7 >= 0; --n7) {
            if (this.lexicons[n7] == null) continue;
            this.lexicons[n7].suggest(string2, n2, wordComparator, suggestionSet);
        }
        if ((this.options & 0x8000) != 0) {
            for (n7 = 1; n7 < string2.length(); ++n7) {
                charSequence = string2.substring(0, n7);
                String string3 = string2.substring(n7);
                n6 = this.options;
                this.options |= 0x200;
                if (this.check((String)charSequence) == 0 && this.check(string3) == 0) {
                    String string4 = (String)charSequence + " " + string3;
                    suggestionSet.add(string4, wordComparator.compare(string, string4));
                }
                this.options = n6;
            }
        }
        if ((this.options & 0x4000) != 0 && string2.length() >= 2 && ((n7 = (int)string2.charAt(string2.length() - 1)) == 115 || n7 == 83 && !UniCharacter.isApostrophe(string2.charAt(string2.length() - 2)))) {
            charSequence = new StringBuffer(string2);
            ((StringBuffer)charSequence).insert(((StringBuffer)charSequence).length() - 1, '\'');
            if (this.check(((StringBuffer)charSequence).toString()) != 16) {
                suggestionSet.add(((StringBuffer)charSequence).toString(), wordComparator.compare(string, ((StringBuffer)charSequence).toString()));
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (n5 = 0; n5 < stringBuffer.length() - 1; ++n5) {
            char c2 = stringBuffer.charAt(n5);
            n6 = stringBuffer.charAt(n5 + 1);
            char c3 = c2;
            n4 = n6;
            if (UniCharacter.isUpperCase(c3) && UniCharacter.isLowerCase((char)n4)) {
                c3 = Character.toLowerCase(c3);
                n4 = Character.toUpperCase((char)n4);
            }
            stringBuffer.setCharAt(n5, (char)n4);
            stringBuffer.setCharAt(n5 + 1, c3);
            if (this.check(stringBuffer.toString()) == 0) {
                suggestionSet.add(stringBuffer.toString(), wordComparator.compare(string, stringBuffer.toString()));
            }
            stringBuffer.setCharAt(n5 + 1, (char)n6);
            stringBuffer.setCharAt(n5, c2);
        }
        for (n5 = 0; n5 < string2.length(); ++n5) {
            String string5;
            String string6 = "";
            String string7 = "";
            if (n5 > 0) {
                string6 = string2.substring(0, n5);
            }
            if (n5 + 1 < string2.length()) {
                string7 = string2.substring(n5 + 1);
            }
            if (this.check(string5 = string6 + string7) != 0) continue;
            suggestionSet.add(string5, wordComparator.compare(string, string5));
        }
        n5 = 0;
        for (n3 = 0; n3 < string2.length(); ++n3) {
            if (!UniCharacter.isPunctuation(string2.charAt(n3))) continue;
            ++n5;
        }
        if (n5 == 1) {
            for (n3 = 0; n3 < string2.length() && !UniCharacter.isPunctuation(string2.charAt(n3)); ++n3) {
            }
            String string8 = null;
            if (n3 > 0) {
                string8 = string2.substring(0, n3);
            }
            String string9 = null;
            if (n3 < string2.length() - 1) {
                string9 = string2.substring(n3 + 1);
            }
            n4 = this.options;
            this.options |= 0x200;
            if (string8 != null && string9 != null && this.check(string8) == 0 && this.check(string9) == 0) {
                StringBuffer stringBuffer2 = new StringBuffer(string8);
                stringBuffer2.append(string2.charAt(n3));
                stringBuffer2.append(' ');
                stringBuffer2.append(string9);
                suggestionSet.add(stringBuffer2.toString(), wordComparator.compare(string, stringBuffer2.toString()));
            }
            this.options = n4;
        }
        for (n3 = 0; n3 < suggestionSet.size(); ++n3) {
            if (!suggestionSet.getMatchCaseAt(n3)) continue;
            String string10 = suggestionSet.wordAt(n3);
            StringBuffer stringBuffer3 = new StringBuffer(string10);
            this.matchCase(stringBuffer3, false, (this.options & 0x20000) != 0, string);
            SpellingSession.restorePossessives(stringBuffer3, string);
            if (string10.equals(stringBuffer3.toString())) continue;
            suggestionSet.replaceAt(n3, stringBuffer3.toString());
        }
        for (n3 = 0; n3 < suggestionSet.size(); ++n3) {
            for (int i2 = n3 + 1; i2 < suggestionSet.size(); ++i2) {
                if (!suggestionSet.wordAt(n3).equals(suggestionSet.wordAt(i2))) continue;
                suggestionSet.deleteAt(i2);
            }
        }
    }

    public static String version() {
        String string = "$Revision: 5.10.16 $";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    private int actionToResultMask(int n2) {
        switch (n2) {
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 101: {
                return 4096;
            }
        }
        return 0;
    }

    private int checkWord2(String string, StringBuffer stringBuffer) {
        int n2;
        StringBuffer stringBuffer2;
        if (this.lexicons == null) {
            return 16;
        }
        if (this.ignoreWord(string)) {
            return 0;
        }
        int n22 = this.checkWord3(string, string, stringBuffer);
        if (n22 != 0) {
            return this.actionToResultMask(n22);
        }
        if ((this.options & 1) != 0 && string.length() > 0 && UniCharacter.isUpperCase(string.charAt(0))) {
            stringBuffer2 = new StringBuffer(string.length());
            stringBuffer2.append(Character.toLowerCase(string.charAt(0)));
            stringBuffer2.append(string.substring(1));
            n22 = this.checkWord3(stringBuffer2.toString(), string, stringBuffer);
            if (n22 != 0) {
                return this.actionToResultMask(n22);
            }
        }
        if ((this.options & 1) != 0) {
            boolean bl = true;
            int c3 = string.length();
            for (n2 = 0; n2 < c3; ++n2) {
                if (!UniCharacter.isLetter(string.charAt(n2)) || UniCharacter.isUpperCase(string.charAt(n2))) continue;
                bl = false;
                break;
            }
            if (bl) {
                n2 = this.options;
                this.options &= 0xFFFFFFFE;
                n22 = this.checkWord3(string, string, stringBuffer);
                this.options = n2;
                if (n22 != 0) {
                    return this.actionToResultMask(n22);
                }
            }
        }
        if ((this.options & 0x20000) == 0 && UniCharacter.isUpperCase(string.charAt(0))) {
            char c2;
            stringBuffer2 = new StringBuffer(string);
            do {
                n2 = this.options;
                this.options |= 0x20000;
                int n3 = this.checkWord2(stringBuffer2.toString(), stringBuffer);
                this.options = n2;
                if ((n3 & 0x10) != 0) {
                    return n3;
                }
                c2 = UniCharacter.nextAccentFromBase(UniCharacter.toBase(string.charAt(0)), stringBuffer2.charAt(0));
                if (c2 == '\u0000') continue;
                stringBuffer2.setCharAt(0, c2);
            } while (c2 != '\u0000');
        }
        return 16;
    }

    private int checkWord3(String string, String string2, StringBuffer stringBuffer) {
        for (int i2 = 0; i2 < this.lexicons.length; ++i2) {
            if (this.lexicons[i2] == null) continue;
            int n2 = this.lexicons[i2].findWord(string, (this.options & 1) != 0, stringBuffer);
            if (n2 == 0) continue;
            if (n2 == 65 || n2 == 67) {
                this.matchCase(stringBuffer, false, (this.options & 0x20000) != 0, string2);
            }
            return n2;
        }
        return 0;
    }

    protected boolean containsSubWords(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if ((this.options & 0x1000) != 0 && UniCharacter.isHyphen(c2)) {
                return true;
            }
            if ((this.options & 0x800) == 0 || !UniCharacter.isApostrophe(c2)) continue;
            return true;
        }
        return false;
    }

    protected int getSubWord(String string, StringBuffer stringBuffer) {
        int n2 = 0;
        stringBuffer.setLength(0);
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if ((this.options & 0x1000) != 0 && UniCharacter.isHyphen(c2)) {
                ++n2;
                break;
            }
            if ((this.options & 0x800) != 0 && UniCharacter.isApostrophe(c2)) {
                ++n2;
                break;
            }
            stringBuffer.append(c2);
            ++n2;
        }
        return n2;
    }

    protected boolean ignoreWord(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        if ((this.options & 0x20) != 0) {
            n3 = 0;
            for (n2 = 0; n2 < n4 && n3 == 0; ++n2) {
                if (!UniCharacter.isLetter(string.charAt(n2))) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                return true;
            }
        }
        if ((this.options & 4) != 0 && UniCharacter.isUpperCase(string.charAt(0))) {
            return true;
        }
        if ((this.options & 8) != 0 && this.isMixedCase(string)) {
            return true;
        }
        if ((this.options & 0x10) != 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (!UniCharacter.isDigit(string.charAt(n3))) continue;
                return true;
            }
        }
        if ((this.options & 2) != 0) {
            n3 = 1;
            for (n2 = 0; n2 < n4; ++n2) {
                if (UniCharacter.isUpperCase(string.charAt(n2))) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0 && n4 > 1) {
                return true;
            }
        }
        if ((this.options & 0x10000) != 0) {
            int n5;
            int n6;
            n3 = string.lastIndexOf(46);
            if (n3 >= 0) {
                n2 = 1;
                n6 = 0;
                for (n5 = n3 + 1; n5 < n4 && n2 != 0 && n6 <= 4; ++n6, ++n5) {
                    if (UniCharacter.isLetterOrDigit(string.charAt(n5))) continue;
                    n2 = 0;
                }
                if (n2 != 0 && n6 >= 2 && n6 <= 4) {
                    return true;
                }
            }
            if (string.indexOf("://") >= 0) {
                return true;
            }
            n2 = string.indexOf(47);
            if (n2 >= 0) {
                n6 = 1;
                n5 = 0;
                for (int i2 = n2 - 1; i2 >= 0 && string.charAt(i2) != '.' && n6 != 0 && n5 <= 4; ++n5, --i2) {
                    if (UniCharacter.isLetterOrDigit(string.charAt(i2))) continue;
                    n6 = 0;
                }
                if (n6 != 0 && n5 >= 2 && n5 <= 4) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMixedCase(String string) {
        int n2;
        boolean bl = false;
        int n3 = string.length();
        for (n2 = 1; n2 < n3; ++n2) {
            if (!UniCharacter.isLetter(string.charAt(n2))) continue;
            bl = UniCharacter.isLowerCase(string.charAt(n2));
            break;
        }
        if (n2 >= n3) {
            return false;
        }
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (UniCharacter.isLetter(c2) && (bl && UniCharacter.isUpperCase(c2) || !bl && UniCharacter.isLowerCase(c2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void matchCase(StringBuffer stringBuffer, boolean bl, boolean bl2, String string) {
        block10: {
            char c2;
            char c3;
            boolean bl3;
            int n2;
            block11: {
                char c4;
                block9: {
                    n2 = stringBuffer.length();
                    c4 = string.length();
                    if (n2 == 0 || c4 == '\u0000') {
                        return;
                    }
                    if (!bl) break block9;
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        char c5 = stringBuffer.charAt(i2);
                        if (UniCharacter.isUpperCase(string.charAt(n3))) {
                            char c6;
                            c5 = Character.toUpperCase(c5);
                            if (!bl2 && (c6 = UniCharacter.toBase(c5)) != c5) {
                                c5 = c6;
                            }
                            stringBuffer.setCharAt(i2, c5);
                        } else {
                            stringBuffer.setCharAt(i2, Character.toLowerCase(stringBuffer.charAt(i2)));
                        }
                        if (n3 + 1 >= c4) continue;
                        ++n3;
                    }
                    break block10;
                }
                bl3 = true;
                for (c3 = '\u0000'; c3 < c4; ++c3) {
                    c2 = string.charAt(c3);
                    if (!UniCharacter.isLetter(c2) || UniCharacter.isUpperCase(c2)) continue;
                    bl3 = false;
                    break;
                }
                if (bl3 || !UniCharacter.isUpperCase(string.charAt(0))) break block11;
                c3 = stringBuffer.charAt(0);
                stringBuffer.setCharAt(0, Character.toUpperCase(c3));
                if (bl2 || UniCharacter.toBase(c3) == c3) break block10;
                stringBuffer.setCharAt(0, UniCharacter.toBase(c3));
                break block10;
            }
            if (bl3 && string.length() > 1) {
                for (c3 = '\u0000'; c3 < n2; ++c3) {
                    char c7;
                    c2 = Character.toUpperCase(stringBuffer.charAt(c3));
                    if (!bl2 && (c7 = UniCharacter.toBase(c2)) != c2) {
                        c2 = c7;
                    }
                    stringBuffer.setCharAt(c3, c2);
                }
            }
        }
    }

    public static String stripPossessives(String string) {
        int n2 = string.length();
        if (n2 >= 2) {
            char c2 = string.charAt(n2 - 2);
            char c3 = string.charAt(n2 - 1);
            if (UniCharacter.isApostrophe(c2) && Character.toLowerCase(c3) == 's') {
                return string.substring(0, n2 - 2);
            }
            if (Character.toLowerCase(c2) == 's' && UniCharacter.isApostrophe(c3)) {
                return string.substring(0, n2 - 1);
            }
        }
        return string;
    }

    public static void restorePossessives(StringBuffer stringBuffer, String string) {
        char c2 = '\u0000';
        char c3 = '\u0000';
        boolean bl = false;
        char c4 = '\u0000';
        char c5 = '\u0000';
        if (string.length() >= 2) {
            c4 = string.charAt(string.length() - 2);
            c5 = string.charAt(string.length() - 1);
        }
        if (UniCharacter.isApostrophe(c4) && Character.toLowerCase(c5) == 's') {
            bl = true;
            c2 = c5;
            c3 = c4;
        } else if (Character.toLowerCase(c4) == 's' && UniCharacter.isApostrophe(c5)) {
            bl = true;
            c2 = c4;
            c3 = c5;
        }
        if (bl) {
            if (stringBuffer.length() > 0 && Character.toLowerCase(stringBuffer.charAt(stringBuffer.length() - 1)) == 's') {
                stringBuffer.append(c3);
            } else {
                stringBuffer.append(c3);
                stringBuffer.append(c2);
            }
        }
    }
}

