/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.CompressedLexicon;
import com.wintertree.ssce.EnglishPhoneticComparator;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.MemTextLexicon;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.StreamTextLexicon;
import com.wintertree.ssce.TypographicalComparator;
import com.wintertree.ssce.WordComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropSpellingSession
extends SpellingSession
implements Cloneable {
    protected URL codeBase;
    public WordComparator comparator;
    protected String mainLexPath = null;
    public int minSuggestDepth;
    protected Properties properties;
    protected String propertyPrefix = "";
    protected int tempLexiconX;
    public FileTextLexicon[] userLexicons;
    protected String userLexPath = null;

    public PropSpellingSession(Properties properties, URL uRL, String string, String string2, String string3) {
        Lexicon lexicon;
        String string4;
        String string5;
        String string6;
        StringTokenizer stringTokenizer;
        String string7;
        int n2;
        this.properties = properties;
        this.codeBase = uRL;
        this.propertyPrefix = string;
        this.mainLexPath = string2;
        this.userLexPath = string3;
        Vector<Lexicon> vector = new Vector<Lexicon>();
        MemTextLexicon memTextLexicon = new MemTextLexicon();
        vector.addElement(memTextLexicon);
        this.tempLexiconX = 0;
        String string8 = "";
        if (string != null) {
            string8 = string;
        }
        Vector<Lexicon> vector2 = new Vector<Lexicon>();
        for (n2 = 1; n2 < 99 && null != (string7 = properties.getProperty(string8 + "UserLexicon" + n2)); ++n2) {
            stringTokenizer = new StringTokenizer(string7, ",");
            string6 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
            }
            string5 = "file";
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
            string4 = "T";
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if ((lexicon = this.openLex(string6, string5, string4, string3)) == null) continue;
            vector.addElement(lexicon);
            if (!(lexicon instanceof FileTextLexicon)) continue;
            vector2.addElement(lexicon);
        }
        this.userLexicons = null;
        if (!vector2.isEmpty()) {
            this.userLexicons = new FileTextLexicon[vector2.size()];
            vector2.copyInto(this.userLexicons);
        }
        for (n2 = 1; n2 < 99 && null != (string7 = properties.getProperty(string8 + "MainLexicon" + n2)); ++n2) {
            stringTokenizer = new StringTokenizer(string7, ",");
            string6 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
            }
            string5 = "file";
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
            string4 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if ((lexicon = this.openLex(string6, string5, string4, string2)) == null) continue;
            vector.addElement(lexicon);
        }
        Object[] objectArray = new Lexicon[vector.size()];
        vector.copyInto(objectArray);
        this.setLexicons((Lexicon[])objectArray);
        string7 = properties.getProperty(string8 + "CASE_SENSITIVE_OPT");
        if (string7 != null) {
            this.setOption(1, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "IGNORE_ALL_CAPS_WORD_OPT")) != null) {
            this.setOption(2, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "IGNORE_CAPPED_WORD_OPT")) != null) {
            this.setOption(4, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "IGNORE_MIXED_CASE_OPT")) != null) {
            this.setOption(8, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "IGNORE_MIXED_DIGITS_OPT")) != null) {
            this.setOption(16, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "IGNORE_NON_ALPHA_WORD_OPT")) != null) {
            this.setOption(32, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "REPORT_DOUBLED_WORD_OPT")) != null) {
            this.setOption(64, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "REPORT_MIXED_CASE_OPT")) != null) {
            this.setOption(128, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "REPORT_MIXED_DIGITS_OPT")) != null) {
            this.setOption(256, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "REPORT_UNCAPPED_OPT")) != null) {
            this.setOption(1024, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "SPLIT_CONTRACTED_WORDS_OPT")) != null) {
            this.setOption(2048, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "SPLIT_HYPHENATED_WORDS_OPT")) != null) {
            this.setOption(4096, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "SPLIT_WORDS_OPT")) != null) {
            this.setOption(8192, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "STRIP_POSSESSIVES_OPT")) != null) {
            this.setOption(16384, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "SUGGEST_SPLIT_WORDS_OPT")) != null) {
            this.setOption(32768, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "IGNORE_DOMAIN_NAMES_OPT")) != null) {
            this.setOption(65536, Boolean.valueOf(string7));
        }
        if ((string7 = properties.getProperty(string8 + "ALLOW_ACCENTED_CAPS_OPT")) != null) {
            this.setOption(131072, Boolean.valueOf(string7));
        }
        this.minSuggestDepth = 50;
        string7 = properties.getProperty(string8 + "MinSuggestDepth");
        if (string7 != null) {
            this.minSuggestDepth = Integer.valueOf(string7);
        }
        this.comparator = (string7 = properties.getProperty(string8 + "Suggestions")) != null && string7.equalsIgnoreCase("Phonetic") ? new EnglishPhoneticComparator() : new TypographicalComparator();
    }

    public PropSpellingSession(Properties properties) {
        this(properties, null, null, null, null);
    }

    public PropSpellingSession(Properties properties, URL uRL) {
        this(properties, uRL, null, null, null);
    }

    public Object clone() {
        PropSpellingSession propSpellingSession = (PropSpellingSession)super.clone();
        propSpellingSession.codeBase = this.codeBase;
        propSpellingSession.comparator = this.comparator;
        propSpellingSession.mainLexPath = this.mainLexPath;
        propSpellingSession.minSuggestDepth = this.minSuggestDepth;
        propSpellingSession.tempLexiconX = this.tempLexiconX;
        propSpellingSession.properties = this.properties != null ? new Properties(this.properties) : null;
        propSpellingSession.propertyPrefix = this.propertyPrefix;
        if (this.userLexicons != null) {
            propSpellingSession.userLexicons = new FileTextLexicon[this.userLexicons.length];
            System.arraycopy(this.userLexicons, 0, propSpellingSession.userLexicons, 0, propSpellingSession.userLexicons.length);
        } else {
            propSpellingSession.userLexicons = null;
        }
        propSpellingSession.userLexPath = this.userLexPath;
        return propSpellingSession;
    }

    public WordComparator getComparator() {
        return this.comparator;
    }

    public int getMinSuggestDepth() {
        return this.minSuggestDepth;
    }

    public Properties getProperties() {
        ((Hashtable)this.properties).put("CASE_SENSITIVE_OPT", String.valueOf(this.getOption(1)));
        ((Hashtable)this.properties).put("IGNORE_ALL_CAPS_WORD_OPT", String.valueOf(this.getOption(2)));
        ((Hashtable)this.properties).put("IGNORE_CAPPED_WORD_OPT", String.valueOf(this.getOption(4)));
        ((Hashtable)this.properties).put("IGNORE_MIXED_CASE_OPT", String.valueOf(this.getOption(8)));
        ((Hashtable)this.properties).put("IGNORE_MIXED_DIGITS_OPT", String.valueOf(this.getOption(16)));
        ((Hashtable)this.properties).put("IGNORE_NON_ALPHA_WORD_OPT", String.valueOf(this.getOption(32)));
        ((Hashtable)this.properties).put("REPORT_DOUBLED_WORD_OPT", String.valueOf(this.getOption(64)));
        ((Hashtable)this.properties).put("REPORT_MIXED_CASE_OPT", String.valueOf(this.getOption(128)));
        ((Hashtable)this.properties).put("REPORT_MIXED_DIGITS_OPT", String.valueOf(this.getOption(256)));
        ((Hashtable)this.properties).put("REPORT_UNCAPPED_OPT", String.valueOf(this.getOption(1024)));
        ((Hashtable)this.properties).put("SPLIT_CONTRACTED_WORDS_OPT", String.valueOf(this.getOption(2048)));
        ((Hashtable)this.properties).put("SPLIT_HYPHENATED_WORDS_OPT", String.valueOf(this.getOption(4096)));
        ((Hashtable)this.properties).put("SPLIT_WORDS_OPT", String.valueOf(this.getOption(8192)));
        ((Hashtable)this.properties).put("STRIP_POSSESSIVES_OPT", String.valueOf(this.getOption(16384)));
        ((Hashtable)this.properties).put("SUGGEST_SPLIT_WORDS_OPT", String.valueOf(this.getOption(32768)));
        ((Hashtable)this.properties).put("IGNORE_DOMAIN_NAMES_OPT", String.valueOf(this.getOption(65536)));
        ((Hashtable)this.properties).put("ALLOW_ACCENTED_CAPS_OPT", String.valueOf(this.getOption(131072)));
        ((Hashtable)this.properties).put("MinSuggestDepth", String.valueOf(this.minSuggestDepth));
        if (this.comparator instanceof EnglishPhoneticComparator) {
            ((Hashtable)this.properties).put("Comparator", "Phonetic");
        } else {
            ((Hashtable)this.properties).put("Comparator", "Typographical");
        }
        return this.properties;
    }

    public MemTextLexicon getTempLexicon() {
        Lexicon[] lexiconArray = this.getLexicons();
        return (MemTextLexicon)lexiconArray[this.tempLexiconX];
    }

    public FileTextLexicon[] getUserLexicons() {
        return this.userLexicons;
    }

    public void setComparator(WordComparator wordComparator) {
        this.comparator = wordComparator;
    }

    public void setLexicons(Lexicon[] lexiconArray) {
        Lexicon[] lexiconArray2 = new Lexicon[lexiconArray.length + 1];
        for (int i2 = 0; i2 < lexiconArray.length; ++i2) {
            lexiconArray2[i2] = lexiconArray[i2];
        }
        this.tempLexiconX = lexiconArray.length;
        lexiconArray2[this.tempLexiconX] = new MemTextLexicon();
        super.setLexicons(lexiconArray2);
    }

    public void setMinSuggestDepth(int n2) {
        this.minSuggestDepth = n2;
    }

    public MemTextLexicon setTempLexicon(MemTextLexicon memTextLexicon) {
        Lexicon[] lexiconArray = this.getLexicons();
        MemTextLexicon memTextLexicon2 = (MemTextLexicon)lexiconArray[this.tempLexiconX];
        lexiconArray[this.tempLexiconX] = memTextLexicon;
        return memTextLexicon2;
    }

    protected Lexicon openLex(String string, String string2, String string3, String string4) {
        Lexicon lexicon;
        block17: {
            lexicon = null;
            try {
                if (string2.equalsIgnoreCase("file")) {
                    if (string4 != null && string.indexOf(File.separator) < 0) {
                        if (!string4.endsWith(File.separator)) {
                            string4 = string4 + File.separator;
                        }
                        string = string4 + string;
                    }
                    if (string3 == null) {
                        string3 = CompressedLexicon.isCompressedLexicon(string) ? "c" : "t";
                    }
                    lexicon = string3.equalsIgnoreCase("c") ? new CompressedLexicon(string, 0) : new FileTextLexicon(string);
                } else if (string2.equalsIgnoreCase("resource")) {
                    InputStream inputStream = this.getClass().getResourceAsStream(string);
                    if (null == inputStream) {
                        throw new Exception();
                    }
                    lexicon = string3.equalsIgnoreCase("t") ? new StreamTextLexicon(inputStream) : new CompressedLexicon(inputStream);
                } else if (string2.equalsIgnoreCase("url")) {
                    URL uRL = this.codeBase == null ? new URL(string) : new URL(this.codeBase + string);
                    InputStream inputStream = uRL.openStream();
                    if (null == inputStream) {
                        throw new Exception();
                    }
                    lexicon = string3.equalsIgnoreCase("t") ? new StreamTextLexicon(inputStream) : new CompressedLexicon(inputStream);
                } else if (string2.equalsIgnoreCase("stream")) {
                    FileInputStream fileInputStream;
                    if (string4 != null && string.indexOf(File.separator) < 0) {
                        if (!string4.endsWith(File.separator)) {
                            string4 = string4 + File.separator;
                        }
                        string = string4 + string;
                    }
                    if ((fileInputStream = new FileInputStream(string)) == null) {
                        throw new Exception();
                    }
                    lexicon = string3.equalsIgnoreCase("c") ? new CompressedLexicon(fileInputStream) : new StreamTextLexicon(fileInputStream);
                }
            }
            catch (Exception exception) {
                System.err.println("Can't open " + string + "(" + string2 + "," + string3 + "):");
                if (exception.getMessage() == null) break block17;
                System.err.println("  " + exception);
            }
        }
        return lexicon;
    }
}

