/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.EditableLexicon;
import com.wintertree.ssce.LexiconUpdateException;
import com.wintertree.ssce.ParameterException;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.WordComparator;
import com.wintertree.ssce.WordException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MemTextLexicon
implements EditableLexicon {
    protected int language;
    Hashtable theWords;

    public MemTextLexicon() {
        this(30840);
    }

    public MemTextLexicon(int n2) {
        this.language = n2;
        this.theWords = new Hashtable();
    }

    public void addWord(String string) throws LexiconUpdateException {
        try {
            this.addWord(string, 105, "");
        }
        catch (Exception exception) {
            throw new LexiconUpdateException(string);
        }
    }

    public void addWord(String string, int n2) throws ParameterException, LexiconUpdateException {
        if (n2 != 101 && n2 != 105) {
            throw new ParameterException(n2 + " action requires other word");
        }
        this.addWord(string, n2, "");
    }

    public void addWord(String string, int n2, String string2) throws ParameterException, LexiconUpdateException {
        if (n2 != 97 && n2 != 65 && n2 != 99 && n2 != 67 && n2 != 101 && n2 != 105) {
            throw new ParameterException("Action unrecognized: " + n2);
        }
        this.theWords.put(string, (char)n2 + string2);
    }

    public void clear() {
        this.theWords.clear();
    }

    public boolean equals(Object object) {
        MemTextLexicon memTextLexicon = (MemTextLexicon)object;
        if (this.theWords.size() != memTextLexicon.theWords.size()) {
            return false;
        }
        Enumeration enumeration = this.theWords.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.theWords.get(string);
            String string3 = (String)memTextLexicon.theWords.get(string);
            if (string2 == null && string3 != null || string2 != null && string3 == null) {
                return false;
            }
            if (string2 == null || string2.equals(string3)) continue;
            return false;
        }
        return true;
    }

    public int findWord(String string, boolean bl, StringBuffer stringBuffer) {
        if (bl) {
            if (this.theWords.containsKey(string)) {
                String string2 = (String)this.theWords.get(string);
                stringBuffer.setLength(0);
                stringBuffer.append(string2.substring(1));
                return string2.charAt(0);
            }
        } else {
            Enumeration enumeration = this.theWords.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.equalsIgnoreCase(string)) continue;
                String string4 = (String)this.theWords.get(string3);
                stringBuffer.setLength(0);
                stringBuffer.append(string4.substring(1));
                return string4.charAt(0);
            }
        }
        return 0;
    }

    public void deleteWord(String string) throws WordException, LexiconUpdateException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.findWord(string, true, stringBuffer) == 0) {
            throw new WordException(string + " not found");
        }
        this.theWords.remove(string);
    }

    public int size() {
        return this.theWords.size();
    }

    public void suggest(String string, int n2, WordComparator wordComparator, SuggestionSet suggestionSet) {
        Enumeration enumeration = this.words();
        block6: while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.theWords.get(string2);
            char c2 = string3.charAt(0);
            switch (c2) {
                case 'a': 
                case 'c': {
                    if (!string.equals(string2)) break;
                    suggestionSet.add(string3.substring(1), 100 - 1, false);
                    break;
                }
                case 'A': 
                case 'C': {
                    if (!string.equals(string2)) break;
                    suggestionSet.add(string3.substring(1), 100 - 1, true);
                    break;
                }
                case 'e': {
                    int n3;
                    for (n3 = 0; n3 < suggestionSet.size(); ++n3) {
                        if (!suggestionSet.wordAt(n3).equals(string2)) continue;
                        suggestionSet.deleteAt(n3);
                    }
                    continue block6;
                }
                case 'i': {
                    int n3 = wordComparator.compare(string, string2);
                    suggestionSet.add(string2, n3, true);
                }
            }
        }
    }

    public int getLanguage() {
        return this.language;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + '(');
        Enumeration enumeration = this.theWords.keys();
        for (int i2 = 0; i2 < 3 && enumeration.hasMoreElements(); ++i2) {
            stringBuffer.append((String)enumeration.nextElement());
            stringBuffer.append(", ");
        }
        stringBuffer.append("...)");
        return stringBuffer.toString();
    }

    public Enumeration words() {
        return this.theWords.keys();
    }
}

