/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.FileExistsException;
import com.wintertree.ssce.FileFormatException;
import com.wintertree.ssce.LexiconUpdateException;
import com.wintertree.ssce.ParameterException;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.StreamTextLexicon;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

public class FileTextLexicon
extends StreamTextLexicon {
    protected String fileName;
    protected long lastModified;

    public FileTextLexicon(String string) throws IOException, FileFormatException, LexiconUpdateException {
        this.lastModified = 0L;
        this.open(string);
    }

    public FileTextLexicon(String string, int n2) throws IOException, FileExistsException {
        super(n2);
        File file = new File(string);
        if (file.canRead()) {
            throw new FileExistsException(string);
        }
        this.fileName = string;
        this.save();
    }

    public void addWord(String string) throws LexiconUpdateException {
        try {
            this.addWord(string, 105, "");
        }
        catch (ParameterException parameterException) {
            throw new LexiconUpdateException(parameterException.toString());
        }
    }

    public void addWord(String string, int n2) throws LexiconUpdateException, ParameterException {
        if (n2 != 101 && n2 != 105) {
            throw new ParameterException(n2 + " action requires other word");
        }
        if (this.external && n2 != 105) {
            throw new LexiconUpdateException("Action " + n2 + " can't be used with external-format text lexicons");
        }
        this.addWord(string, n2, "");
    }

    public void addWord(String string, int n2, String string2) throws LexiconUpdateException, ParameterException {
        try {
            this.syncFile();
        }
        catch (Exception exception) {
            throw new LexiconUpdateException(exception.toString());
        }
        super.addWord(string, n2, string2);
        try {
            this.save();
        }
        catch (IOException iOException) {
            try {
                super.deleteWord(string);
            }
            catch (WordException wordException) {
                // empty catch block
            }
            throw new LexiconUpdateException(iOException.toString());
        }
    }

    public void deleteWord(String string) throws LexiconUpdateException, WordException {
        try {
            this.syncFile();
        }
        catch (Exception exception) {
            throw new LexiconUpdateException(exception.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.findWord(string, true, stringBuffer);
        super.deleteWord(string);
        try {
            this.save();
        }
        catch (IOException iOException) {
            try {
                super.addWord(string, n2, stringBuffer.toString());
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            throw new LexiconUpdateException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        FileTextLexicon fileTextLexicon = (FileTextLexicon)object;
        return this.fileName.equals(fileTextLexicon.fileName) && super.equals(object);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public static boolean isFileTextLexicon(String string) {
        try {
            FileTextLexicon fileTextLexicon = new FileTextLexicon(string);
            fileTextLexicon = null;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void save() throws IOException {
        try {
            if (this.fileName == null) {
                throw new UnsupportedException();
            }
            try {
                int n2 = -1479411111;
                int n3 = 139;
                int n4 = 140;
                int n5 = 647;
                int n6 = 1999;
                int n7 = 151;
                int n8 = 499;
                int n9 = SpellingSession.getOption(new Integer(32));
                if ((n9 & 0xF3) == 162) {
                    int n10 = (n9 & 0x1F00) >> 8;
                    int n11 = (n9 & 0x1FFE000) >> 13;
                    int n12 = (n9 & 0xC) >> 2;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000 + n12 * 10, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n11 * 86400000L);
                    long l2 = System.currentTimeMillis();
                    long l3 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n13 = n9 & 0x7FFFE000;
                    int n14 = 0;
                    for (int i2 = 0; i2 < 32; ++i2) {
                        n14 += n13 & 1;
                        n13 >>= 1;
                    }
                    if (n14 != n10) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l2 > l3 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                for (int i4 = 0; i4 < stringArray[i3].length(); ++i4) {
                                    System.out.print((char)(stringArray[i3].charAt(i4) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l2 / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l2 > l3 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i5 = 0; i5 < stringArray.length; ++i5) {
                            for (int i6 = 0; i6 < stringArray[i5].length(); ++i6) {
                                System.out.print((char)(stringArray[i5].charAt(i6) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l2 / 1000L)));
                    }
                } else {
                    int n15;
                    long l4 = n9 ^ n2;
                    long l5 = 0L;
                    for (n15 = 0; n15 < 32; ++n15) {
                        long l6 = l4 >> n15 & 1L;
                        l5 |= l6 << 31 - n15;
                    }
                    n15 = (int)(l5 / 10000L);
                    if (n15 != n3 && n15 != n4) {
                        throw new Exception();
                    }
                    int n16 = (int)(l5 % 10000L);
                    if (n15 == n3 && n16 < n5 || n16 > n6) {
                        throw new Exception();
                    }
                    if (n15 == n4 && (n16 < n7 || n16 > n8)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l7 = System.currentTimeMillis();
                while (System.currentTimeMillis() < l7 + 1000L) {
                }
                throw new UnsupportedException();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
            super.save(fileOutputStream);
            fileOutputStream.close();
            File file = new File(this.fileName);
            this.lastModified = file.lastModified();
        }
        catch (UnsupportedException unsupportedException) {
            // empty catch block
        }
    }

    protected void open(String string) throws IOException, FileFormatException, LexiconUpdateException {
        this.fileName = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fileName + ')';
    }

    protected void syncFile() throws IOException, FileFormatException, LexiconUpdateException {
        File file = new File(this.fileName);
        long l2 = file.lastModified();
        if (l2 > this.lastModified) {
            FileInputStream fileInputStream = new FileInputStream(this.fileName);
            this.load(fileInputStream);
            this.lastModified = l2;
            fileInputStream.close();
        }
    }
}

