/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.CLexSegment;
import com.wintertree.ssce.ContainsWordCatcher;
import com.wintertree.ssce.FileFormatException;
import com.wintertree.ssce.LexCompressor;
import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.ParameterException;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.SuggestWordCatcher;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordCatcher;
import com.wintertree.ssce.WordComparator;
import com.wintertree.util.CharArray;
import com.wintertree.util.Comparable;
import com.wintertree.util.Search;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class CompressedLexicon
implements Lexicon {
    private int accesses;
    private int charSet;
    private String[] extSuffixes;
    private String fileName;
    private int language;
    private int memoryAvailable;
    private int memoryBudget;
    private long segDataOffset;
    private CLexSegment[] segIndex;
    private String[] simpleSuffixes;

    public CompressedLexicon(String string) throws IOException, FileFormatException, ParameterException, UnsupportedException {
        this(string, 0);
    }

    public CompressedLexicon(String string, int n2) throws IOException, FileFormatException, ParameterException, UnsupportedException {
        this.open(string, n2);
    }

    public CompressedLexicon(InputStream inputStream) throws FileFormatException, IOException, UnsupportedException {
        this.fileName = inputStream.toString();
        this.open(new DataInputStream(inputStream));
    }

    public boolean equals(Object object) {
        return this.fileName.equals(((CompressedLexicon)object).toString());
    }

    public int findWord(String string, boolean bl, StringBuffer stringBuffer) {
        ContainsWordCatcher containsWordCatcher = new ContainsWordCatcher(string, bl);
        CLexSegment cLexSegment = new CLexSegment();
        LexCompressor.toSegId(string, cLexSegment.id);
        if (string.length() < 3) {
            if (bl) {
                int n2 = Search.binary(this.segIndex, (Comparable)cLexSegment);
                return n2 >= 0 ? 105 : 0;
            }
            for (int i2 = 0; i2 < 8; ++i2) {
                for (int i3 = 0; i3 < cLexSegment.id.length; ++i3) {
                    cLexSegment.id[i3] = (i2 & 1 << i3) != 0 ? Character.toUpperCase(cLexSegment.id[i3]) : Character.toLowerCase(cLexSegment.id[i3]);
                }
                int n3 = Search.binary(this.segIndex, (Comparable)cLexSegment);
                if (n3 < 0) continue;
                return 105;
            }
            return 0;
        }
        if (bl) {
            int n4 = Search.binary(this.segIndex, (Comparable)cLexSegment);
            if (n4 < 0) {
                return 0;
            }
            try {
                this.loadSegment(n4);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.toString());
                return 0;
            }
            this.scanSegment(this.segIndex[n4], this.charSet, containsWordCatcher, this.simpleSuffixes, this.extSuffixes);
            return containsWordCatcher.IsFound() ? 105 : 0;
        }
        for (int i4 = 0; i4 < 8; ++i4) {
            for (int i5 = 0; i5 < cLexSegment.id.length; ++i5) {
                cLexSegment.id[i5] = (i4 & 1 << i5) != 0 ? Character.toUpperCase(cLexSegment.id[i5]) : Character.toLowerCase(cLexSegment.id[i5]);
            }
            int n5 = Search.binary(this.segIndex, (Comparable)cLexSegment);
            if (n5 < 0) continue;
            try {
                this.loadSegment(n5);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.toString());
                return 0;
            }
            this.scanSegment(this.segIndex[n5], this.charSet, containsWordCatcher, this.simpleSuffixes, this.extSuffixes);
            if (!containsWordCatcher.IsFound()) continue;
            return 105;
        }
        return 0;
    }

    public int getLanguage() {
        return this.language;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public static boolean isCompressedLexicon(String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            int n2 = randomAccessFile.readInt();
            randomAccessFile.close();
            return n2 == 1459619073;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void suggest(String string, int n2, WordComparator wordComparator, SuggestionSet suggestionSet) {
        int n3 = 100 - n2;
        n3 = Math.max(n3, 0);
        for (int i2 = 0; i2 < this.segIndex.length; ++i2) {
            int n4;
            String string2;
            CLexSegment cLexSegment = this.segIndex[i2];
            if (CharArray.length(cLexSegment.id) < 3) {
                string2 = CharArray.toString(cLexSegment.id);
                n4 = wordComparator.compare(string, string2);
                suggestionSet.add(string2, n4);
                continue;
            }
            n4 = Math.min(3, string.length());
            String string3 = string.substring(0, n4);
            int n5 = wordComparator.compare(string3, string2 = CharArray.toString(cLexSegment.id));
            if (n5 < n3) continue;
            try {
                this.loadSegment(i2);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.toString());
                continue;
            }
            SuggestWordCatcher suggestWordCatcher = new SuggestWordCatcher(string, wordComparator, suggestionSet);
            this.scanSegment(this.segIndex[i2], this.charSet, suggestWordCatcher, this.simpleSuffixes, this.extSuffixes);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fileName + ')';
    }

    protected void open(String string, int n2) throws IOException, FileFormatException, ParameterException, UnsupportedException {
        int n3;
        int n4;
        this.fileName = new String(string);
        this.memoryBudget = n2;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        try {
            n4 = randomAccessFile.readInt();
            if (n4 != 1459619073) {
                randomAccessFile.close();
                throw new FileFormatException(string + ": expected magic number " + 1459619073 + "; read " + n4);
            }
        }
        catch (EOFException eOFException) {
            randomAccessFile.close();
            throw new FileFormatException(string + "No magic");
        }
        n4 = 0;
        block13: while (n4 == 0) {
            int n5;
            try {
                n3 = randomAccessFile.readInt();
            }
            catch (EOFException eOFException) {
                n4 = 1;
                continue;
            }
            try {
                n5 = randomAccessFile.readInt();
            }
            catch (EOFException eOFException) {
                randomAccessFile.close();
                throw new FileFormatException(string + " Unexpected EOF at " + randomAccessFile.getFilePointer());
            }
            switch (n3) {
                case 3: {
                    byte[] byArray = new byte[n5];
                    randomAccessFile.readFully(byArray);
                    Vector vector = new Vector();
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.simpleSuffixes = new String[vector.size()];
                    vector.copyInto(this.simpleSuffixes);
                    vector.removeAllElements();
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.extSuffixes = new String[vector.size()];
                    vector.copyInto(this.extSuffixes);
                    continue block13;
                }
                case 4: {
                    byte[] byArray = new byte[n5];
                    randomAccessFile.readFully(byArray);
                    this.loadSegIndexTbl(new DataInputStream(new ByteArrayInputStream(byArray)));
                    continue block13;
                }
                case 1: {
                    this.language = randomAccessFile.readInt();
                    continue block13;
                }
                case 2: {
                    this.charSet = randomAccessFile.readInt();
                    continue block13;
                }
                case 5: {
                    this.segDataOffset = randomAccessFile.getFilePointer();
                    randomAccessFile.skipBytes(n5);
                    continue block13;
                }
            }
            randomAccessFile.skipBytes(n5);
        }
        this.memoryAvailable = this.memoryBudget;
        this.accesses = 0;
        if (this.memoryBudget > 0) {
            for (n3 = 0; n3 < this.segIndex.length; ++n3) {
                if (this.memoryBudget <= 0 || this.segIndex[n3].size <= this.memoryBudget) continue;
                randomAccessFile.close();
                throw new ParameterException("Memory budget " + Integer.toString(this.memoryBudget) + " too small for lexicon " + string + "; should be at least " + Integer.toString(this.segIndex[n3].size));
            }
        }
        randomAccessFile.close();
    }

    protected void open(DataInputStream dataInputStream) throws IOException, FileFormatException, UnsupportedException {
        int n2;
        try {
            int n3 = dataInputStream.readInt();
            if (n3 != 1459619073) {
                throw new FileFormatException("expected magic number 1459619073; read " + n3);
            }
        }
        catch (EOFException eOFException) {
            throw new FileFormatException("No magic");
        }
        byte[] byArray = null;
        boolean bl = false;
        block13: while (!bl) {
            int n4;
            try {
                n2 = dataInputStream.readInt();
            }
            catch (EOFException eOFException) {
                bl = true;
                continue;
            }
            try {
                n4 = dataInputStream.readInt();
            }
            catch (EOFException eOFException) {
                bl = true;
                throw new FileFormatException("Unexpected EOF");
            }
            switch (n2) {
                case 3: {
                    Vector vector = new Vector();
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.simpleSuffixes = new String[vector.size()];
                    vector.copyInto(this.simpleSuffixes);
                    vector.removeAllElements();
                    this.loadSuffixTbl(dataInputStream, vector);
                    this.extSuffixes = new String[vector.size()];
                    vector.copyInto(this.extSuffixes);
                    continue block13;
                }
                case 4: {
                    this.loadSegIndexTbl(dataInputStream);
                    continue block13;
                }
                case 1: {
                    this.language = dataInputStream.readInt();
                    continue block13;
                }
                case 2: {
                    this.charSet = dataInputStream.readInt();
                    continue block13;
                }
                case 5: {
                    if (byArray != null) {
                        throw new FileFormatException("Duplicate segment data section");
                    }
                    byArray = new byte[n4];
                    dataInputStream.readFully(byArray);
                    continue block13;
                }
            }
            dataInputStream.skip(n4);
        }
        if (null == byArray || null == this.segIndex) {
            throw new FileFormatException("Missing data or index section");
        }
        for (n2 = 0; n2 < this.segIndex.length; ++n2) {
            this.segIndex[n2].data = new byte[this.segIndex[n2].size];
            System.arraycopy(byArray, this.segIndex[n2].offset, this.segIndex[n2].data, 0, this.segIndex[n2].data.length);
        }
    }

    private void loadSegIndexTbl(DataInputStream dataInputStream) throws EOFException, IOException, FileFormatException {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            if (dataInputStream == null) {
                throw new UnsupportedException();
            }
            try {
                n5 = -1479411111;
                n4 = 139;
                int n6 = 140;
                n3 = 647;
                n2 = 1999;
                int n7 = 151;
                int n8 = 499;
                int n9 = SpellingSession.getOption(new Integer(32));
                if ((n9 & 0xF3) == 162) {
                    int n10 = (n9 & 0x1F00) >> 8;
                    int n11 = (n9 & 0x1FFE000) >> 13;
                    int n12 = (n9 & 0xC) >> 2;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000 + n12 * 10, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n11 * 86400000L);
                    long l2 = System.currentTimeMillis();
                    long l3 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n13 = n9 & 0x7FFFE000;
                    int n14 = 0;
                    for (int i2 = 0; i2 < 32; ++i2) {
                        n14 += n13 & 1;
                        n13 >>= 1;
                    }
                    if (n14 != n10) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l2 > l3 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                for (int i4 = 0; i4 < stringArray[i3].length(); ++i4) {
                                    System.out.print((char)(stringArray[i3].charAt(i4) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l2 / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l2 > l3 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i5 = 0; i5 < stringArray.length; ++i5) {
                            for (int i6 = 0; i6 < stringArray[i5].length(); ++i6) {
                                System.out.print((char)(stringArray[i5].charAt(i6) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l2 / 1000L)));
                    }
                } else {
                    int n15;
                    long l4 = n9 ^ n5;
                    long l5 = 0L;
                    for (n15 = 0; n15 < 32; ++n15) {
                        long l6 = l4 >> n15 & 1L;
                        l5 |= l6 << 31 - n15;
                    }
                    n15 = (int)(l5 / 10000L);
                    if (n15 != n4 && n15 != n6) {
                        throw new Exception();
                    }
                    int n16 = (int)(l5 % 10000L);
                    if (n15 == n4 && n16 < n3 || n16 > n2) {
                        throw new Exception();
                    }
                    if (n15 == n6 && (n16 < n7 || n16 > n8)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l7 = System.currentTimeMillis();
                while (System.currentTimeMillis() < l7 + 1000L) {
                }
                throw new UnsupportedException();
            }
            n5 = dataInputStream.readInt();
            this.segIndex = new CLexSegment[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                CLexSegment cLexSegment = new CLexSegment();
                for (n3 = 0; n3 < 3; ++n3) {
                    n2 = this.charSet == 1 ? (int)((char)(dataInputStream.readByte() & 0xFF)) : (int)dataInputStream.readChar();
                    cLexSegment.id[n3] = n2;
                }
                cLexSegment.id[n3] = '\u0000';
                cLexSegment.offset = dataInputStream.readInt();
                cLexSegment.data = null;
                cLexSegment.size = dataInputStream.readInt();
                cLexSegment.lastUsed = 0;
                this.segIndex[n4] = cLexSegment;
            }
        }
        catch (UnsupportedException unsupportedException) {
            this.segIndex = new CLexSegment[0];
        }
    }

    private void loadSegment(int n2) throws IOException, FileFormatException {
        Object object;
        ++this.accesses;
        CLexSegment cLexSegment = this.segIndex[n2];
        if (cLexSegment.data != null) {
            cLexSegment.lastUsed = this.accesses;
            return;
        }
        if (cLexSegment.size == 0) {
            return;
        }
        while (this.memoryBudget > 0 && this.memoryAvailable < cLexSegment.size) {
            object = null;
            for (int i2 = 0; i2 < this.segIndex.length; ++i2) {
                CLexSegment cLexSegment2 = this.segIndex[i2];
                if (cLexSegment2.data == null || object != null && cLexSegment2.lastUsed >= ((CLexSegment)object).lastUsed) continue;
                object = cLexSegment2;
            }
            ((CLexSegment)object).data = null;
            this.memoryAvailable += ((CLexSegment)object).size;
        }
        cLexSegment.data = new byte[cLexSegment.size];
        object = new RandomAccessFile(this.fileName, "r");
        ((RandomAccessFile)object).seek(this.segDataOffset + (long)cLexSegment.offset);
        if (((RandomAccessFile)object).read(cLexSegment.data) != cLexSegment.data.length) {
            ((RandomAccessFile)object).close();
            throw new FileFormatException(this.fileName + ": Unexpected EOF");
        }
        ((RandomAccessFile)object).close();
        cLexSegment.lastUsed = this.accesses;
        if (this.memoryBudget > 0) {
            this.memoryAvailable -= cLexSegment.size;
        }
    }

    private void loadSuffixTbl(DataInputStream dataInputStream, Vector vector) throws IOException, EOFException, FileFormatException {
        int n2 = dataInputStream.readInt();
        int n3 = this.charSet == 1 ? n2 : n2 / 2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = this.charSet == 1 ? (char)(dataInputStream.readByte() & 0xFF) : dataInputStream.readChar();
            if (c2 == '\u0000') {
                vector.addElement(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c2);
        }
    }

    void scanSegment(CLexSegment cLexSegment, int n2, WordCatcher wordCatcher, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer(CharArray.toString(cLexSegment.id));
        int n3 = 0;
        int n4 = cLexSegment.data.length;
        while (n3 < n4) {
            boolean bl = false;
            stringBuffer.setLength(3 + cLexSegment.data[n3++]);
            while (!bl) {
                char c2;
                if (n2 == 1) {
                    c2 = (char)(cLexSegment.data[n3++] & 0xFF);
                } else {
                    c2 = (char)((cLexSegment.data[n3++] & 0xFF) << 8);
                    c2 = (char)(c2 | (char)(cLexSegment.data[n3++] & 0xFF));
                }
                if (c2 >= ' ') {
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 >= '\u0002' && c2 < ' ') {
                    stringBuffer.append(stringArray[c2 - 2]);
                    bl = true;
                    continue;
                }
                if (c2 == '\u0000') {
                    bl = true;
                    continue;
                }
                if (c2 != '\u0001') continue;
                if (n2 == 1) {
                    c2 = (char)(cLexSegment.data[n3++] & 0xFF);
                } else {
                    c2 = (char)((cLexSegment.data[n3++] & 0xFF) << 8);
                    c2 = (char)(c2 | (char)(cLexSegment.data[n3++] & 0xFF));
                }
                stringBuffer.append(stringArray2[c2]);
                bl = true;
            }
            if (wordCatcher.catchWord(stringBuffer.toString())) continue;
            return;
        }
    }
}

