/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smibridge;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.event.ExtRepsitoryListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.snmp.IndexConverter;
import com.agentpp.snmp.ValueConverter;
import com.objectspace.jgl.Pair;
import com.snmp4j.smi.CompilationMonitor;
import com.snmp4j.smi.CompilationResult;
import com.snmp4j.smi.NamedInputStream;
import com.snmp4j.smi.RepositoryDriver;
import com.snmp4j.smi.RepositoryIO;
import com.snmp4j.smi.SmiCompiler;
import com.snmp4j.smi.SmiError;
import com.snmp4j.smi.SmiGroup;
import com.snmp4j.smi.SmiGroupType;
import com.snmp4j.smi.SmiImport;
import com.snmp4j.smi.SmiIndexInfo;
import com.snmp4j.smi.SmiManager;
import com.snmp4j.smi.SmiModule;
import com.snmp4j.smi.SmiModuleIdentity;
import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectFilter;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiObjectTypeIndex;
import com.snmp4j.smi.SmiParseException;
import com.snmp4j.smi.SmiRevision;
import com.snmp4j.smi.SmiStatus;
import com.snmp4j.smi.SmiSyntax;
import com.snmp4j.smi.SmiSyntaxElement;
import com.snmp4j.smi.SmiSyntaxImpl;
import com.snmp4j.smi.SmiSyntaxType;
import com.snmp4j.smi.SmiTextualConvention;
import com.snmp4j.smi.SmiType;
import com.snmp4j.smi.SmiValueType;
import com.snmp4j.smibridge.ExtCompilationResult;
import com.snmp4j.smibridge.SmiLookupManager;
import com.snmp4j.smibridge.SmiSyntaxElementImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.MaxAccess;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.SimpleOIDTextFormat;
import org.snmp4j.util.VariableTextFormat;

public class SmiManagerBridge
implements OIDTextFormat,
VariableTextFormat,
SmiCompiler,
SmiLookupManager {
    private static final LogAdapter logger = LogFactory.getLogger(SmiManager.class);
    private DefaultRepositoryManager repositoryManager;
    private MIBRepository repository = new MIBRepository();
    private OctetStringDefaultFormat octetStringDisplayHint;
    private OIDFormat oidFormat = OIDFormat.ObjectNameAndDecodedIndex4RoundTrip;
    private NonPrintableStringFormat oidFormatNonPrintableStrings = NonPrintableStringFormat.asIs;
    private RepositoryDriver repositoryDriver;
    private transient boolean proEdition = true;
    private int fileCount = 1;
    private char oidFixedLengthStringQuote = (char)39;
    private char oidVariableLengthStringQuote = (char)34;
    private String oidFixedLengthStringQuoteEscapeSequence = "\\'";
    private String oidVariableLengthStringQuoteEscapeSequence = "\\\"";
    private char oidStringQuoteEscapeCharacter = (char)92;
    private boolean forwardTokenTree;
    private RepositoryAdapter repositoryAdapter;

    public SmiManagerBridge(DefaultRepositoryManager repositoryManager, MIBRepository repository) {
        this(repositoryManager, repository, null);
    }

    public SmiManagerBridge(DefaultRepositoryManager repositoryManager, MIBRepository repository, RepositoryDriver repositoryDriver) {
        this.octetStringDisplayHint = OctetStringDefaultFormat.MIB;
        if (repository != null) {
            this.repository = repository;
        }
        this.repositoryDriver = repositoryDriver;
        this.repositoryManager = repositoryManager;
        if (repositoryManager != null) {
            repositoryManager.verbose = false;
            this.repositoryAdapter = new RepositoryAdapter();
            repositoryManager.addRepositoryListener(this.repositoryAdapter);
            try {
                this.fileCount = repositoryManager.getModuleNames().length;
            }
            catch (IOException e2) {
                this.fileCount = 1;
            }
        }
    }

    public RepositoryDriver getRepositoryDriver() {
        return this.repositoryDriver;
    }

    public void setRepositoryDriver(RepositoryDriver repositoryDriver) {
        this.repositoryDriver = repositoryDriver;
    }

    public void close() {
        this.repositoryManager.removeRepositoryListener(this.repositoryAdapter);
    }

    public boolean isForwardTokenTree() {
        return this.forwardTokenTree;
    }

    public void setForwardTokenTree(boolean forwardTokenTree) {
        this.forwardTokenTree = forwardTokenTree;
    }

    public OIDFormat getOidFormat() {
        return this.oidFormat;
    }

    public void setOidFormat(OIDFormat oidFormat) {
        this.oidFormat = oidFormat;
    }

    public OctetStringDefaultFormat getOctetStringDisplayHint() {
        return this.octetStringDisplayHint;
    }

    public void setOctetStringDisplayHint(OctetStringDefaultFormat octetStringDisplayHint) {
        this.octetStringDisplayHint = octetStringDisplayHint;
    }

    @Override
    public final String[] listModules() throws IOException {
        try {
            return this.repositoryManager.getModuleNames();
        }
        catch (IOException iox) {
            throw new IOException(iox.getMessage());
        }
    }

    @Override
    public final String[] getLoadedModuleNames() throws IOException {
        Vector<String> moduleNames = this.repository.getModuleNames();
        return moduleNames.toArray(new String[moduleNames.size()]);
    }

    @Override
    public final boolean loadModule(String moduleName) {
        Hashtable<Integer, String> importedModules = new Hashtable<Integer, String>();
        MIBModule module = null;
        try {
            module = this.repositoryManager.getModule(moduleName, true);
            MIBObject[] imported = this.repositoryManager.getImportedObjects(moduleName);
            this.repository.addAllObjects(imported);
            this.repository.addObject(module);
            this.repository.addAllObjects(module.getObjects());
            this.repository.addImportedModuleIDsInverse(importedModules);
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    public final boolean unloadModule(String moduleName) {
        return this.repository.removeModule(moduleName);
    }

    @Override
    public final boolean isModuleLoaded(String moduleName) {
        return this.repository.getModule(moduleName) != null;
    }

    public final List<String> deleteModule(String moduleName, boolean forceDeletion) {
        ArrayList<String> dependentModuleNames = new ArrayList<String>();
        try {
            if (!forceDeletion) {
                ModuleInfo[] moduleInfos;
                for (ModuleInfo info : moduleInfos = this.repositoryManager.getModuleInfos()) {
                    if (moduleName.equals(info.getModuleName()) || !info.importsFrom(moduleName)) continue;
                    dependentModuleNames.add(info.getModuleName());
                }
            }
            if (dependentModuleNames.isEmpty() && !this.repositoryManager.removeModule(moduleName)) {
                dependentModuleNames.add(moduleName);
            }
        }
        catch (IOException e2) {
            logger.error("IO error while deleting MIB module '" + moduleName + "': " + e2.getMessage(), e2);
            dependentModuleNames.add(moduleName);
        }
        return dependentModuleNames;
    }

    public final String[] compile(File textOrZipFile) throws SmiParseException, FileNotFoundException {
        NamedInputStream namedInputStream = this.createNamedInputStream(textOrZipFile);
        String[] moduleNames = this.compile(namedInputStream);
        try {
            namedInputStream.getInputStream().close();
        }
        catch (IOException e2) {
            logger.error("IOException while closing FileInputStream in compile(File): ", e2);
        }
        return moduleNames;
    }

    public void resetOidQuoting() {
        this.oidFixedLengthStringQuote = (char)39;
        this.oidVariableLengthStringQuote = (char)34;
        this.oidFixedLengthStringQuoteEscapeSequence = "\\'";
        this.oidVariableLengthStringQuoteEscapeSequence = "\\\"";
        this.oidStringQuoteEscapeCharacter = (char)92;
    }

    public char getOidFixedLengthStringQuote() {
        return this.oidFixedLengthStringQuote;
    }

    public void setOidFixedLengthStringQuote(char oidFixedLengthStringQuote) {
        this.oidFixedLengthStringQuote = oidFixedLengthStringQuote;
    }

    public char getOidVariableLengthStringQuote() {
        return this.oidVariableLengthStringQuote;
    }

    public void setOidVariableLengthStringQuote(char oidVariableLengthStringQuote) {
        this.oidVariableLengthStringQuote = oidVariableLengthStringQuote;
    }

    public String getOidFixedLengthStringQuoteEscapeSequence() {
        return this.oidFixedLengthStringQuoteEscapeSequence;
    }

    public void setOidFixedLengthStringQuoteEscapeSequence(String oidFixedLengthStringQuoteEscapeSequence) {
        this.oidFixedLengthStringQuoteEscapeSequence = oidFixedLengthStringQuoteEscapeSequence;
    }

    public String getOidVariableLengthStringQuoteEscapeSequence() {
        return this.oidVariableLengthStringQuoteEscapeSequence;
    }

    public void setOidVariableLengthStringQuoteEscapeSequence(String oidVariableLengthStringQuoteEscapeSequence) {
        this.oidVariableLengthStringQuoteEscapeSequence = oidVariableLengthStringQuoteEscapeSequence;
    }

    public char getOidStringQuoteEscapeCharacter() {
        return this.oidStringQuoteEscapeCharacter;
    }

    public void setOidStringQuoteEscapeCharacter(char oidStringQuoteEscapeCharacter) {
        this.oidStringQuoteEscapeCharacter = oidStringQuoteEscapeCharacter;
    }

    private NamedInputStream createNamedInputStream(File textOrZipFile) throws FileNotFoundException {
        NamedInputStream.ZipFormat zipFormat = NamedInputStream.ZipFormat.none;
        if (textOrZipFile.getName().toLowerCase().endsWith(".zip")) {
            zipFormat = NamedInputStream.ZipFormat.ZIP;
        }
        FileInputStream fileInputStream = new FileInputStream(textOrZipFile);
        return new NamedInputStream(fileInputStream, textOrZipFile.getPath(), zipFormat);
    }

    public final String[] compile(NamedInputStream mibFile) throws SmiParseException {
        String fileName = "SNMP4J-SMI_" + this.fileCount++;
        if (mibFile.getName() != null) {
            fileName = mibFile.getName();
        }
        try {
            ModuleInfo[] moduleInfos = this.repositoryManager.addModules(mibFile.getInputStream(), fileName);
            String[] moduleNames = new String[moduleInfos.length];
            for (int i2 = 0; i2 < moduleInfos.length; ++i2) {
                moduleNames[i2] = moduleInfos[i2].getModuleName();
            }
            return moduleNames;
        }
        catch (SMIParseException parseException) {
            throw SmiManagerBridge.createSmiParseException(parseException, fileName);
        }
    }

    public List<CompilationResult> compile(File[] files, CompilationMonitor compilationMonitor, boolean loadIntoRepository, boolean updateExistent, boolean compileLeniently) throws IOException {
        NamedInputStream[] namedInputStreams = new NamedInputStream[files.length];
        try {
            for (int i2 = 0; i2 < files.length; ++i2) {
                namedInputStreams[i2] = this.createNamedInputStream(files[i2]);
            }
            List<CompilationResult> i2 = this.compile(namedInputStreams, compilationMonitor, loadIntoRepository, updateExistent, compileLeniently);
            return i2;
        }
        catch (IOException iox) {
            throw iox;
        }
        finally {
            for (NamedInputStream namedInputStream : namedInputStreams) {
                if (namedInputStream == null || namedInputStream.getInputStream() == null) continue;
                namedInputStream.getInputStream().close();
            }
        }
    }

    public List<CompilationResult> compile(File[] files, CompilationMonitor compilationMonitor, SmiCompiler.TargetMode compilerTargetMode, SmiCompiler.OverwriteMode overwriteMode, SmiCompiler.Strictness strictness) throws IOException {
        NamedInputStream[] namedInputStreams = new NamedInputStream[files.length];
        try {
            for (int i2 = 0; i2 < files.length; ++i2) {
                namedInputStreams[i2] = this.createNamedInputStream(files[i2]);
            }
            List<CompilationResult> i2 = this.compile(namedInputStreams, compilationMonitor, compilerTargetMode, overwriteMode, strictness);
            return i2;
        }
        catch (IOException iox) {
            throw iox;
        }
        finally {
            for (NamedInputStream namedInputStream : namedInputStreams) {
                if (namedInputStream == null || namedInputStream.getInputStream() == null) continue;
                namedInputStream.getInputStream().close();
            }
        }
    }

    @Override
    public List<CompilationResult> compile(NamedInputStream[] files, CompilationMonitor compilationMonitor, SmiCompiler.TargetMode compilerTargetMode, SmiCompiler.OverwriteMode overwriteMode, SmiCompiler.Strictness strictness) throws IOException {
        ArrayList cachedFiles = new ArrayList(files.length);
        int n2 = 1;
        for (NamedInputStream namedInputStream : files) {
            if (compilationMonitor != null && !compilationMonitor.loadingProgress(namedInputStream.getName(), n2++, files.length)) break;
            cachedFiles.addAll(CachedNamedInputStream.createCachedStreams(namedInputStream));
        }
        ArrayList<CompilationResult> results = new ArrayList<CompilationResult>();
        int total = 0;
        ArrayList<ModuleInfo> v = new ArrayList<ModuleInfo>(cachedFiles.size());
        boolean cancelled = false;
        for (int j2 = 0; !cancelled && j2 < cachedFiles.size(); ++j2) {
            ModuleInfo[] file = (ModuleInfo[])cachedFiles.get(j2);
            try {
                ModuleInfo[] info;
                cancelled = compilationMonitor != null && !compilationMonitor.sortingProgress(file.getName(), j2 + 1, cachedFiles.size());
                for (ModuleInfo moduleInfo : info = this.repositoryManager.getModuleInfo(file.getCachedInputStream(), file.getName())) {
                    moduleInfo.userObject = file;
                    Collections.addAll(v, info);
                }
                continue;
            }
            catch (Exception ex) {
                ModuleInfo inf = new ModuleInfo("invalid ");
                inf.path = new File(file.getName());
                inf.userObject = file;
                v.add(inf);
            }
        }
        if (cancelled) {
            return Collections.emptyList();
        }
        ModuleInfo[] existent = this.repositoryManager.getModuleInfos();
        if (overwriteMode != SmiCompiler.OverwriteMode.overwriteAlways) {
            for (ModuleInfo anExistent : existent) {
                for (int j3 = 0; j3 < v.size(); ++j3) {
                    ModuleInfo[] inf = (ModuleInfo[])v.get(j3);
                    if (!inf.getModuleName().equals(anExistent.getModuleName()) || overwriteMode == SmiCompiler.OverwriteMode.overwriteIfNewer && inf.getLastUpdated() != null && (inf.getLastUpdated() == null || anExistent.getLastUpdated() != null && (anExistent.getLastUpdated() == null || inf.getLastUpdated().compareTo(anExistent.getLastUpdated()) > 0))) continue;
                    v.remove(j3);
                    --j3;
                }
            }
            HashSet<String> h2 = new HashSet<String>(v.size() + 10);
            for (int j4 = 0; j4 < v.size(); ++j4) {
                ModuleInfo inf = (ModuleInfo)v.get(j4);
                if (h2.contains(inf.getModuleName())) {
                    v.remove(j4);
                    --j4;
                    continue;
                }
                h2.add(inf.getModuleName());
            }
        }
        ModuleInfo[] list = new ModuleInfo[v.size()];
        v.toArray(list);
        v = null;
        ModuleInfoSorter s = new ModuleInfoSorter(list);
        s.setPool(existent);
        s.setBackupPool(this.repositoryManager.getBuiltinModuleNames());
        s.sort();
        ModuleInfo[] sorted = s.getSortedList();
        ModuleInfo[] failed = s.getFailedList();
        ArrayList<CachedNamedInputStream> files4Parsing = new ArrayList<CachedNamedInputStream>(sorted.length + failed.length);
        for (ModuleInfo sm : sorted) {
            files4Parsing.add((CachedNamedInputStream)sm.userObject);
        }
        for (ModuleInfo fm : failed) {
            files4Parsing.add((CachedNamedInputStream)fm.userObject);
        }
        CachedNamedInputStream currentFile = null;
        HashSet<CachedNamedInputStream> parsed = new HashSet<CachedNamedInputStream>();
        Iterator iterator = files4Parsing.iterator();
        while (iterator.hasNext()) {
            CachedNamedInputStream file2Parse;
            currentFile = file2Parse = (CachedNamedInputStream)iterator.next();
            if (parsed.contains(file2Parse)) {
                ++total;
                continue;
            }
            parsed.add(file2Parse);
            ++total;
            try {
                ModuleInfo[] info = compilerTargetMode == SmiCompiler.TargetMode.dryRun || compilerTargetMode == SmiCompiler.TargetMode.dryRunWithoutErrorLimit ? this.repositoryManager.checkModules(file2Parse.getCachedInputStream(), strictness == SmiCompiler.Strictness.lenient, compilerTargetMode == SmiCompiler.TargetMode.dryRunWithoutErrorLimit) : (strictness == SmiCompiler.Strictness.lenient ? this.repositoryManager.addModulesLeniently(file2Parse.getCachedInputStream(), file2Parse.getName()) : this.repositoryManager.addModules(file2Parse.getCachedInputStream(), file2Parse.getName()));
                ArrayList<String> m2 = new ArrayList<String>();
                SMIRepository smiRepository = null;
                for (ModuleInfo anInfo : info) {
                    if (anInfo.userObject instanceof SMIRepository) {
                        smiRepository = (SMIRepository)anInfo.userObject;
                    }
                    m2.add(anInfo.moduleName);
                    if (compilerTargetMode != SmiCompiler.TargetMode.storeIntoRepositoryAndLoad) continue;
                    MIBObject[] mibObjects = this.repositoryManager.getObjects(anInfo.moduleName);
                    this.repository.addAllObjects(mibObjects);
                    mibObjects = this.repositoryManager.getImportedObjects(anInfo.moduleName);
                    this.repository.addAllObjects(mibObjects);
                }
                if (compilationMonitor != null && !compilationMonitor.compilationProgress(m2.isEmpty() ? null : (String)m2.get(0), total, files4Parsing.size()) ? true : (cancelled = false)) break;
                results.add(new ExtCompilationResult(file2Parse.getName(), m2, new ArrayList<SmiError>(), currentFile.getZipFileName(), this.forwardTokenTree ? smiRepository : null));
            }
            catch (SMIParseException pex) {
                pex.freeUnusedTokens();
                results.add(new ExtCompilationResult(currentFile.getName(), null, SmiManagerBridge.createSmiParseException(pex, currentFile.getName()).getErrorList(), currentFile.getZipFileName(), this.forwardTokenTree ? pex.getSmiRepository() : null));
            }
            if (!cancelled) continue;
            return results;
        }
        return results;
    }

    public List<CompilationResult> compile(NamedInputStream[] files, CompilationMonitor compilationMonitor, boolean loadIntoRepository, boolean updateExistent, boolean compileLeniently) throws IOException {
        return this.compile(files, compilationMonitor, loadIntoRepository ? SmiCompiler.TargetMode.storeIntoRepositoryAndLoad : SmiCompiler.TargetMode.storeIntoRepositoryNoLoad, updateExistent ? SmiCompiler.OverwriteMode.overwriteAlways : SmiCompiler.OverwriteMode.addNewOnly, compileLeniently ? SmiCompiler.Strictness.lenient : SmiCompiler.Strictness.standard);
    }

    private ValueConverter createValueConverter(MIBObjectType ot) {
        MIBTextualConvention tc = this.repository.getEffectiveSyntax(ot.getSyntax());
        String displayHint = tc.getDisplayHint();
        if (displayHint == null && this.octetStringDisplayHint != null && this.octetStringDisplayHint.getDisplayHint().length() > 0) {
            displayHint = this.octetStringDisplayHint.getDisplayHint();
        }
        return new ValueConverter(ot, tc.getSyntax(), displayHint);
    }

    public static SmiParseException createSmiParseException(SMIParseException parseException, String fileName) {
        return SmiManagerBridge.createSmiParseException(parseException, fileName, 0);
    }

    public static SmiParseException createSmiParseException(SMIParseException parseException, String fileName, int lineOffset) {
        ArrayList<SmiError> errorList = new ArrayList<SmiError>();
        List<SMIParseException> parseExceptionList = parseException.getErrorList() != null && parseException.getErrorList().size() > 0 ? parseException.getErrorList() : Collections.singletonList(parseException);
        for (SMIParseException pex : parseExceptionList) {
            String errorText = "[" + fileName + "] " + DefaultRepositoryManager.getErrorText(pex, true, true, lineOffset);
            String shortErrorText = DefaultRepositoryManager.getErrorText(pex, false, false, lineOffset);
            int row = -1;
            int col = -1;
            int endRow = -1;
            int endCol = -1;
            String offendingText = null;
            int position = -1;
            int errorNumber = pex.errorType;
            String[] expectedText = null;
            if (pex.fileError != null) {
                row = pex.fileError.getLine();
                col = pex.fileError.getColumn();
                endRow = pex.fileError.getEndLine();
                endCol = pex.fileError.getEndColumn();
                errorNumber = pex.fileError.getErrorType();
                offendingText = pex.fileError.getFoundTokenImage() == null ? pex.fileError.getFound() : pex.fileError.getFoundTokenImage();
                position = pex.fileError.getEndPosition();
                if (offendingText != null) {
                    position = Math.max(0, position - offendingText.length());
                }
                expectedText = pex.fileError.getLastExpectedImages();
            }
            errorList.add(new SmiError(fileName, row, col, endRow, endCol, position, errorNumber, errorText, shortErrorText, offendingText, expectedText));
        }
        Collections.sort(errorList, new SmiErrorComparator());
        return new SmiParseException(errorList);
    }

    @Override
    public final String format(OID instanceOID, Variable variable, boolean withOID) {
        Object o2;
        MIBObjectType ot;
        StringBuilder buf = new StringBuilder();
        if (withOID) {
            buf.append(this.format(instanceOID.getValue()));
            buf.append(" = ");
        }
        ValueConverter vc = (ot = this.repository.getObjectType(new ObjectID(instanceOID.getValue()))) != null ? this.createValueConverter(ot) : new ValueConverter(variable.getClass());
        if (this.octetStringDisplayHint != null && this.octetStringDisplayHint.getDisplayHint().length() > 0) {
            vc.setDisplayHint(this.octetStringDisplayHint.getDisplayHint());
        }
        if ((o2 = vc.toNative(variable, true)) != null) {
            buf.append(o2.toString());
        } else {
            buf.append(variable.toString());
        }
        return buf.toString();
    }

    @Override
    public final VariableBinding parseVariableBinding(String text) throws ParseException {
        int assignmentPos = text.indexOf(" = ");
        if (assignmentPos <= 0) {
            throw new ParseException("Could not locate assignment ' = ' string in '" + text, 0);
        }
        OID oid = new OID(this.parse(text.substring(0, assignmentPos)));
        Variable var = this.parse(oid, text.substring(assignmentPos + 3));
        return new VariableBinding(oid, var);
    }

    @Override
    public final Variable parse(OID classOrInstanceOID, String text) throws ParseException {
        ValueConverter vc = null;
        MIBObjectType ot = this.repository.getObjectType(new ObjectID(classOrInstanceOID.getValue()));
        if (ot != null) {
            vc = this.createValueConverter(ot);
        }
        if (vc == null) {
            return null;
        }
        Variable value = vc.fromString(text);
        return value;
    }

    @Override
    public final Variable parse(int smiSyntax, String text) throws ParseException {
        ValueConverter vc = new ValueConverter(ValueConverter.getSmiSyntax(smiSyntax));
        return vc.fromString(text);
    }

    @Override
    public final String format(int[] value) {
        ObjectID oid = new ObjectID(value);
        switch (this.oidFormat) {
            case ObjectNameNumIndex: {
                return this.repository.getPathSuffix(oid);
            }
            case ObjectNameAndDecodedIndex: {
                return this.getPathSuffixWithIndex(oid);
            }
            case ObjectNameAndDecodedIndex4RoundTrip: {
                return this.getPathSuffixWithIndex4RoundTrip(oid);
            }
        }
        return oid.toString();
    }

    @Override
    public String formatForRoundTrip(int[] value) {
        switch (this.oidFormat) {
            case ObjectNameNumIndex: 
            case ObjectNameAndDecodedIndex: {
                return this.repository.getPathSuffix(new ObjectID(value));
            }
            case ObjectNameAndDecodedIndex4RoundTrip: {
                return this.getPathSuffixWithIndex4RoundTrip(new ObjectID(value));
            }
        }
        return SimpleOIDTextFormat.formatOID(value);
    }

    @Override
    public final int[] parse(String text) throws ParseException {
        ObjectID oid;
        int pos;
        String oidText = text;
        if (oidText.length() == 0) {
            return new int[0];
        }
        String moduleName = null;
        if (Character.isUpperCase(oidText.charAt(0))) {
            pos = oidText.indexOf(58);
            if (pos < 0) {
                pos = oidText.indexOf(46);
            }
            if (pos > 0) {
                moduleName = oidText.substring(0, pos);
                if (!this.isModuleLoaded(moduleName) && !this.loadModule(moduleName)) {
                    throw new ParseException("MIB module '" + moduleName + "' not found", 0);
                }
                oidText = oidText.substring(pos + 1);
            }
        }
        if (this.oidFormat == OIDFormat.ObjectNameAndDecodedIndex4RoundTrip) {
            pos = oidText.indexOf(46);
            char c2 = oidText.charAt(0);
            if (pos >= 0 && (Character.isLetter(c2) || c2 == this.oidFixedLengthStringQuote || c2 == this.oidVariableLengthStringQuote)) {
                MIBObject o2;
                String indexSuffix = oidText.substring(pos + 1);
                oidText = oidText.substring(0, pos);
                MIBObject mIBObject = o2 = moduleName != null ? this.repository.getObject(moduleName, oidText) : this.repository.getObject(oidText);
                if (o2 instanceof MIBObjectType) {
                    MIBObjectType ot = (MIBObjectType)o2;
                    if (ot.isColumnarObject()) {
                        MIBObject entry = this.repository.getParent(ot);
                        if (entry instanceof MIBObjectType) {
                            MIBObjectType table = (MIBObjectType)entry;
                            try {
                                int i2;
                                OID oid2 = new OID(ot.getOid().asIntArray());
                                IndexStruct[] indexStructs = table.getIndexPart().getIndexStruct(this.repository);
                                List<String> subIndexes = SmiManagerBridge.tokenizeQuotedString(indexSuffix, "" + this.oidVariableLengthStringQuote + this.oidFixedLengthStringQuote, this.oidStringQuoteEscapeCharacter, ".", true);
                                ValueConverter[] vcs = IndexConverter.getIndexValueConverter(this.repository, table);
                                int offset = 0;
                                boolean parseComplete = false;
                                for (i2 = 0; i2 < Math.min(subIndexes.size(), Math.min(vcs.length, indexStructs.length)); ++i2) {
                                    String s = subIndexes.get(i2 + offset);
                                    if (s.charAt(0) == this.oidVariableLengthStringQuote || s.charAt(0) == this.oidFixedLengthStringQuote) {
                                        Variable variable;
                                        if ((s = s.substring(1, s.length() - 1)).length() > 2) {
                                            if (s.charAt(0) == '#') {
                                                IndexConverter.StringFormat format = IndexConverter.StringFormat.getFormat(s.substring(0, 2));
                                                OctetString os = OctetString.fromString(s.substring(2, s.length()), format.getDelimiter(), format.getRadix());
                                                s = new String(os.getValue());
                                            } else if (s.charAt(0) == this.oidStringQuoteEscapeCharacter) {
                                                s = s.substring(1);
                                            }
                                        }
                                        if ((variable = vcs[i2].fromString(s)) == null) continue;
                                        oid2.append(variable.toSubIndex(indexStructs[i2].impliedLength));
                                        continue;
                                    }
                                    if (indexStructs[i2].impliedLength) {
                                        for (int j2 = i2 + offset; j2 < subIndexes.size(); ++j2) {
                                            oid2.append(subIndexes.get(j2));
                                        }
                                        parseComplete = true;
                                        break;
                                    }
                                    if (indexStructs[i2].minLength == indexStructs[i2].maxLength) {
                                        int count = indexStructs[i2].minLength;
                                        for (int j3 = i2 + offset; j3 < subIndexes.size() && j3 < i2 + offset + count; ++j3) {
                                            oid2.append(subIndexes.get(j3));
                                        }
                                        offset += count - 1;
                                        continue;
                                    }
                                    int count = Integer.parseInt(s);
                                    for (int j4 = i2 + offset; j4 < subIndexes.size() && j4 < i2 + offset + count + 1; ++j4) {
                                        oid2.append(subIndexes.get(j4));
                                    }
                                    offset += count;
                                }
                                if (!parseComplete && subIndexes.size() > i2 + offset) {
                                    this.parseIndex(indexSuffix, i2, oid2);
                                }
                                return oid2.getValue();
                            }
                            catch (ObjectIDFormatException objectIDFormatException) {
                                // empty catch block
                            }
                        }
                        oidText = oidText + '.' + indexSuffix;
                    } else if (ot.isScalar()) {
                        oidText = oidText + '.' + indexSuffix;
                    }
                } else if (o2 != null) {
                    try {
                        OID oid3 = new OID(o2.getOid().asIntArray());
                        this.parseIndex(indexSuffix, 0, oid3);
                        return oid3.getValue();
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((oid = this.repository.resolveOID(new ObjectID(oidText))) == null) {
            throw new ParseException("Could not resolve OID '" + text + "'", 0);
        }
        try {
            return oid.asIntArray();
        }
        catch (ObjectIDFormatException ex) {
            throw new ParseException("Could not resolve OID '" + oid + "'", 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseIndex(String indexSuffix, int subIndexOffset, OID oid) {
        subIndexes = SmiManagerBridge.tokenizeQuotedString(indexSuffix, "" + this.oidFixedLengthStringQuote + this.oidVariableLengthStringQuote, this.oidStringQuoteEscapeCharacter, ".", true);
        prefix = "" + this.oidStringQuoteEscapeCharacter + "#";
        while (subIndexOffset < subIndexes.size()) {
            block5: {
                block6: {
                    subIndex = subIndexes.get(subIndexOffset);
                    if (subIndex.length() <= 0) break block5;
                    sc = subIndex.charAt(0);
                    if (sc != this.oidFixedLengthStringQuote && sc != this.oidVariableLengthStringQuote) break block6;
                    if (subIndex.length() <= 2) ** GOTO lbl-1000
                    if (subIndex.charAt(1) == '#') {
                        format = IndexConverter.StringFormat.getFormat(subIndex.substring(1, 3));
                        os = OctetString.fromString(subIndex.substring(3, subIndex.length() - 1), format.getDelimiter(), format.getRadix());
                        oid.append(os.toSubIndex(sc == '\''));
                    } else if (subIndex.startsWith(prefix, 1)) {
                        oid.append(new OctetString(subIndex.substring(2, subIndex.length() - 1)).toSubIndex(sc == this.oidFixedLengthStringQuote));
                    } else lbl-1000:
                    // 2 sources

                    {
                        oid.append(new OctetString(subIndex.substring(1, subIndex.length() - 1)).toSubIndex(sc == this.oidFixedLengthStringQuote));
                    }
                    break block5;
                }
                oid.append(new OID(subIndex));
            }
            ++subIndexOffset;
        }
    }

    public static List<String> tokenizeQuotedString(String text, String quotes, char escapeChar, String delimiter, boolean includeQuotes) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int posEscape = -1;
        boolean inQuotes = false;
        Character lastQuote = null;
        boolean inEscape = false;
        StringBuilder buffer = new StringBuilder();
        for (int current = 0; current < text.length(); ++current) {
            boolean atLastChar;
            char c2 = text.charAt(current);
            if (c2 == escapeChar) {
                if (inEscape) {
                    inEscape = false;
                    buffer.append(text.substring(start, posEscape)).append(c2);
                    start = current + 1;
                    continue;
                }
                inEscape = true;
                posEscape = current;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                buffer.append(text.substring(start, posEscape)).append(c2);
                start = current + 1;
                continue;
            }
            if (quotes.indexOf(c2) >= 0) {
                if (lastQuote == null) {
                    inQuotes = true;
                    lastQuote = Character.valueOf(c2);
                    if (!includeQuotes) {
                        buffer.append(text.substring(start, current));
                        start = current + 1;
                    }
                } else if (lastQuote.charValue() == c2) {
                    inQuotes = false;
                    lastQuote = null;
                    if (!includeQuotes) {
                        buffer.append(text.substring(start, current));
                        start = current + 1;
                    }
                }
            }
            boolean bl = atLastChar = current == text.length() - 1;
            if (atLastChar) {
                result.add(buffer.toString() + text.substring(start));
                buffer.setLength(0);
                continue;
            }
            if (delimiter.indexOf(text.charAt(current)) < 0 || inQuotes) continue;
            result.add(buffer.toString() + text.substring(start, current));
            start = current + 1;
            buffer.setLength(0);
        }
        return result;
    }

    private String getPathSuffixWithIndex(ObjectID oid) {
        try {
            Pair p2 = this.repository.getSplittedObjectID(oid);
            if (p2.second != null && ((ObjectID)p2.second).size() > 0) {
                ObjectID entry = (ObjectID)p2.first;
                ObjectID index = (ObjectID)p2.second;
                MIBObject o2 = this.repository.getObject(entry);
                MIBObjectType ot = (MIBObjectType)this.repository.getParent(o2);
                if (ot != null) {
                    IndexStruct[] ind;
                    if (ot.getIndexPart().isAugment()) {
                        ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
                    }
                    if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) != null) {
                        try {
                            ObjectID[] iIDs = this.repository.getIndexObjectIDs(index, ind);
                            ValueConverter[] indexValueConverter = this.getIndexValueConverter(ot);
                            return o2.getName() + "." + IndexConverter.getIndexString(indexValueConverter, ind, iIDs);
                        }
                        catch (NullPointerException npex) {
                            npex.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.repository.getPathSuffix(oid);
    }

    private String getPathSuffixWithIndex4RoundTrip(ObjectID oid) {
        block6: {
            try {
                IndexStruct[] ind;
                Pair p2 = this.repository.getSplittedObjectID(oid);
                if (p2.second == null || ((ObjectID)p2.second).size() <= 0) break block6;
                ObjectID entry = (ObjectID)p2.first;
                ObjectID index = (ObjectID)p2.second;
                MIBObject o2 = this.repository.getObject(entry);
                MIBObject parent = this.repository.getParent(o2);
                if (!(parent instanceof MIBObjectType)) break block6;
                MIBObjectType ot = (MIBObjectType)parent;
                if (ot.getIndexPart().isAugment()) {
                    ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
                }
                if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) == null) break block6;
                try {
                    ObjectID[] iIDs = this.repository.getIndexObjectIDs(index, ind);
                    ValueConverter[] indexValueConverter = this.getIndexValueConverter(ot);
                    if (iIDs != null && indexValueConverter != null) {
                        return o2.getName() + "." + IndexConverter.getIndexString(indexValueConverter, ind, iIDs, true, "" + this.oidFixedLengthStringQuote, "" + this.oidVariableLengthStringQuote, this.oidFixedLengthStringQuoteEscapeSequence, this.oidVariableLengthStringQuoteEscapeSequence, IndexConverter.StringFormat.getFormat(this.oidFormatNonPrintableStrings.getRadix()));
                    }
                }
                catch (NullPointerException npex) {
                    npex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.repository.getPathSuffix(oid);
    }

    public NonPrintableStringFormat getOidFormatNonPrintableStrings() {
        return this.oidFormatNonPrintableStrings;
    }

    public void setOidFormatNonPrintableStrings(NonPrintableStringFormat oidFormatNonPrintableStrings) {
        if (oidFormatNonPrintableStrings == null) {
            throw new NullPointerException();
        }
        this.oidFormatNonPrintableStrings = oidFormatNonPrintableStrings;
    }

    public Variable[] getIndexVariables(OID table, OID index) {
        MIBObjectType ot;
        MIBObject o2 = this.repository.getObject(new ObjectID(table.getValue()));
        if (o2 instanceof MIBObjectType && (ot = (MIBObjectType)o2) != null && ot.getIndexPart() != null) {
            IndexStruct[] ind;
            if (ot.getIndexPart().isAugment()) {
                ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
            }
            if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) != null) {
                ObjectID[] iIDs = this.repository.getIndexObjectIDs(new ObjectID(index.getValue()), ind);
                return IndexConverter.getIndexVariables(ind, iIDs);
            }
        }
        return null;
    }

    public String getIndexStringFromVariables(OID table, List<VariableBinding> indexObjects) {
        MIBObjectType ot;
        MIBObject o2 = this.repository.getObject(new ObjectID(table.getValue()));
        if (o2 instanceof MIBObjectType && (ot = (MIBObjectType)o2) != null && ot.getIndexPart() != null) {
            if (ot.getIndexPart().isAugment()) {
                ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
            }
            Variable[] variables = new Variable[indexObjects.size()];
            int i2 = 0;
            for (VariableBinding vb : indexObjects) {
                variables[i2++] = vb.getVariable();
            }
            return IndexConverter.getIndexValueString(this.repository, ot, variables, true, "" + this.oidFixedLengthStringQuote, "" + this.oidVariableLengthStringQuote, this.oidFixedLengthStringQuoteEscapeSequence, this.oidVariableLengthStringQuoteEscapeSequence, IndexConverter.StringFormat.getFormat(this.oidFormatNonPrintableStrings.getRadix()));
        }
        return null;
    }

    @Override
    public SmiObject findSmiObject(OID oid) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getObject(new ObjectID(oid.getValue()));
        if (mibObject != null) {
            return this.createSmiObject(mibObject, oid);
        }
        return null;
    }

    @Override
    public SmiObject findRootSmiObject() {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getNextObject(new ObjectID());
        if (mibObject != null) {
            return this.createSmiObject(mibObject, new OID(mibObject.getPrintableOid()));
        }
        return null;
    }

    @Override
    public SmiModule findSmiModule(String moduleName) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBModule mibModule = this.repository.getModule(moduleName);
        if (mibModule != null) {
            return new SmiModuleIdentityImpl(mibModule, new OID(mibModule.getPrintableOid()));
        }
        return null;
    }

    @Override
    public SmiObject findSmiObject(String moduleName, String objectName) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getObject(moduleName, objectName);
        if (mibObject != null) {
            return this.createSmiObject(mibObject, mibObject.getOid() != null ? new OID(mibObject.getPrintableOid()) : null);
        }
        return null;
    }

    public <S extends SmiObject> List<S> findSmiObject(String moduleName, SmiObjectFilter<S> filter) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        ArrayList<SmiObject> result = new ArrayList<SmiObject>();
        Enumeration<? extends MIBObject> objectEnumeration = this.repository.objects();
        while (objectEnumeration.hasMoreElements()) {
            SmiObject smiObject;
            MIBObject mibObject = objectEnumeration.nextElement();
            SmiType smiType = mibObject instanceof MIBObjectType ? this.getSmiType((MIBObjectType)mibObject) : SmiType.fromJasmiType(mibObject.getType());
            if (!filter.passesFilter(smiType) || !filter.passesFilter(smiObject = this.createSmiObject(mibObject, mibObject.getOid() != null ? new OID(mibObject.getPrintableOid()) : null))) continue;
            result.add(smiObject);
        }
        return result;
    }

    public void setIncludeUnknownErrorsCause(boolean includeUnknownErrorsCause) {
        DefaultRepositoryManager.setForwardUnknownErrors(includeUnknownErrorsCause);
    }

    public boolean isIncludeUnknownErrorsCause() {
        SmiManagerBridge smiManagerBridge = this;
        return smiManagerBridge.repositoryManager.isForwardUnknownErrors();
    }

    public void setSmiErrorTextResourceBundle(String resourceBundleClassName) {
        DefaultRepositoryManager.setResourceClassName(resourceBundleClassName);
    }

    private SmiObject createSmiObject(MIBObject mibObject, OID oid) {
        if (this.proEdition) {
            if (mibObject instanceof MIBObjectType) {
                return new SmiObjectTypeImpl((MIBObjectType)mibObject, oid);
            }
            if (mibObject instanceof MIBTextualConvention) {
                return new SmiTextualConventionImpl((MIBTextualConvention)mibObject);
            }
            if (mibObject instanceof MIBGroup) {
                return new SmiGroupImpl((MIBGroup)mibObject, oid);
            }
            if (mibObject instanceof MIBModule) {
                return new SmiModuleIdentityImpl((MIBModule)mibObject, oid);
            }
            return new SmiObjectImpl(mibObject, oid);
        }
        return null;
    }

    private String[] getIndexStrings(ObjectID instanceOID) {
        try {
            Pair p2 = this.repository.getSplittedObjectID(instanceOID);
            if (p2.second != null && ((ObjectID)p2.second).size() > 0) {
                ObjectID entry = (ObjectID)p2.first;
                ObjectID index = (ObjectID)p2.second;
                MIBObject o2 = this.repository.getObject(entry);
                MIBObjectType ot = (MIBObjectType)this.repository.getParent(o2);
                if (ot != null) {
                    IndexStruct[] ind;
                    if (ot.getIndexPart().isAugment()) {
                        ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
                    }
                    if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) != null) {
                        try {
                            ObjectID[] iIDs = this.repository.getIndexObjectIDs(index, ind);
                            ValueConverter[] indexValueConverter = this.getIndexValueConverter(ot);
                            Variable[] variables = IndexConverter.getIndexVariables(ind, iIDs);
                            String[] result = new String[variables.length];
                            for (int i2 = 0; i2 < variables.length; ++i2) {
                                result[i2] = "" + indexValueConverter[i2].toNative(variables[i2], true);
                            }
                            return result;
                        }
                        catch (NullPointerException npex) {
                            npex.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private ValueConverter[] getIndexValueConverter(MIBObjectType table) {
        if (!table.isTable()) {
            return null;
        }
        Vector<? extends MIBObjectType> v = this.repository.getColumnarObjectsOfTable(table, true, false);
        if (table.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])table.userObject;
        }
        ValueConverter[] vc = new ValueConverter[v.size()];
        for (int i2 = 0; i2 < vc.length; ++i2) {
            MIBObjectType ot = v.elementAt(i2);
            MIBTextualConvention tc = this.repository.getEffectiveSyntax(ot.getSyntax());
            vc[i2] = new ValueConverter(ot, tc.getSyntax(), tc.getDisplayHint());
        }
        table.userObject = vc;
        return vc;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static int getSnmpSyntax(int smiSyntax) {
        int snmpSyntax = 0;
        switch (smiSyntax) {
            case 0: 
            case 8: {
                snmpSyntax = 2;
                break;
            }
            case 3: 
            case 5: {
                snmpSyntax = 65;
                break;
            }
            case 6: {
                snmpSyntax = 70;
                break;
            }
            case 10: {
                snmpSyntax = 68;
                break;
            }
            case 1: {
                snmpSyntax = 4;
                break;
            }
            case 2: {
                snmpSyntax = 6;
                break;
            }
            case 9: 
            case 15: {
                snmpSyntax = 64;
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                snmpSyntax = 66;
                break;
            }
            case 11: {
                snmpSyntax = 67;
                break;
            }
            case 12: {
                snmpSyntax = 4;
                break;
            }
            default: {
                snmpSyntax = 5;
            }
        }
        return snmpSyntax;
    }

    private SmiType getSmiType(MIBObjectType mibObject) {
        if (mibObject.isTable()) {
            return SmiType.OBJECT_TYPE_TABLE_ENTRY;
        }
        if (mibObject.isColumnarObject()) {
            return SmiType.OBJECT_TYPE_COLUMN;
        }
        if (mibObject.isTableSequence()) {
            return SmiType.OBJECT_TYPE_TABLE;
        }
        return SmiType.OBJECT_TYPE_SCALAR;
    }

    private List<SmiSyntaxElement> getSmiSyntaxElementList(MIBSyntax mibSyntax) {
        List<SmiSyntaxElement> elementList = null;
        ArrayList<SmiSyntaxElementImpl> elements = new ArrayList<SmiSyntaxElementImpl>();
        if (mibSyntax.hasEnums()) {
            for (MIBEnum e2 : mibSyntax.getEnumsVector()) {
                elements.add(new SmiSyntaxElementImpl(SmiSyntaxElement.Type.Enumeration, e2.getLabel(), e2.getLongValue(), null));
            }
        } else if (mibSyntax.hasRanges()) {
            for (MIBRange mibRange : mibSyntax.getRangesVector()) {
                elements.add(new SmiSyntaxElementImpl(SmiSyntaxElement.Type.Range, null, mibRange.getLowerValue(), mibRange.getUpper()));
            }
        }
        elementList = Collections.unmodifiableList(elements);
        return elementList;
    }

    private static SmiSyntaxType getSyntaxType(MIBSyntax mibSyntax) {
        if (mibSyntax == null) {
            return null;
        }
        switch (mibSyntax.getType()) {
            case 1: {
                return SmiSyntaxType.APPLICATION;
            }
            case 3: {
                return SmiSyntaxType.CONVENTION;
            }
            case 2: {
                return SmiSyntaxType.SEQUENCE;
            }
            case 0: {
                return SmiSyntaxType.SIMPLE;
            }
        }
        return null;
    }

    private static class SmiErrorComparator
    implements Comparator<SmiError> {
        private SmiErrorComparator() {
        }

        @Override
        public int compare(SmiError o1, SmiError o2) {
            return o1.getPosition() - o2.getPosition();
        }
    }

    private class SmiImportImpl
    implements SmiImport {
        private MIBImport mibImport;

        private SmiImportImpl(MIBImport mibImport) {
            this.mibImport = mibImport;
        }

        @Override
        public String getSourceModuleName() {
            return this.mibImport.getSource();
        }

        @Override
        public String getAsn1Comment() {
            return this.mibImport.getComment();
        }

        @Override
        public List<String> getImportedObjectNames() {
            return Collections.unmodifiableList(this.mibImport.getImportsVector());
        }

        public String toString() {
            return this.mibImport.toSMI(SmiManagerBridge.this.repository, 1, "\n");
        }
    }

    private class SmiRevisionImpl
    implements SmiRevision {
        private IRevision mibRevision;

        private SmiRevisionImpl(IRevision mibRevision) {
            this.mibRevision = mibRevision;
        }

        @Override
        public String getRevisionString() {
            return MIBObject.getUnquotedString(this.mibRevision.getRevision());
        }

        @Override
        public GregorianCalendar getRevision() {
            return MIBModule.getDateAndTimeFromUTC(this.getRevisionString());
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.mibRevision.getDescription());
        }

        public String toString() {
            return this.mibRevision.getRevision();
        }
    }

    private class SmiModuleIdentityImpl
    extends SmiObjectImpl
    implements SmiModuleIdentity {
        private List<String> textualConventions;
        private List<String> objectNames;

        private SmiModuleIdentityImpl(MIBModule mibModule, OID oid) {
            super(mibModule, oid);
        }

        private MIBModule getMIBModule() {
            return (MIBModule)this.mibObject;
        }

        @Override
        public String getOrganization() {
            return MIBObject.getUnquotedString(this.getMIBModule().getOrganization());
        }

        @Override
        public String getContactInfo() {
            return MIBObject.getUnquotedString(this.getMIBModule().getContactInfo());
        }

        @Override
        public String getLastUpdatedString() {
            return MIBObject.getUnquotedString(this.getMIBModule().getLastUpdated());
        }

        @Override
        public GregorianCalendar getLastUpdated() {
            return MIBModule.getDateAndTimeFromUTC(this.getLastUpdatedString());
        }

        @Override
        public List<SmiRevision> getRevisions() {
            IRevision[] iRevisions = this.getMIBModule().getRevisions();
            ArrayList<SmiRevisionImpl> revisionList = new ArrayList<SmiRevisionImpl>(iRevisions.length);
            for (IRevision revision : iRevisions) {
                revisionList.add(new SmiRevisionImpl(revision));
            }
            return Collections.unmodifiableList(revisionList);
        }

        @Override
        public List<SmiImport> getImports() {
            ArrayList<SmiImportImpl> smiImports = new ArrayList<SmiImportImpl>();
            for (MIBImport mibImport : this.getMIBModule().getImportsVector()) {
                smiImports.add(new SmiImportImpl(mibImport));
            }
            return Collections.unmodifiableList(smiImports);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getObjectNames() {
            if (this.objectNames == null) {
                SmiModuleIdentityImpl smiModuleIdentityImpl = this;
                synchronized (smiModuleIdentityImpl) {
                    if (this.objectNames == null) {
                        Vector<MIBObject> mibObjects = this.getMIBModule().getObjectsVector();
                        ArrayList<String> smiObjectName = new ArrayList<String>(mibObjects.size());
                        for (MIBObject mibObject : mibObjects) {
                            smiObjectName.add(mibObject.getName());
                        }
                        this.objectNames = Collections.unmodifiableList(smiObjectName);
                    }
                }
            }
            return this.objectNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getTextualConventionNames() {
            if (this.textualConventions == null) {
                SmiModuleIdentityImpl smiModuleIdentityImpl = this;
                synchronized (smiModuleIdentityImpl) {
                    if (this.textualConventions == null) {
                        Vector<MIBTextualConvention> mibTextualConventions = this.getMIBModule().getTextualConventions();
                        ArrayList<String> smiTextualConventions = new ArrayList<String>(mibTextualConventions.size());
                        for (MIBTextualConvention tc : mibTextualConventions) {
                            smiTextualConventions.add(tc.getName());
                        }
                        this.textualConventions = Collections.unmodifiableList(smiTextualConventions);
                    }
                }
            }
            return this.textualConventions;
        }

        @Override
        public String getSourceFilename() {
            return this.getMIBModule().getFileName();
        }

        @Override
        public String getModuleName() {
            return this.getMIBModule().getModuleName();
        }

        @Override
        public String[] getAsn1Comments() {
            return new String[]{this.getMIBModule().getCopyrightComment(), this.getMIBModule().getComment(), this.getMIBModule().getInlineComment(), this.getMIBModule().getCopyrightCommentEnd()};
        }

        @Override
        public String getSmiModuleDefinition() {
            return ((MIBModule)this.mibObject).toSMI(1, SmiManagerBridge.this.repository, "\n");
        }
    }

    private class SmiGroupImpl
    extends SmiObjectImpl
    implements SmiGroup {
        public SmiGroupImpl(MIBGroup mibObject, OID oid) {
            super(mibObject, oid);
        }

        @Override
        public SmiGroupType getGroupType() {
            return ((MIBGroup)this.mibObject).isObjectGroup() ? SmiGroupType.OBJECT_GROUP : SmiGroupType.NOTIFICATION_GROUP;
        }

        @Override
        public List<String> getObjectNames() {
            return Arrays.asList(((MIBGroup)this.mibObject).getObjects());
        }
    }

    private class SmiObjectTypeIndexImpl
    extends SmiObjectTypeImpl
    implements SmiObjectTypeIndex {
        private SmiObjectType tableEntry;
        private SmiIndexInfo indexInfo;

        private SmiObjectTypeIndexImpl(SmiObjectType tableEntry, MIBObjectType mibObjectType, IndexStruct indexStruct, OID oid) {
            super(mibObjectType, oid);
            this.tableEntry = tableEntry;
            this.indexInfo = new SmiIndexInfoImpl(indexStruct);
        }

        @Override
        public SmiIndexInfo getIndexInfo() {
            return this.indexInfo;
        }

        private class SmiIndexInfoImpl
        implements SmiIndexInfo {
            private IndexStruct indexStruct;

            private SmiIndexInfoImpl(IndexStruct indexStruct) {
                this.indexStruct = indexStruct;
            }

            @Override
            public boolean hasImpliedLength() {
                return this.indexStruct.impliedLength;
            }

            @Override
            public int getMinLength() {
                return this.indexStruct.minLength;
            }

            @Override
            public int getMaxLength() {
                return this.indexStruct.maxLength;
            }

            @Override
            public int getSnmpSyntax() {
                return ValueConverter.getSnmpSyntax(this.indexStruct.baseType);
            }

            @Override
            public SmiObjectType getTableEntry() {
                return SmiObjectTypeIndexImpl.this.tableEntry;
            }
        }
    }

    private class SmiObjectTypeImpl
    extends SmiObjectImpl
    implements SmiObjectType {
        private SmiSyntax syntax;

        private SmiObjectTypeImpl(MIBObjectType mibObject, OID oid) {
            super(mibObject, oid);
        }

        @Override
        public MaxAccess getMaxAccess() {
            return MaxAccess.fromSmiValue(((MIBObjectType)this.mibObject).getAccess());
        }

        @Override
        public String getUnits() {
            return MIBObject.getUnquotedString(((MIBObjectType)this.mibObject).getUnits());
        }

        @Override
        public int getMaxValueLength() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.getSyntax() != null) {
                MIBTextualConvention tc = SmiManagerBridge.this.repository.getEffectiveSyntax(ot.getSyntax());
                MIBSyntax s = tc.getSyntax();
                if (s.getSyntax().equals("INTEGER") || s.getSyntax().equals("Integer32") || s.getSyntax().equals("Counter") || s.getSyntax().equals("Counter32") || s.getSyntax().equals("Counter64") || s.getSyntax().equals("UInteger32") || s.getSyntax().equals("Unsigned32") || s.getSyntax().equals("Gauge") || s.getSyntax().equals("Gauge32") || s.getSyntax().equals("TimeTicks") || s.getSyntax().equals("TimeStamp")) {
                    if (s.hasEnums() && OctetStringDefaultFormat.MIB == SmiManagerBridge.this.getOctetStringDisplayHint()) {
                        return s.getMaxEnumLabelLength();
                    }
                    long maxValue = (long)(Math.pow(2.0, 32.0) - 1.0);
                    if (s.hasRanges()) {
                        maxValue = s.getMaxOfRanges();
                    }
                    if (tc.hasDisplayHint()) {
                        String txt = ValueConverter.formatLong(maxValue, MIBObject.getUnquotedString(tc.getDisplayHint()));
                        if (txt == null) {
                            return (int)Math.log10(maxValue) + 1;
                        }
                        return txt.length();
                    }
                    Variable value = AbstractVariable.createFromSyntax(this.getSmiSyntax());
                    if (value instanceof AssignableFromInteger) {
                        ((AssignableFromInteger)((Object)value)).setValue((int)maxValue);
                    } else if (value instanceof AssignableFromLong) {
                        ((AssignableFromLong)((Object)value)).setValue(maxValue);
                    }
                    String txt = SmiManagerBridge.this.format(this.getOID(), value, false);
                    if (txt == null) {
                        return (int)Math.log10(maxValue) + 1;
                    }
                    return txt.length();
                }
                if (s.getSyntax().equals("IpAddress")) {
                    return 15;
                }
                if (s.getSyntax().equals("NetworkAddress")) {
                    return 15;
                }
                if (s.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                    switch (SmiManagerBridge.this.getOidFormat()) {
                        case ObjectNameNumIndex: {
                            return 74;
                        }
                    }
                    return 1279;
                }
                if (s.getSyntax().startsWith("OCTET") || s.getSyntax().startsWith("BITS") || s.getSyntax().startsWith("Opaque")) {
                    long maxValue = 32767L;
                    if (s.hasRanges()) {
                        maxValue = s.getMaxOfRanges();
                    }
                    return (int)maxValue;
                }
            }
            return -1;
        }

        @Override
        public int getMinValueLength() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.getSyntax() != null) {
                MIBTextualConvention tc = SmiManagerBridge.this.repository.getEffectiveSyntax(ot.getSyntax());
                MIBSyntax s = tc.getSyntax();
                if (s.getSyntax().equals("INTEGER") || s.getSyntax().equals("Integer32") || s.getSyntax().equals("Counter") || s.getSyntax().equals("Counter32") || s.getSyntax().equals("Counter64") || s.getSyntax().equals("UInteger32") || s.getSyntax().equals("Unsigned32") || s.getSyntax().equals("Gauge") || s.getSyntax().equals("Gauge32") || s.getSyntax().equals("TimeTicks") || s.getSyntax().equals("TimeStamp")) {
                    if (s.hasEnums() && OctetStringDefaultFormat.MIB == SmiManagerBridge.this.getOctetStringDisplayHint()) {
                        return s.getMinEnumLabelLength();
                    }
                    long minValue = 0L;
                    if (s.hasRanges()) {
                        minValue = s.getMinOfRanges();
                    }
                    if (tc.hasDisplayHint()) {
                        String txt = ValueConverter.formatLong(minValue, tc.getDisplayHint());
                        if (txt == null) {
                            return 0;
                        }
                        return txt.length();
                    }
                    Variable value = AbstractVariable.createFromSyntax(this.getSmiSyntax());
                    if (value instanceof AssignableFromInteger) {
                        ((AssignableFromInteger)((Object)value)).setValue((int)minValue);
                    } else if (value instanceof AssignableFromLong) {
                        ((AssignableFromLong)((Object)value)).setValue(minValue);
                    }
                    String txt = SmiManagerBridge.this.format(this.getOID(), value, false);
                    if (txt == null) {
                        return 0;
                    }
                    return txt.length();
                }
                if (s.getSyntax().equals("IpAddress")) {
                    return 7;
                }
                if (s.getSyntax().equals("NetworkAddress")) {
                    return 7;
                }
                if (s.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                    return 1;
                }
                if (s.getSyntax().startsWith("OCTET") || s.getSyntax().startsWith("BITS") || s.getSyntax().startsWith("Opaque")) {
                    long minValue = 0L;
                    if (s.hasRanges()) {
                        minValue = s.getMinOfRanges();
                    }
                    return (int)minValue;
                }
            }
            return -1;
        }

        @Override
        public String getDefaultValue() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            return ot.getDefaultValue();
        }

        @Override
        public Variable getDefaultVariable() {
            return this.getVariable(true);
        }

        @Override
        public Variable createNewVariable() {
            return this.getVariable(false);
        }

        private Variable getVariable(boolean onlyDefault) {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            ValueConverter vc = SmiManagerBridge.this.createValueConverter(ot);
            Variable variable = ValueConverter.getDefaultValue(SmiManagerBridge.this.repository, ot, vc.getEffectiveSyntax());
            if (!onlyDefault && variable == null) {
                variable = AbstractVariable.createFromSyntax(ValueConverter.getSnmpSyntax(vc.getSMISyntax()));
            }
            return variable;
        }

        @Override
        public SmiType getType() {
            return SmiManagerBridge.this.getSmiType((MIBObjectType)this.mibObject);
        }

        @Override
        public SmiSyntax getSyntax() {
            if (this.syntax == null) {
                MIBSyntax mibSyntax = ((MIBObjectType)this.mibObject).getSyntax();
                SmiSyntaxType smiSyntaxType = SmiManagerBridge.getSyntaxType(mibSyntax);
                SmiSyntaxImpl resolvedSyntax = null;
                String resolvedDisplayHint = null;
                if (mibSyntax != null) {
                    MIBTextualConvention effectiveSyntax = SmiManagerBridge.this.repository.getEffectiveSyntax(mibSyntax);
                    if (smiSyntaxType == SmiSyntaxType.CONVENTION && effectiveSyntax != null) {
                        resolvedSyntax = new SmiSyntaxImpl(effectiveSyntax.getSyntax().getSyntax(), SmiManagerBridge.getSyntaxType(effectiveSyntax.getSyntax()), this.getSmiSyntax(), SmiManagerBridge.this.getSmiSyntaxElementList(effectiveSyntax.getSyntax()));
                        resolvedDisplayHint = effectiveSyntax.getDisplayHint();
                    }
                    List elementList = SmiManagerBridge.this.getSmiSyntaxElementList(mibSyntax);
                    this.syntax = new SmiSyntaxImpl(mibSyntax.getSyntax(), smiSyntaxType, this.getSmiSyntax(), elementList, resolvedSyntax, resolvedDisplayHint);
                }
            }
            return this.syntax;
        }

        @Override
        public List<SmiObjectType> getColumns() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.hasIndexPart()) {
                Vector<? extends MIBObjectType> columns = SmiManagerBridge.this.repository.getColumnarObjectsOfTable(ot, false, true);
                ArrayList<SmiObjectTypeImpl> colSmiObjects = new ArrayList<SmiObjectTypeImpl>(columns.size());
                for (MIBObjectType mIBObjectType : columns) {
                    colSmiObjects.add(new SmiObjectTypeImpl(mIBObjectType, new OID(mIBObjectType.getPrintableOid())));
                }
                return Collections.unmodifiableList(colSmiObjects);
            }
            return null;
        }

        @Override
        public List<SmiObjectTypeIndex> getIndexObjects() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.hasIndexPart()) {
                IndexStruct[] indexStructs = ot.getIndexPart().getIndexStruct(SmiManagerBridge.this.repository);
                Vector<? extends MIBObjectType> columns = SmiManagerBridge.this.repository.getColumnarObjectsOfTable(ot, true, false);
                ArrayList<SmiObjectTypeIndexImpl> colSmiObjects = new ArrayList<SmiObjectTypeIndexImpl>(columns.size());
                for (int i2 = 0; i2 < columns.size() && i2 < indexStructs.length; ++i2) {
                    MIBObjectType mibObjectType = (MIBObjectType)columns.get(i2);
                    IndexStruct indexStruct = indexStructs[i2];
                    colSmiObjects.add(new SmiObjectTypeIndexImpl(this, mibObjectType, indexStruct, new OID(mibObjectType.getPrintableOid())));
                }
                return Collections.unmodifiableList(colSmiObjects);
            }
            return null;
        }
    }

    private class SmiTextualConventionImpl
    extends SmiObjectImpl
    implements SmiTextualConvention,
    SmiValueType {
        private SmiSyntax syntax;

        private SmiTextualConventionImpl(MIBTextualConvention mibObject) {
            super(mibObject, null);
        }

        @Override
        public SmiSyntax getSyntax() {
            MIBSyntax mibSyntax;
            if (this.syntax == null && (mibSyntax = ((MIBTextualConvention)this.mibObject).getSyntax()) != null) {
                this.syntax = new SmiSyntaxImpl(mibSyntax.getSyntax(), SmiManagerBridge.getSyntaxType(mibSyntax), this.getSmiSyntax(), SmiManagerBridge.this.getSmiSyntaxElementList(mibSyntax));
            }
            return this.syntax;
        }

        @Override
        public String getDisplayHint() {
            return MIBObject.getUnquotedString(((MIBTextualConvention)this.mibObject).getDisplayHint());
        }

        @Override
        public List<SmiObject> getChildren() {
            return null;
        }

        @Override
        public SmiObject getParent() {
            return null;
        }
    }

    private class SmiObjectImpl
    implements SmiObject {
        protected MIBObject mibObject;
        private OID oid;
        private Integer smiSyntax;

        private SmiObjectImpl(MIBObject mibObject, OID oid) {
            this.mibObject = mibObject;
            this.oid = oid;
        }

        @Override
        public String getObjectName() {
            return this.mibObject.getName();
        }

        @Override
        public OID getOID() {
            return this.oid;
        }

        @Override
        public int getSmiSyntax() {
            MIBObjectType ot;
            if (this.smiSyntax == null && this.mibObject instanceof MIBObjectType && (ot = (MIBObjectType)this.mibObject).getSyntax() != null) {
                MIBTextualConvention effectiveSyntax = SmiManagerBridge.this.repository.getEffectiveSyntax(ot.getSyntax());
                this.smiSyntax = SmiManagerBridge.getSnmpSyntax(SMI.smiSyntax(effectiveSyntax.getSyntax().getSyntax()));
            }
            return this.smiSyntax == null ? 0 : this.smiSyntax;
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.mibObject.getDescription());
        }

        @Override
        public SmiType getType() {
            return SmiType.fromJasmiType(this.mibObject.getType());
        }

        public List<SmiObject> getChildren() {
            ArrayList<SmiObject> children = new ArrayList<SmiObject>();
            for (MIBObject mIBObject : SmiManagerBridge.this.repository.getChildren(this.mibObject)) {
                children.add(SmiManagerBridge.this.createSmiObject(mIBObject, new OID(mIBObject.getOid().toString())));
            }
            return Collections.unmodifiableList(children);
        }

        @Override
        public SmiObject getParent() {
            ObjectID objectID = this.mibObject.getOid();
            MIBObject parent = SmiManagerBridge.this.repository.getNextParent(objectID);
            if (parent != null) {
                return SmiManagerBridge.this.createSmiObject(parent, new OID(parent.getPrintableOid()));
            }
            return null;
        }

        @Override
        public String getReference() {
            return this.mibObject.getReference();
        }

        @Override
        public SmiStatus getStatus() {
            return SmiStatus.valueOf(this.mibObject.getStatus());
        }

        @Override
        public String[] getAsn1Comments() {
            return new String[]{this.mibObject.getComment(), this.mibObject.getInlineComment()};
        }

        public String toString() {
            return this.mibObject.toSMI(1, 2, SmiManagerBridge.this.repository, "\n");
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            SmiObjectImpl smiObject = (SmiObjectImpl)o2;
            return !(this.mibObject == null ? smiObject.mibObject != null : !this.mibObject.equals(smiObject.mibObject));
        }

        public int hashCode() {
            return this.mibObject != null ? this.mibObject.hashCode() : 0;
        }
    }

    private static class CachedNamedInputStream
    extends NamedInputStream {
        private static final int BUF_SIZE = 16384;
        private byte[] fileContent;
        private String zipFileName;

        private static List<CachedNamedInputStream> createCachedStreams(NamedInputStream namedInputStream) throws IOException {
            if (namedInputStream.getZipFormat() == NamedInputStream.ZipFormat.ZIP) {
                ZipEntry zipEntry;
                ArrayList<CachedNamedInputStream> zipEntries = new ArrayList<CachedNamedInputStream>();
                ZipInputStream zipInputStream = new ZipInputStream(namedInputStream.getInputStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    zipEntries.add(new CachedNamedInputStream(CachedNamedInputStream.getFileContent(zipInputStream), zipEntry.getName(), namedInputStream.getName()));
                }
                return zipEntries;
            }
            return Collections.singletonList(new CachedNamedInputStream(CachedNamedInputStream.getFileContent(namedInputStream.getInputStream()), namedInputStream.getName(), null));
        }

        private String getZipFileName() {
            return this.zipFileName;
        }

        private CachedNamedInputStream(InputStream inputStream, String name, NamedInputStream.ZipFormat zipFormat) {
            super(inputStream, name, zipFormat);
        }

        private CachedNamedInputStream(byte[] fileContent, String name, String zipFileName) {
            super(null, name, NamedInputStream.ZipFormat.none);
            this.fileContent = fileContent;
            this.zipFileName = zipFileName;
        }

        private static byte[] getFileContent(InputStream inputStream) throws IOException {
            int read;
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((read = bis.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            return buffer.toByteArray();
        }

        public InputStream getCachedInputStream() throws IOException {
            if (this.fileContent == null) {
                InputStream is = this.getInputStream();
                this.fileContent = CachedNamedInputStream.getFileContent(is);
            }
            return new ByteArrayInputStream(this.fileContent);
        }
    }

    private class RepositoryAdapter
    implements ExtRepsitoryListener {
        private RepositoryAdapter() {
        }

        @Override
        public void writeModule(RepositoryEvent repositoryEvent) {
            this.afterReadModule(repositoryEvent);
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (SmiManagerBridge.this.repositoryDriver != null) {
                SmiManagerBridge.this.repositoryDriver.writeModule(repositoryIO);
                repositoryEvent.setUseDefaults(false);
                repositoryEvent.setOutputStream(repositoryIO.getOutputStream());
            } else {
                repositoryEvent.setUseDefaults(true);
            }
        }

        @Override
        public void readModule(RepositoryEvent repositoryEvent) {
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (SmiManagerBridge.this.repositoryDriver != null) {
                SmiManagerBridge.this.repositoryDriver.readModule(repositoryIO);
                repositoryEvent.setInputStream(repositoryIO.getInputStream());
                repositoryEvent.setUseDefaults(false);
            } else {
                repositoryEvent.setUseDefaults(true);
            }
        }

        @Override
        public void deleteModule(RepositoryEvent repositoryEvent) {
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (SmiManagerBridge.this.repositoryDriver != null) {
                SmiManagerBridge.this.repositoryDriver.deleteModule(repositoryIO);
                repositoryEvent.setModuleDeleted(repositoryIO.isModuleDeleted());
                repositoryEvent.setUseDefaults(false);
            } else {
                repositoryEvent.setUseDefaults(true);
            }
        }

        @Override
        public String[] listModuleNames() {
            if (SmiManagerBridge.this.repositoryDriver != null) {
                return SmiManagerBridge.this.repositoryDriver.listModuleNames();
            }
            try {
                return SmiManagerBridge.this.repositoryManager.getModuleNamesFromDirectory();
            }
            catch (IOException iox) {
                logger.error("Unable to read MIB repository: " + iox.getMessage(), iox);
                return null;
            }
        }

        @Override
        public void afterReadModule(RepositoryEvent repositoryEvent) {
        }
    }

    public static enum NonPrintableStringFormat {
        asIs('\u0000', 0),
        hex(':', 16),
        decimal('.', 10),
        octal(':', 8),
        binary(':', 2);

        private char separator;
        private int radix;

        private NonPrintableStringFormat(char separator, int radix) {
            this.separator = separator;
            this.radix = radix;
        }

        public int getRadix() {
            return this.radix;
        }

        public char getSeparator() {
            return this.separator;
        }
    }

    public static enum OIDFormat {
        Numbers,
        ObjectNameNumIndex,
        ObjectNameAndDecodedIndex,
        ObjectNameAndDecodedIndex4RoundTrip;

    }

    public static enum OctetStringDefaultFormat {
        MIB(""),
        ASCII("255a"),
        Hexadecimal("1x:"),
        Decimal("1d."),
        Binary("1b:");

        private String displayHint;

        private OctetStringDefaultFormat(String displayHint) {
            this.displayHint = displayHint;
        }

        public String getDisplayHint() {
            return this.displayHint;
        }
    }
}

