/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import com.snmp4j.smi.SmiError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompilationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String a;
    private List<String> b;
    private List<SmiError> c;
    private String d;

    /*
     * WARNING - void declaration
     */
    public CompilationResult(String fileName, List<String> moduleNames, List<SmiError> smiErrorList) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CompilationResult(String fileName, List<String> moduleNames, List<SmiError> smiErrorList, String zipFileName) {
        this((String)var1_1, (List<String>)var2_2, (List<SmiError>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.d = zipFileName;
    }

    public String getFileName() {
        return this.a;
    }

    public String getZipFileName() {
        return this.d;
    }

    public List<String> getModuleNames() {
        return this.b;
    }

    public List<SmiError> getSmiErrorList() {
        return this.c;
    }

    public boolean hasErrors() {
        return this.c != null && !this.c.isEmpty();
    }

    public static boolean hasErrors(List<CompilationResult> compilationResults) {
        Iterator<CompilationResult> iterator = compilationResults.iterator();
        while (iterator.hasNext()) {
            if (!((CompilationResult)iterator.next()).hasErrors()) continue;
            return true;
        }
        return false;
    }

    public static List<String> getFailedFiles(List<CompilationResult> compilationResults) {
        Iterator<CompilationResult> iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            CompilationResult compilationResult = (CompilationResult)iterator.next();
            if (!compilationResult.hasErrors()) continue;
            arrayList.add(compilationResult.getFileName());
        }
        return arrayList;
    }

    public static List<String> getModuleNames(List<CompilationResult> compilationResults) {
        Iterator<CompilationResult> iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            CompilationResult compilationResult = (CompilationResult)iterator.next();
            arrayList.addAll(compilationResult.getModuleNames());
        }
        return arrayList;
    }

    public String toString() {
        return "CompilationResult{fileName='" + this.a + '\'' + ", moduleNames=" + this.b + ", smiErrorList=" + this.c + ", zipFileName='" + this.d + '\'' + '}';
    }
}

