/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.os.Unix;

class Linux
extends Unix {
    private static final String[] HOSTNAME_LOCATIONS = new String[]{"/bin/hostname", "/usr/bin/hostname"};
    private static final String[] CMD_HOSTNAME_LINUX = new String[]{Linux.getHostNameUtil(), "--fqdn"};
    public static final String OS_NAME = "linux";
    private static final Logger logger = Logger.getLogger();

    Linux() {
    }

    public String getName() {
        return OS_NAME;
    }

    public String getHostName() {
        if (hostname == null) {
            String string = Linux.executeCommand(CMD_HOSTNAME_LINUX).trim();
            if (string == null || string.length() == 0) {
                string = super.getHostName();
            }
            hostname = string;
            logger.debug(this, "(" + Linux.getHostNameUtil() + " --fqdn) Determined that the native hostname is '" + hostname + "'");
        }
        return hostname;
    }

    protected boolean matches(String string, String string2) {
        return string.indexOf(OS_NAME) != -1;
    }

    private static String getHostNameUtil() {
        return Linux.getUtilPath(HOSTNAME_LOCATIONS, "hostname");
    }
}

