/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.InvalidLicenseException;
import com.sitraka.licensing.LicenseCollection;
import com.sitraka.licensing.LicenseProperties;
import com.sitraka.licensing.util.I18n;
import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.PropertyUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public abstract class AbstractLicenses
implements LicenseCollection {
    protected TreeMap map = new TreeMap();
    protected static final Logger logger = Logger.getLogger();

    public int size() {
        return this.map.size();
    }

    public int getSize() {
        return this.map.size();
    }

    public boolean add(LicenseProperties licenseProperties) throws InvalidLicenseException {
        if (licenseProperties == null) {
            throw new InvalidLicenseException("license properties may not be null");
        }
        if (!licenseProperties.isValid()) {
            throw new InvalidLicenseException("LicenseProperties is not valid");
        }
        return this.map.put(licenseProperties.getSerialNumber(), licenseProperties) == null;
    }

    public boolean remove(String string) {
        return this.map.remove(string) != null;
    }

    public LicenseProperties get(String string) {
        return (LicenseProperties)this.map.get(string);
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public void load(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String[] stringArray = new String[2];
        HashMap<Object, String> hashMap = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (hashMap != null) {
                String string2;
                Object object;
                if (string.startsWith("</license>")) {
                    object = new LicenseProperties();
                    ((LicenseProperties)object).loadFromMap(hashMap);
                    string2 = (String)hashMap.get("serial_number");
                    if (!((LicenseProperties)object).isValid()) {
                        throw new IOException(I18n.get("error.license.loading", string2, ((LicenseProperties)object).getErrorMessage()));
                    }
                    if (this.map.put(string2, object) != null) {
                        throw new IOException(I18n.get("error.license.duplicated", string2));
                    }
                    hashMap = null;
                } else {
                    logger.debug(this, "processing line = " + string);
                    if (PropertyUtils.parseLine(string, stringArray)) {
                        object = stringArray[0];
                        string2 = stringArray[1];
                        stringArray[0] = null;
                        stringArray[1] = null;
                        logger.debug(this, "Setting prop(" + (String)object + ", " + string2 + ")");
                        hashMap.put(object, string2);
                    }
                }
            } else if (string.startsWith("<license>")) {
                hashMap = new HashMap<Object, String>();
            } else {
                logger.debug(this, "Skipping line = \"" + string + "\"");
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public void store(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        Iterator iterator = this.iterator();
        bufferedWriter.write("<licenses>");
        bufferedWriter.newLine();
        while (iterator.hasNext()) {
            LicenseProperties licenseProperties = (LicenseProperties)iterator.next();
            bufferedWriter.write("<license>");
            bufferedWriter.newLine();
            licenseProperties.store(bufferedWriter);
            bufferedWriter.write("</license>");
            bufferedWriter.newLine();
        }
        bufferedWriter.write("</licenses>");
        bufferedWriter.newLine();
        bufferedWriter.close();
    }
}

