/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BinaryFunction;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.UnaryPredicate;
import com.objectspace.jgl.functions.MinusNumber;
import com.objectspace.jgl.functions.PlusNumber;
import com.objectspace.jgl.util.InsertIterator;

public final class Counting {
    private Counting() {
    }

    public static int count(InputIterator inputIterator, InputIterator inputIterator2, Object object) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        int n2 = 0;
        while (!inputIterator3.equals(inputIterator2)) {
            if (!inputIterator3.nextElement().equals(object)) continue;
            ++n2;
        }
        return n2;
    }

    public static int count(Container container, Object object) {
        return Counting.count(container.start(), container.finish(), object);
    }

    public static int countIf(InputIterator inputIterator, InputIterator inputIterator2, UnaryPredicate unaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        int n2 = 0;
        while (!inputIterator3.equals(inputIterator2)) {
            if (!unaryPredicate.execute(inputIterator3.nextElement())) continue;
            ++n2;
        }
        return n2;
    }

    public static int countIf(Container container, UnaryPredicate unaryPredicate) {
        return Counting.countIf(container.start(), container.finish(), unaryPredicate);
    }

    public static Number accumulate(InputIterator inputIterator, InputIterator inputIterator2, Number number) {
        return Counting.accumulate(inputIterator, inputIterator2, number, new PlusNumber(number.getClass()));
    }

    public static Number accumulate(Container container, Number number) {
        return Counting.accumulate(container.start(), container.finish(), number, new PlusNumber(number.getClass()));
    }

    public static Number accumulate(InputIterator inputIterator, InputIterator inputIterator2, Number number, BinaryFunction binaryFunction) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            number = (Number)binaryFunction.execute(number, inputIterator3.nextElement());
        }
        return number;
    }

    public static Number accumulate(Container container, Number number, BinaryFunction binaryFunction) {
        return Counting.accumulate(container.start(), container.finish(), number, binaryFunction);
    }

    public static OutputIterator adjacentDifference(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator) {
        return Counting.adjacentDifference(inputIterator, inputIterator2, outputIterator, new MinusNumber());
    }

    public static OutputIterator adjacentDifference(Container container, OutputIterator outputIterator) {
        return Counting.adjacentDifference(container.start(), container.finish(), outputIterator, new MinusNumber());
    }

    public static OutputIterator adjacentDifference(Container container, Container container2) {
        return Counting.adjacentDifference(container.start(), container.finish(), new InsertIterator(container2), new MinusNumber());
    }

    public static OutputIterator adjacentDifference(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, BinaryFunction binaryFunction) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        if (inputIterator.equals(inputIterator2)) {
            return outputIterator2;
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        outputIterator2.put(inputIterator3.get());
        outputIterator2.advance();
        Object e2 = inputIterator3.nextElement();
        while (!inputIterator3.equals(inputIterator2)) {
            Object e3 = inputIterator3.nextElement();
            outputIterator2.put(binaryFunction.execute(e3, e2));
            outputIterator2.advance();
            e2 = e3;
        }
        return outputIterator2;
    }

    public static OutputIterator adjacentDifference(Container container, OutputIterator outputIterator, BinaryFunction binaryFunction) {
        return Counting.adjacentDifference(container.start(), container.finish(), outputIterator, binaryFunction);
    }

    public static OutputIterator adjacentDifference(Container container, Container container2, BinaryFunction binaryFunction) {
        return Counting.adjacentDifference(container.start(), container.finish(), new InsertIterator(container2), binaryFunction);
    }
}

