/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.IntArray;
import com.objectspace.jgl.adapters.IntIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class IntBuffer
implements Sequence {
    static final int defaultValue = 0;
    int[] storage;
    int length;
    static final long serialVersionUID = 145694562369360504L;

    public IntBuffer() {
        this.clear();
    }

    public IntBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an IntBuffer with a negative size");
        }
        this.length = n2;
        this.storage = new int[this.length];
    }

    public IntBuffer(int n2, int n3) {
        this(n2);
        int n4 = 0;
        while (n4 < this.length) {
            this.storage[n4] = n3;
            ++n4;
        }
    }

    public IntBuffer(int[] nArray) {
        this(nArray, true);
    }

    IntBuffer(int[] nArray, boolean bl) {
        int[] nArray2 = nArray;
        synchronized (nArray2) {
            this.length = nArray.length;
            if (bl) {
                this.storage = new int[this.length];
                System.arraycopy(nArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = nArray;
            }
            return;
        }
    }

    public IntBuffer(IntBuffer intBuffer) {
        this(intBuffer.storage);
    }

    public synchronized Object clone() {
        return new IntBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof IntBuffer && this.equals((IntBuffer)object) || object instanceof IntArray && this.equals((IntArray)object);
    }

    public boolean equals(IntBuffer intBuffer) {
        return this.equals(new IntArray(intBuffer.storage));
    }

    public synchronized boolean equals(IntArray intArray) {
        return intArray.equals(this.storage);
    }

    public boolean equals(int[] nArray) {
        return this.equals(new IntArray(nArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "IntBuffer");
    }

    public synchronized void copy(IntBuffer intBuffer) {
        if (this == intBuffer) {
            return;
        }
        IntBuffer intBuffer2 = intBuffer;
        synchronized (intBuffer2) {
            if (intBuffer.length > this.storage.length) {
                this.storage = intBuffer.get();
            } else {
                System.arraycopy(intBuffer.storage, 0, this.storage, 0, intBuffer.length);
                int n2 = intBuffer.length;
                while (n2 < this.length) {
                    this.storage[n2] = 0;
                    ++n2;
                }
            }
            this.length = intBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(int[] nArray) {
        int[] nArray2 = nArray;
        synchronized (nArray2) {
            System.arraycopy(this.storage, 0, nArray, 0, Math.min(this.length, nArray.length));
            return;
        }
    }

    public synchronized int[] get() {
        int[] nArray = new int[this.length];
        this.copyTo(nArray);
        return nArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n2) {
        return new Integer(this.intAt(n2));
    }

    public synchronized int intAt(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        return this.storage[n2];
    }

    public synchronized void put(int n2, Object object) {
        this.put(n2, ((Number)object).intValue());
    }

    public synchronized void put(int n2, int n3) {
        ArrayAdapter.checkIndex(n2, this.length);
        this.storage[n2] = n3;
    }

    public synchronized void clear() {
        this.storage = new int[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof IntIterator)) {
            throw new IllegalArgumentException("Enumeration not an IntIterator");
        }
        if (((IntIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this IntBuffer ");
        }
        Serializable serializable = (IntIterator)enumeration;
        serializable = new Integer(serializable.buffer[serializable.index]);
        this.remove(((IntIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        Integer n3 = new Integer(this.storage[n2]);
        System.arraycopy(this.storage, n2 + 1, this.storage, n2, this.length - n2 - 1);
        this.storage[--this.length] = 0;
        return n3;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof IntIterator) || !(enumeration2 instanceof IntIterator)) {
                    throw new IllegalArgumentException("Enumeration not an IntIterator");
                }
                if (((IntIterator)enumeration).buffer != this.storage) break block4;
                IntIterator intIterator = (IntIterator)enumeration;
                IntIterator intIterator2 = (IntIterator)enumeration2;
                if (!(intIterator2 instanceof IntIterator) || intIterator.buffer != intIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((IntIterator)enumeration).index, ((IntIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.storage, n3 + 1, this.storage, n2, this.length - n3 - 1);
        int n5 = this.length - n4;
        while (n5 < this.length) {
            this.storage[n5] = 0;
            ++n5;
        }
        this.length -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("IntBuffer is empty");
        }
        Integer n2 = new Integer(this.storage[--this.length]);
        this.storage[this.length] = 0;
        return n2;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).intValue());
        return null;
    }

    public synchronized void add(int n2) {
        if (this.length == this.storage.length) {
            int[] nArray = this.getNextStorage(1);
            this.copyTo(nArray);
            this.storage = nArray;
        }
        this.storage[this.length++] = n2;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).intValue());
    }

    public void pushBack(int n2) {
        this.add(n2);
    }

    public IntIterator insert(IntIterator intIterator, Object object) {
        return this.insert(intIterator, ((Number)object).intValue());
    }

    public IntIterator insert(IntIterator intIterator, int n2) {
        this.insert(intIterator.index, n2);
        return new IntIterator(this, intIterator.index);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, ((Number)object).intValue());
    }

    public synchronized void insert(int n2, int n3) {
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.length != this.storage.length) {
            if (n2 != this.length) {
                System.arraycopy(this.storage, n2, this.storage, n2 + 1, this.length - n2);
            }
        } else {
            int[] nArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, nArray, 0, n2);
            System.arraycopy(this.storage, n2, nArray, n2 + 1, this.length - n2);
            this.storage = nArray;
        }
        this.storage[n2] = n3;
        ++this.length;
    }

    public void insert(IntIterator intIterator, int n2, Object object) {
        this.insert(intIterator, n2, ((Number)object).intValue());
    }

    public void insert(IntIterator intIterator, int n2, int n3) {
        this.insert(intIterator.index, n2, n3);
    }

    public void insert(int n2, int n3, Object object) {
        this.insert(n2, n3, ((Number)object).intValue());
    }

    public synchronized void insert(int n2, int n3, int n4) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            int[] nArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, nArray, 0, n2);
            System.arraycopy(this.storage, n2, nArray, n2 + n3, this.length - n2);
            this.storage = nArray;
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            this.storage[n5] = n4;
            ++n5;
        }
        this.length += n3;
    }

    public void insert(IntIterator intIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(intIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            int[] nArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, nArray, 0, n2);
            System.arraycopy(this.storage, n2, nArray, n2 + n3, this.length - n2);
            this.storage = nArray;
        }
        this.length += n3;
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.put(n4, forwardIterator3.nextElement());
            ++n4;
        }
    }

    public synchronized void swap(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = intBuffer;
        synchronized (intBuffer2) {
            int n2 = this.length;
            int[] nArray = this.storage;
            this.length = intBuffer.length;
            this.storage = intBuffer.storage;
            intBuffer.length = n2;
            intBuffer.storage = nArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized IntIterator begin() {
        return new IntIterator(this, 0);
    }

    public synchronized IntIterator end() {
        return new IntIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n2) {
            int[] nArray = new int[n2];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, nArray, 0, this.length);
            }
            this.storage = nArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("IntBuffer is empty");
        }
        Integer n2 = new Integer(this.storage[0]);
        this.remove(0);
        return n2;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(int n2) {
        this.insert(0, n2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n2) {
        int n3 = ((Number)object).intValue();
        int n4 = 0;
        while (n2 > 0) {
            int n5 = this.indexOf(n3);
            if (n5 < 0) break;
            --n2;
            ++n4;
            this.remove(n5);
        }
        return n4;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Number)object).intValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        IntIterator intIterator = new IntIterator(this, n2);
        IntIterator intIterator2 = new IntIterator(this, n3 + 1);
        IntIterator intIterator3 = (IntIterator)Algorithms.Removing.remove(intIterator, intIterator2, object);
        return this.remove(intIterator3.index, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).intValue(), ((Number)object2).intValue());
    }

    public int replace(int n2, int n3) {
        return this.replace(0, this.length - 1, n2, n3);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        return this.replace(n2, n3, ((Number)object).intValue(), ((Number)object2).intValue());
    }

    public synchronized int replace(int n2, int n3, int n4, int n5) {
        int n6 = this.length;
        ArrayAdapter.checkIndex(n2, n6);
        ArrayAdapter.checkIndex(n3, n6);
        n6 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == n4) {
                this.storage[n2] = n5;
                ++n6;
            }
            ++n2;
        }
        return n6;
    }

    public int count(Object object) {
        return this.count(((Number)object).intValue());
    }

    public int count(int n2) {
        return this.count(0, this.length - 1, n2);
    }

    public int count(int n2, int n3, Object object) {
        return this.count(n2, n3, ((Number)object).intValue());
    }

    public synchronized int count(int n2, int n3, int n4) {
        int n5 = this.length;
        ArrayAdapter.checkIndex(n2, n5);
        ArrayAdapter.checkIndex(n3, n5);
        n5 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == n4) {
                ++n5;
            }
            ++n2;
        }
        return n5;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).intValue());
    }

    public int indexOf(int n2) {
        return this.indexOf(0, this.length - 1, n2);
    }

    public int indexOf(int n2, int n3, Object object) {
        return this.indexOf(n2, n3, ((Number)object).intValue());
    }

    public synchronized int indexOf(int n2, int n3, int n4) {
        if (n3 < n2) {
            return -1;
        }
        int n5 = this.length;
        ArrayAdapter.checkIndex(n2, n5);
        ArrayAdapter.checkIndex(n3, n5);
        while (n2 < n3) {
            if (this.storage[n2] == n4) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n2) {
            this.remove(n2, this.length - 1);
            return;
        }
        if (this.length < n2) {
            this.insert(this.length, n2 - this.length, 0);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).intValue());
    }

    public boolean contains(int n2) {
        return this.indexOf(n2) != -1;
    }

    private int[] getNextStorage(int n2) {
        int n3 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n2);
        int[] nArray = new int[n3];
        return nArray;
    }

    static int asInt(Object object) {
        return ((Number)object).intValue();
    }
}

