/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.FloatArray;
import com.objectspace.jgl.adapters.FloatIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class FloatBuffer
implements Sequence {
    static final float defaultValue = 0.0f;
    float[] storage;
    int length;
    static final long serialVersionUID = -8621530464035268438L;

    public FloatBuffer() {
        this.clear();
    }

    public FloatBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an FloatBuffer with a negative size");
        }
        this.length = n2;
        this.storage = new float[this.length];
    }

    public FloatBuffer(int n2, float f2) {
        this(n2);
        int n3 = 0;
        while (n3 < this.length) {
            this.storage[n3] = f2;
            ++n3;
        }
    }

    public FloatBuffer(float[] fArray) {
        this(fArray, true);
    }

    FloatBuffer(float[] fArray, boolean bl) {
        float[] fArray2 = fArray;
        synchronized (fArray2) {
            this.length = fArray.length;
            if (bl) {
                this.storage = new float[this.length];
                System.arraycopy(fArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = fArray;
            }
            return;
        }
    }

    public FloatBuffer(FloatBuffer floatBuffer) {
        this(floatBuffer.storage);
    }

    public synchronized Object clone() {
        return new FloatBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof FloatBuffer && this.equals((FloatBuffer)object) || object instanceof FloatArray && this.equals((FloatArray)object);
    }

    public boolean equals(FloatBuffer floatBuffer) {
        return this.equals(new FloatArray(floatBuffer.storage));
    }

    public synchronized boolean equals(FloatArray floatArray) {
        return floatArray.equals(this.storage);
    }

    public boolean equals(float[] fArray) {
        return this.equals(new FloatArray(fArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "FloatBuffer");
    }

    public synchronized void copy(FloatBuffer floatBuffer) {
        if (this == floatBuffer) {
            return;
        }
        FloatBuffer floatBuffer2 = floatBuffer;
        synchronized (floatBuffer2) {
            if (floatBuffer.length > this.storage.length) {
                this.storage = floatBuffer.get();
            } else {
                System.arraycopy(floatBuffer.storage, 0, this.storage, 0, floatBuffer.length);
                int n2 = floatBuffer.length;
                while (n2 < this.length) {
                    this.storage[n2] = 0.0f;
                    ++n2;
                }
            }
            this.length = floatBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(float[] fArray) {
        float[] fArray2 = fArray;
        synchronized (fArray2) {
            System.arraycopy(this.storage, 0, fArray, 0, Math.min(this.length, fArray.length));
            return;
        }
    }

    public synchronized float[] get() {
        float[] fArray = new float[this.length];
        this.copyTo(fArray);
        return fArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n2) {
        return new Float(this.floatAt(n2));
    }

    public synchronized float floatAt(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        return this.storage[n2];
    }

    public synchronized void put(int n2, Object object) {
        this.put(n2, ((Number)object).floatValue());
    }

    public synchronized void put(int n2, float f2) {
        ArrayAdapter.checkIndex(n2, this.length);
        this.storage[n2] = f2;
    }

    public synchronized void clear() {
        this.storage = new float[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof FloatIterator)) {
            throw new IllegalArgumentException("Enumeration not an FloatIterator");
        }
        if (((FloatIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this FloatBuffer ");
        }
        Serializable serializable = (FloatIterator)enumeration;
        serializable = new Float(serializable.buffer[serializable.index]);
        this.remove(((FloatIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        Float f2 = new Float(this.storage[n2]);
        System.arraycopy(this.storage, n2 + 1, this.storage, n2, this.length - n2 - 1);
        this.storage[--this.length] = 0.0f;
        return f2;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof FloatIterator) || !(enumeration2 instanceof FloatIterator)) {
                    throw new IllegalArgumentException("Enumeration not an FloatIterator");
                }
                if (((FloatIterator)enumeration).buffer != this.storage) break block4;
                FloatIterator floatIterator = (FloatIterator)enumeration;
                FloatIterator floatIterator2 = (FloatIterator)enumeration2;
                if (!(floatIterator2 instanceof FloatIterator) || floatIterator.buffer != floatIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((FloatIterator)enumeration).index, ((FloatIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.storage, n3 + 1, this.storage, n2, this.length - n3 - 1);
        int n5 = this.length - n4;
        while (n5 < this.length) {
            this.storage[n5] = 0.0f;
            ++n5;
        }
        this.length -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("FloatBuffer is empty");
        }
        Float f2 = new Float(this.storage[--this.length]);
        this.storage[this.length] = 0.0f;
        return f2;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).floatValue());
        return null;
    }

    public synchronized void add(float f2) {
        if (this.length == this.storage.length) {
            float[] fArray = this.getNextStorage(1);
            this.copyTo(fArray);
            this.storage = fArray;
        }
        this.storage[this.length++] = f2;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).floatValue());
    }

    public void pushBack(float f2) {
        this.add(f2);
    }

    public FloatIterator insert(FloatIterator floatIterator, Object object) {
        return this.insert(floatIterator, ((Number)object).floatValue());
    }

    public FloatIterator insert(FloatIterator floatIterator, float f2) {
        this.insert(floatIterator.index, f2);
        return new FloatIterator(this, floatIterator.index);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, ((Number)object).floatValue());
    }

    public synchronized void insert(int n2, float f2) {
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.length != this.storage.length) {
            if (n2 != this.length) {
                System.arraycopy(this.storage, n2, this.storage, n2 + 1, this.length - n2);
            }
        } else {
            float[] fArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, fArray, 0, n2);
            System.arraycopy(this.storage, n2, fArray, n2 + 1, this.length - n2);
            this.storage = fArray;
        }
        this.storage[n2] = f2;
        ++this.length;
    }

    public void insert(FloatIterator floatIterator, int n2, Object object) {
        this.insert(floatIterator, n2, ((Number)object).floatValue());
    }

    public void insert(FloatIterator floatIterator, int n2, float f2) {
        this.insert(floatIterator.index, n2, f2);
    }

    public void insert(int n2, int n3, Object object) {
        this.insert(n2, n3, ((Number)object).floatValue());
    }

    public synchronized void insert(int n2, int n3, float f2) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            float[] fArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, fArray, 0, n2);
            System.arraycopy(this.storage, n2, fArray, n2 + n3, this.length - n2);
            this.storage = fArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.storage[n4] = f2;
            ++n4;
        }
        this.length += n3;
    }

    public void insert(FloatIterator floatIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(floatIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            float[] fArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, fArray, 0, n2);
            System.arraycopy(this.storage, n2, fArray, n2 + n3, this.length - n2);
            this.storage = fArray;
        }
        this.length += n3;
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.put(n4, forwardIterator3.nextElement());
            ++n4;
        }
    }

    public synchronized void swap(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = floatBuffer;
        synchronized (floatBuffer2) {
            int n2 = this.length;
            float[] fArray = this.storage;
            this.length = floatBuffer.length;
            this.storage = floatBuffer.storage;
            floatBuffer.length = n2;
            floatBuffer.storage = fArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized FloatIterator begin() {
        return new FloatIterator(this, 0);
    }

    public synchronized FloatIterator end() {
        return new FloatIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n2) {
            float[] fArray = new float[n2];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, fArray, 0, this.length);
            }
            this.storage = fArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("FloatBuffer is empty");
        }
        Float f2 = new Float(this.storage[0]);
        this.remove(0);
        return f2;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(float f2) {
        this.insert(0, f2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n2) {
        float f2 = ((Number)object).floatValue();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(f2);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Number)object).floatValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        FloatIterator floatIterator = new FloatIterator(this, n2);
        FloatIterator floatIterator2 = new FloatIterator(this, n3 + 1);
        FloatIterator floatIterator3 = (FloatIterator)Algorithms.Removing.remove(floatIterator, floatIterator2, object);
        return this.remove(floatIterator3.index, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).floatValue(), ((Number)object2).floatValue());
    }

    public int replace(float f2, float f3) {
        return this.replace(0, this.length - 1, f2, f3);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        return this.replace(n2, n3, ((Number)object).floatValue(), ((Number)object2).floatValue());
    }

    public synchronized int replace(int n2, int n3, float f2, float f3) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == f2) {
                this.storage[n2] = f3;
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int count(Object object) {
        return this.count(((Number)object).floatValue());
    }

    public int count(float f2) {
        return this.count(0, this.length - 1, f2);
    }

    public int count(int n2, int n3, Object object) {
        return this.count(n2, n3, ((Number)object).floatValue());
    }

    public synchronized int count(int n2, int n3, float f2) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == f2) {
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).floatValue());
    }

    public int indexOf(float f2) {
        return this.indexOf(0, this.length - 1, f2);
    }

    public int indexOf(int n2, int n3, Object object) {
        return this.indexOf(n2, n3, ((Number)object).floatValue());
    }

    public synchronized int indexOf(int n2, int n3, float f2) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        while (n2 < n3) {
            if (this.storage[n2] == f2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n2) {
            this.remove(n2, this.length - 1);
            return;
        }
        if (this.length < n2) {
            this.insert(this.length, n2 - this.length, 0.0f);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).floatValue());
    }

    public boolean contains(float f2) {
        return this.indexOf(f2) != -1;
    }

    private float[] getNextStorage(int n2) {
        int n3 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n2);
        float[] fArray = new float[n3];
        return fArray;
    }

    static float asFloat(Object object) {
        return ((Number)object).floatValue();
    }
}

