/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.ByteBuffer;
import com.objectspace.jgl.adapters.ByteIterator;
import java.util.Enumeration;

public class ByteArray
extends ArrayAdapter {
    byte[] array;
    static final long serialVersionUID = -6994357424699500642L;

    public ByteArray() {
        this(new byte[0]);
    }

    public ByteArray(ByteArray byteArray) {
        this(byteArray.array);
    }

    public ByteArray(ByteBuffer byteBuffer) {
        this(byteBuffer.get());
    }

    public ByteArray(byte[] byArray) {
        this.array = byArray;
    }

    public synchronized Object clone() {
        return new ByteArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "byte[]");
    }

    public boolean equals(Object object) {
        return object instanceof ByteArray && this.equals((ByteArray)object) || object instanceof ByteBuffer && this.equals((ByteBuffer)object);
    }

    public boolean equals(ByteArray byteArray) {
        return this.equals(byteArray.array);
    }

    public boolean equals(ByteBuffer byteBuffer) {
        return this.equals(byteBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(byte[] byArray) {
        byte[] byArray2 = byArray;
        synchronized (byArray2) {
            if (this.array.length != byArray.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (this.array[n2] != byArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public byte[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized ByteIterator begin() {
        return new ByteIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized ByteIterator end() {
        return new ByteIterator(this, this.array.length);
    }

    public Object at(int n2) {
        return new Byte(this.byteAt(n2));
    }

    public synchronized byte byteAt(int n2) {
        return this.array[n2];
    }

    public void put(int n2, Object object) {
        this.put(n2, ((Number)object).byteValue());
    }

    public synchronized void put(int n2, byte by) {
        this.array[n2] = by;
    }
}

