/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PdfContentReaderTool {
    public static String getDictionaryDetail(PdfDictionary pdfDictionary) {
        return PdfContentReaderTool.getDictionaryDetail(pdfDictionary, 0);
    }

    public static String getDictionaryDetail(PdfDictionary pdfDictionary, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        ArrayList<PdfName> arrayList = new ArrayList<PdfName>();
        Object object2 = pdfDictionary.getKeys().iterator();
        while (object2.hasNext()) {
            object = (PdfName)object2.next();
            PdfObject pdfObject = pdfDictionary.getDirectObject((PdfName)object);
            if (pdfObject.isDictionary()) {
                arrayList.add((PdfName)object);
            }
            stringBuffer.append(object);
            stringBuffer.append('=');
            stringBuffer.append(pdfObject);
            stringBuffer.append(", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer.append(')');
        object = arrayList.iterator();
        while (object.hasNext()) {
            object2 = (PdfName)object.next();
            stringBuffer.append('\n');
            for (int i2 = 0; i2 < n2 + 1; ++i2) {
                stringBuffer.append('\t');
            }
            stringBuffer.append("Subdictionary ");
            stringBuffer.append(object2);
            stringBuffer.append(" = ");
            stringBuffer.append(PdfContentReaderTool.getDictionaryDetail(pdfDictionary.getAsDict((PdfName)object2), n2 + 1));
        }
        return stringBuffer.toString();
    }

    public static void listContentStreamForPage(PdfReader pdfReader, int n2, PrintWriter printWriter) throws IOException {
        int n3;
        printWriter.println("==============Page " + n2 + "====================");
        printWriter.println("- - - - - Dictionary - - - - - -");
        PdfDictionary pdfDictionary = pdfReader.getPageN(n2);
        printWriter.println(PdfContentReaderTool.getDictionaryDetail(pdfDictionary));
        printWriter.println("- - - - - Content Stream - - - - - -");
        RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
        byte[] byArray = pdfReader.getPageContent(n2, randomAccessFileOrArray);
        randomAccessFileOrArray.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while ((n3 = ((InputStream)byteArrayInputStream).read()) != -1) {
            printWriter.print((char)n3);
        }
        printWriter.println("- - - - - Text Extraction - - - - - -");
        PdfTextExtractor pdfTextExtractor = new PdfTextExtractor(pdfReader);
        String string = pdfTextExtractor.getTextFromPage(n2);
        if (string.length() != 0) {
            printWriter.println(string);
        } else {
            printWriter.println("No text found on page " + n2);
        }
        printWriter.println();
    }

    public static void listContentStream(File file, PrintWriter printWriter) throws IOException {
        PdfReader pdfReader = new PdfReader(file.getCanonicalPath());
        int n2 = pdfReader.getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            PdfContentReaderTool.listContentStreamForPage(pdfReader, i2, printWriter);
        }
    }

    public static void listContentStream(File file, int n2, PrintWriter printWriter) throws IOException {
        PdfReader pdfReader = new PdfReader(file.getCanonicalPath());
        PdfContentReaderTool.listContentStreamForPage(pdfReader, n2, printWriter);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1 || stringArray.length > 3) {
                System.out.println("Usage:  PdfContentReaderTool <pdf file> [<output file>|stdout] [<page num>]");
                return;
            }
            PrintWriter printWriter = new PrintWriter(System.out);
            if (stringArray.length >= 2 && stringArray[1].compareToIgnoreCase("stdout") != 0) {
                System.out.println("Writing PDF content to " + stringArray[1]);
                printWriter = new PrintWriter(new FileOutputStream(new File(stringArray[1])));
            }
            int n2 = -1;
            if (stringArray.length >= 3) {
                n2 = Integer.parseInt(stringArray[2]);
            }
            if (n2 == -1) {
                PdfContentReaderTool.listContentStream(new File(stringArray[0]), printWriter);
            } else {
                PdfContentReaderTool.listContentStream(new File(stringArray[0]), n2, printWriter);
            }
            printWriter.flush();
            if (stringArray.length >= 2) {
                printWriter.close();
                System.out.println("Finished writing content to " + stringArray[1]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

