/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.ByteVector;
import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import com.lowagie.text.pdf.hyphenation.SimplePatternParser;
import com.lowagie.text.pdf.hyphenation.TernaryTree;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer {
    private static final long serialVersionUID = -7763254239309429432L;
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String string) {
        int n2 = string.length();
        int n3 = (n2 & 1) == 1 ? (n2 >> 1) + 2 : (n2 >> 1) + 1;
        int n4 = this.vspace.alloc(n3);
        byte[] byArray = this.vspace.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 >> 1;
            byte by = (byte)(string.charAt(i2) - 48 + 1 & 0xF);
            byArray[n5 + n4] = (i2 & 1) == 1 ? (byte)(byArray[n5 + n4] | by) : (byte)(by << 4);
        }
        byArray[n3 - 1 + n4] = 0;
        return n4;
    }

    protected String unpackValues(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n2++);
        while (by != 0) {
            char c2 = (char)((by >>> 4) - 1 + 48);
            stringBuffer.append(c2);
            c2 = (char)(by & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001' + 48);
            stringBuffer.append(c2);
            by = this.vspace.get(n2++);
        }
        return stringBuffer.toString();
    }

    public void loadSimplePatterns(InputStream inputStream) {
        SimplePatternParser simplePatternParser = new SimplePatternParser();
        this.ivalues = new TernaryTree();
        simplePatternParser.parse(inputStream, this);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String string) {
        int n2 = super.find(string);
        if (n2 >= 0) {
            return this.unpackValues(n2);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray[n2] == cArray2[n3]) {
            if (cArray[n2] == '\u0000') {
                return 0;
            }
            ++n2;
            ++n3;
        }
        if (cArray2[n3] == '\u0000') {
            return 0;
        }
        return cArray[n2] - cArray2[n3];
    }

    protected byte[] getValues(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n2++);
        while (by != 0) {
            char c2 = (char)((by >>> 4) - 1);
            stringBuffer.append(c2);
            c2 = (char)(by & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001');
            stringBuffer.append(c2);
            by = this.vspace.get(n2++);
        }
        byte[] byArray = new byte[stringBuffer.length()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)stringBuffer.charAt(i2);
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n2, byte[] byArray) {
        int n3 = n2;
        char c2 = cArray[n3];
        char c3 = this.root;
        block0: while (c3 > '\u0000' && c3 < this.sc.length) {
            int n4;
            int n5;
            byte[] byArray2;
            if (this.sc[c3] == '\uffff') {
                if (this.hstrcmp(cArray, n3, this.kv.getArray(), this.lo[c3]) == 0) {
                    byArray2 = this.getValues(this.eq[c3]);
                    n5 = n2;
                    for (n4 = 0; n4 < byArray2.length; ++n4) {
                        if (n5 < byArray.length && byArray2[n4] > byArray[n5]) {
                            byArray[n5] = byArray2[n4];
                        }
                        ++n5;
                    }
                }
                return;
            }
            n5 = c2 - this.sc[c3];
            if (n5 == 0) {
                if (c2 == '\u0000') break;
                c2 = cArray[++n3];
                char c4 = c3 = this.eq[c3];
                while (c4 > '\u0000' && c4 < this.sc.length && this.sc[c4] != '\uffff') {
                    if (this.sc[c4] == '\u0000') {
                        byArray2 = this.getValues(this.eq[c4]);
                        n4 = n2;
                        for (int i2 = 0; i2 < byArray2.length; ++i2) {
                            if (n4 < byArray.length && byArray2[i2] > byArray[n4]) {
                                byArray[n4] = byArray2[i2];
                            }
                            ++n4;
                        }
                        continue block0;
                    }
                    c4 = this.lo[c4];
                }
                continue;
            }
            c3 = n5 < 0 ? this.lo[c3] : this.hi[c3];
        }
    }

    public Hyphenation hyphenate(String string, int n2, int n3) {
        char[] cArray = string.toCharArray();
        return this.hyphenate(cArray, 0, cArray.length, n2, n3);
    }

    public Hyphenation hyphenate(char[] cArray, int n2, int n3, int n4, int n5) {
        Object object;
        int n6;
        char[] cArray2 = new char[n3 + 3];
        char[] cArray3 = new char[2];
        int n7 = 0;
        int n8 = n3;
        boolean bl = false;
        for (n6 = 1; n6 <= n3; ++n6) {
            cArray3[0] = cArray[n2 + n6 - 1];
            int n9 = this.classmap.find(cArray3, 0);
            if (n9 < 0) {
                if (n6 == 1 + n7) {
                    ++n7;
                } else {
                    bl = true;
                }
                --n8;
                continue;
            }
            if (!bl) {
                cArray2[n6 - n7] = (char)n9;
                continue;
            }
            return null;
        }
        n3 = n8;
        if (n3 < n4 + n5) {
            return null;
        }
        int[] nArray = new int[n3 + 1];
        int n10 = 0;
        String string = new String(cArray2, 1, n3);
        if (this.stoplist.containsKey(string)) {
            object = (ArrayList)this.stoplist.get(string);
            int n11 = 0;
            for (n6 = 0; n6 < ((ArrayList)object).size(); ++n6) {
                Object e2 = ((ArrayList)object).get(n6);
                if (!(e2 instanceof String) || (n11 += ((String)e2).length()) < n4 || n11 >= n3 - n5) continue;
                nArray[n10++] = n11 + n7;
            }
        } else {
            cArray2[0] = 46;
            cArray2[n3 + 1] = 46;
            cArray2[n3 + 2] = '\u0000';
            object = new byte[n3 + 3];
            for (n6 = 0; n6 < n3 + 1; ++n6) {
                this.searchPatterns(cArray2, n6, (byte[])object);
            }
            for (n6 = 0; n6 < n3; ++n6) {
                if ((object[n6 + 1] & 1) != 1 || n6 < n4 || n6 > n3 - n5) continue;
                nArray[n10++] = n6 + n7;
            }
        }
        if (n10 > 0) {
            object = new int[n10];
            System.arraycopy(nArray, 0, object, 0, n10);
            return new Hyphenation(new String(cArray, n2, n3), (int[])object);
        }
        return null;
    }

    public void addClass(String string) {
        if (string.length() > 0) {
            char c2 = string.charAt(0);
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            for (int i2 = 0; i2 < string.length(); ++i2) {
                cArray[0] = string.charAt(i2);
                this.classmap.insert(cArray, 0, c2);
            }
        }
    }

    public void addException(String string, ArrayList arrayList) {
        this.stoplist.put(string, arrayList);
    }

    public void addPattern(String string, String string2) {
        int n2 = this.ivalues.find(string2);
        if (n2 <= 0) {
            n2 = this.packValues(string2);
            this.ivalues.insert(string2, (char)n2);
        }
        this.insert(string, (char)n2);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }
}

