/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.fonts.cmaps;

import com.lowagie.text.pdf.fonts.cmaps.CMap;
import com.lowagie.text.pdf.fonts.cmaps.CodespaceRange;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CMapParser {
    private static final String BEGIN_CODESPACE_RANGE = "begincodespacerange";
    private static final String BEGIN_BASE_FONT_CHAR = "beginbfchar";
    private static final String BEGIN_BASE_FONT_RANGE = "beginbfrange";
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private byte[] tokenParserByteBuffer = new byte[512];

    public CMap parse(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        CMap cMap = new CMap();
        Object object = null;
        Object object2 = null;
        while ((object2 = this.parseNextToken(pushbackInputStream)) != null) {
            if (object2 instanceof Operator) {
                Object object3;
                Object object4;
                Object object5;
                byte[] byArray;
                int n2;
                Number number;
                Operator operator2 = (Operator)object2;
                if (operator2.op.equals(BEGIN_CODESPACE_RANGE)) {
                    number = (Number)object;
                    for (n2 = 0; n2 < number.intValue(); ++n2) {
                        byArray = (byte[])this.parseNextToken(pushbackInputStream);
                        object5 = (byte[])this.parseNextToken(pushbackInputStream);
                        object4 = new CodespaceRange();
                        ((CodespaceRange)object4).setStart(byArray);
                        ((CodespaceRange)object4).setEnd((byte[])object5);
                        cMap.addCodespaceRange((CodespaceRange)object4);
                    }
                } else if (operator2.op.equals(BEGIN_BASE_FONT_CHAR)) {
                    number = (Number)object;
                    for (n2 = 0; n2 < number.intValue(); ++n2) {
                        byArray = (byte[])this.parseNextToken(pushbackInputStream);
                        object5 = this.parseNextToken(pushbackInputStream);
                        if (object5 instanceof byte[]) {
                            object4 = object5;
                            object3 = this.createStringFromBytes((byte[])object4);
                            cMap.addMapping(byArray, (String)object3);
                            continue;
                        }
                        if (object5 instanceof LiteralName) {
                            cMap.addMapping(byArray, ((LiteralName)object5).name);
                            continue;
                        }
                        throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + object5);
                    }
                } else if (operator2.op.equals(BEGIN_BASE_FONT_RANGE)) {
                    number = (Number)object;
                    for (n2 = 0; n2 < number.intValue(); ++n2) {
                        byArray = (byte[])this.parseNextToken(pushbackInputStream);
                        object5 = (byte[])this.parseNextToken(pushbackInputStream);
                        object4 = this.parseNextToken(pushbackInputStream);
                        object3 = null;
                        byte[] byArray2 = null;
                        if (object4 instanceof List) {
                            object3 = (List)object4;
                            byArray2 = (byte[])object3.get(0);
                        } else {
                            byArray2 = (byte[])object4;
                        }
                        String string = null;
                        int n3 = 0;
                        boolean bl = false;
                        while (!bl) {
                            if (this.compare(byArray, (byte[])object5) >= 0) {
                                bl = true;
                            }
                            string = this.createStringFromBytes(byArray2);
                            cMap.addMapping(byArray, string);
                            this.increment(byArray);
                            if (object3 == null) {
                                this.increment(byArray2);
                                continue;
                            }
                            if (++n3 >= object3.size()) continue;
                            byArray2 = (byte[])object3.get(n3);
                        }
                    }
                }
            }
            object = object2;
        }
        return cMap;
    }

    private Object parseNextToken(PushbackInputStream pushbackInputStream) throws IOException {
        Object object = null;
        int n2 = pushbackInputStream.read();
        while (n2 == 9 || n2 == 32 || n2 == 13 || n2 == 10) {
            n2 = pushbackInputStream.read();
        }
        switch (n2) {
            case 37: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n2);
                this.readUntilEndOfLine(pushbackInputStream, stringBuffer);
                object = stringBuffer.toString();
                break;
            }
            case 40: {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = pushbackInputStream.read();
                while (n3 != -1 && n3 != 41) {
                    stringBuffer.append((char)n3);
                    n3 = pushbackInputStream.read();
                }
                object = stringBuffer.toString();
                break;
            }
            case 62: {
                int n4 = pushbackInputStream.read();
                if (n4 == 62) {
                    object = MARK_END_OF_DICTIONARY;
                    break;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                object = MARK_END_OF_ARRAY;
                break;
            }
            case 91: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Object object2 = this.parseNextToken(pushbackInputStream);
                while (object2 != MARK_END_OF_ARRAY) {
                    arrayList.add(object2);
                    object2 = this.parseNextToken(pushbackInputStream);
                }
                object = arrayList;
                break;
            }
            case 60: {
                int n5 = pushbackInputStream.read();
                if (n5 == 60) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    Object object3 = this.parseNextToken(pushbackInputStream);
                    while (object3 instanceof LiteralName && object3 != MARK_END_OF_DICTIONARY) {
                        Object object4 = this.parseNextToken(pushbackInputStream);
                        hashMap.put(((LiteralName)object3).name, object4);
                        object3 = this.parseNextToken(pushbackInputStream);
                    }
                    object = hashMap;
                    break;
                }
                int n6 = 16;
                int n7 = -1;
                while (n5 != -1 && n5 != 62) {
                    int n8 = 0;
                    if (n5 >= 48 && n5 <= 57) {
                        n8 = n5 - 48;
                    } else if (n5 >= 65 && n5 <= 70) {
                        n8 = 10 + n5 - 65;
                    } else if (n5 >= 97 && n5 <= 102) {
                        n8 = 10 + n5 - 97;
                    } else {
                        throw new IOException("Error: expected hex character and not " + (char)n5 + ":" + n5);
                    }
                    n8 *= n6;
                    if (n6 == 16) {
                        this.tokenParserByteBuffer[++n7] = 0;
                        n6 = 1;
                    } else {
                        n6 = 16;
                    }
                    int n9 = n7;
                    this.tokenParserByteBuffer[n9] = (byte)(this.tokenParserByteBuffer[n9] + n8);
                    n5 = pushbackInputStream.read();
                }
                byte[] byArray = new byte[n7 + 1];
                System.arraycopy(this.tokenParserByteBuffer, 0, byArray, 0, n7 + 1);
                object = byArray;
                break;
            }
            case 47: {
                StringBuffer stringBuffer = new StringBuffer();
                int n10 = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n10)) {
                    stringBuffer.append((char)n10);
                    n10 = pushbackInputStream.read();
                }
                object = new LiteralName(stringBuffer.toString());
                break;
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n2);
                n2 = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n2) && (Character.isDigit((char)n2) || n2 == 46)) {
                    stringBuffer.append((char)n2);
                    n2 = pushbackInputStream.read();
                }
                pushbackInputStream.unread(n2);
                String string = stringBuffer.toString();
                if (string.indexOf(46) >= 0) {
                    object = new Double(string);
                    break;
                }
                object = new Integer(stringBuffer.toString());
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)n2);
                n2 = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n2)) {
                    stringBuffer.append((char)n2);
                    n2 = pushbackInputStream.read();
                }
                object = new Operator(stringBuffer.toString());
            }
        }
        return object;
    }

    private void readUntilEndOfLine(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        int n2 = inputStream.read();
        while (n2 != -1 && n2 != 13 && n2 != 10) {
            stringBuffer.append((char)n2);
            n2 = inputStream.read();
        }
    }

    private boolean isWhitespaceOrEOF(int n2) {
        return n2 == -1 || n2 == 32 || n2 == 13 || n2 == 10;
    }

    private void increment(byte[] byArray) {
        this.increment(byArray, byArray.length - 1);
    }

    private void increment(byte[] byArray, int n2) {
        if (n2 > 0 && (byArray[n2] + 256) % 256 == 255) {
            byArray[n2] = 0;
            this.increment(byArray, n2 - 1);
        } else {
            byArray[n2] = (byte)(byArray[n2] + 1);
        }
    }

    private String createStringFromBytes(byte[] byArray) throws IOException {
        String string = null;
        string = byArray.length == 1 ? new String(byArray) : new String(byArray, "UTF-16BE");
        return string;
    }

    private int compare(byte[] byArray, byte[] byArray2) {
        int n2 = 1;
        boolean bl = false;
        for (int i2 = 0; i2 < byArray.length && !bl; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            if ((byArray[i2] + 256) % 256 < (byArray2[i2] + 256) % 256) {
                bl = true;
                n2 = -1;
                continue;
            }
            bl = true;
            n2 = 1;
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("usage: java org.pdfbox.cmapparser.CMapParser <CMAP File>");
            System.exit(-1);
        }
        CMapParser cMapParser = new CMapParser();
        CMap cMap = cMapParser.parse(new FileInputStream(stringArray[0]));
        System.out.println("Result:" + cMap);
    }

    private class Operator {
        private String op;

        private Operator(String string) {
            this.op = string;
        }
    }

    private class LiteralName {
        private String name;

        private LiteralName(String string) {
            this.name = string;
        }
    }
}

