/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntHashtable
implements Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashtable() {
        this(150, 0.75f);
    }

    public IntHashtable(int n2) {
        this(n2, 0.75f);
    }

    public IntHashtable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.loadFactor = f2;
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(int n2) {
        Entry[] entryArray = this.table;
        int n3 = entryArray.length;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                if (entry.value == n2) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(int n2) {
        return this.contains(n2);
    }

    public boolean containsKey(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        while (entry != null) {
            if (entry.hash == n3 && entry.key == n2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        while (entry != null) {
            if (entry.hash == n3 && entry.key == n2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return 0;
    }

    protected void rehash() {
        int n2 = this.table.length;
        Entry[] entryArray = this.table;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = entryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = (entry2.hash & Integer.MAX_VALUE) % n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public int put(int n2, int n3) {
        Entry[] entryArray = this.table;
        int n4 = n2;
        int n5 = (n4 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n5];
        while (entry != null) {
            if (entry.hash == n4 && entry.key == n2) {
                int n6 = entry.value;
                entry.value = n3;
                return n6;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n5 = (n4 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n5] = entry = new Entry(n4, n2, n3, entryArray[n5]);
        ++this.count;
        return 0;
    }

    public int remove(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n3 && entry.key == n2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n4] = entry.next;
                }
                --this.count;
                int n5 = entry.value;
                entry.value = 0;
                return n5;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return 0;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (--n2 >= 0) {
            entryArray[n2] = null;
        }
        this.count = 0;
    }

    public Iterator getEntryIterator() {
        return new IntHashtableIterator(this.table);
    }

    public int[] toOrderedKeys() {
        int[] nArray = this.getKeys();
        Arrays.sort(nArray);
        return nArray;
    }

    public int[] getKeys() {
        int[] nArray = new int[this.count];
        int n2 = 0;
        int n3 = this.table.length;
        Entry entry = null;
        while (true) {
            if (entry == null) {
                while (n3-- > 0 && (entry = this.table[n3]) == null) {
                }
            }
            if (entry == null) break;
            Entry entry2 = entry;
            entry = entry2.next;
            nArray[n2++] = entry2.key;
        }
        return nArray;
    }

    public int getOneKey() {
        if (this.count == 0) {
            return 0;
        }
        int n2 = this.table.length;
        Entry entry = null;
        while (n2-- > 0 && (entry = this.table[n2]) == null) {
        }
        if (entry == null) {
            return 0;
        }
        return entry.key;
    }

    public Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.table = new Entry[this.table.length];
            int n2 = this.table.length;
            while (n2-- > 0) {
                intHashtable.table[n2] = this.table[n2] != null ? (Entry)this.table[n2].clone() : null;
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static class IntHashtableIterator
    implements Iterator {
        int index;
        Entry[] table;
        Entry entry;

        IntHashtableIterator(Entry[] entryArray) {
            this.table = entryArray;
            this.index = entryArray.length;
        }

        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry entry = this.entry;
                this.entry = entry.next;
                return entry;
            }
            throw new NoSuchElementException("IntHashtableIterator");
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported.");
        }
    }

    static class Entry {
        int hash;
        int key;
        int value;
        Entry next;

        protected Entry(int n2, int n3, int n4, Entry entry) {
            this.hash = n2;
            this.key = n3;
            this.value = n4;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        protected Object clone() {
            Entry entry = new Entry(this.hash, this.key, this.value, this.next != null ? (Entry)this.next.clone() : null);
            return entry;
        }
    }
}

